/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.calltree;

import com.ez.gdb.mainframe.reports.EZGdbReportDatasource;
import com.ez.gdb.mainframe.reports.calltree.CalltreeReportsAbstractBuilder;
import com.ez.gdb.mainframe.reports.calltree.ReportDetailsGroup;
import com.ez.gdb.mainframe.reports.internal.Messages;
import com.ez.graphs.viewer.odb.utils.Utils;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.report.application.ezreport.reports.calltree.EZXYZDataset;
import com.ez.report.application.ezreport.reports.calltree.Group;
import com.ez.report.application.reports.all.EZXYDataset;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jfree.data.xy.XYZDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CalltreeReportsAbstractDS
extends EZGdbReportDatasource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CalltreeReportsAbstractDS.class);
    protected static final String ID_MARKER = "@@@@@EZLEGACY@@@@";
    protected static final String ASSTRING_MARKER = "@@@@@EZLEGACY_ASSTRING@@@@";
    protected static final String LIMIT_MARKER = "@@@@@EZLEGACY_LIMIT@@@@";
    protected static final String WHILE_MARKER = "@@@@@WHILE@EZLEGACY@@@@";
    protected String limitPart = "while $depth <= ";
    protected static final String NAME_RESTRICTIONS_MARKER = "@@@@@EZLEGACY_NAME@@@@";
    private static final String PATH_DETAILS_QUERY = "select sid, out('SourceInfo')[0].name as lastSgPath from Program where name in ( \n select name from ( select  COUNT(*) as c , name from Program where sid in @@@@@EZLEGACY@@@@\n group by name ) where c > 1) and sid in @@@@@EZLEGACY@@@@";
    private static final String PRG_DETAILS_QUERY = "select @rid.asString() as rid, ifnull(out('ProxyFor')[0].name, name) as name, out('Ancestor')[0].name as ancestor, type from ";
    protected Collection<EZEntityID> inputPrgs = null;
    protected IProgressMonitor monitor = null;
    protected Integer depthLimit = null;
    private Map<String, Set<String>> proxiesForPrg = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> nameToProxies = new HashMap<String, Set<String>>();
    private Map<String, Pair<String, List<String>>> data = null;
    private Map<String, Pair<String, List<String>>> proxyAccumulateData = new HashMap<String, Pair<String, List<String>>>();
    protected CalltreeReportsAbstractBuilder builder;
    protected String direction;
    protected boolean isForward = false;
    protected ReportDetailsGroup currentGroup = null;
    protected EZXYZDataset xydataset = new EZXYZDataset();
    protected int nrChain = 0;
    protected int maxLength = 1;
    protected int max = 1;
    protected int nrPrgs = 0;
    protected int withResults = 0;
    protected int withoutResults = 0;
    protected Set<String> usedProgramsSet = new TreeSet<String>();
    protected Map<String, Set<String>> children = new HashMap<String, Set<String>>();
    protected String[] cgRestrictions;
    protected String queryFilter = " sid ";
    protected boolean restricted = false;
    private Map<Integer, String> paths = new HashMap<Integer, String>();

    public CalltreeReportsAbstractDS(Collection<EZEntityID> inputs, Integer depthLimit, String chainDirection, CalltreeReportsAbstractBuilder builder, IProgressMonitor pmonitor) {
        this.inputPrgs = inputs != null ? new ArrayList<EZEntityID>(inputs) : null;
        this.monitor = pmonitor;
        this.builder = builder;
        this.depthLimit = depthLimit;
        this.direction = chainDirection;
        this.initNoInputs();
        this.csvWriter = this.builder.initTempCSVFile();
        this.builder.writeCSVHeader(this.csvWriter);
        this.cgRestrictions = (String[])this.builder.getParamValue("restrictedProgramNames");
    }

    @Override
    protected void prepareInputs() {
        HashSet<Integer> sids = new HashSet<Integer>();
        for (EZEntityID id : this.inputPrgs) {
            EZSourceProgramIDSg prgsg = (EZSourceProgramIDSg)id.getSegment(EZSourceProgramIDSg.class);
            sids.add(prgsg.getProgramId());
        }
        if (sids.size() > 1) {
            String query = PATH_DETAILS_QUERY.replaceAll(ID_MARKER, ((Object)sids).toString());
            CloseableIterable res = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
            for (OrientElement elem : res) {
                String path = com.ez.gdb.core.utils.Utils.replaceCharacters((String)((String)elem.getProperty("lastSgPath")));
                Integer sid = (Integer)elem.getProperty("sid");
                this.paths.put(sid, path);
            }
        }
    }

    protected void initNoInputs() {
        this.withResults = this.inputPrgs == null ? 0 : this.inputPrgs.size();
    }

    public boolean nextItem() throws JRException {
        if (this.isFirst) {
            this.beforeFirstItem();
        }
        if (this.currentGroup == null || this.currentGroup.isParsed()) {
            if (this.currentGroup != null) {
                this.xydataset.addData(this.getPlotGroup(this.currentGroup));
            }
            this.changeGroup();
            this.currentGroup = this.buildNextGroup();
            if (this.currentGroup != null) {
                this.monitor.subTask(Messages.getString(CalltreeReportsAbstractDS.class, "progressmonitor.printingchains.subtask", new String[]{this.currentGroup.prgName}));
            }
        } else {
            this.currentGroup.index = this.currentGroup.index + 1;
        }
        if (this.currentGroup != null) {
            String[] currentRow = this.currentGroup.getRow();
            ++this.nrChain;
            int length = currentRow.length - 1;
            if (length > this.maxLength) {
                this.maxLength = length;
                if (this.maxLength > this.max) {
                    this.max = this.maxLength;
                    L.debug("{} has maxLength={}", (Object)this.currentGroup.prgName, (Object)this.max);
                    this.nrPrgs = 1;
                } else if (this.maxLength == this.max) {
                    ++this.nrPrgs;
                }
            }
        } else if (this.inputPrgs == null || this.inputPrgs.isEmpty()) {
            this.closeGraph();
            this.builder.noMoreData();
            this.addFinalParams();
            this.closeCsvWriter();
        }
        return this.currentGroup != null;
    }

    public Object getFieldValue(JRField arg0) throws JRException {
        Object value = null;
        if (arg0.getName().equals("prg_name")) {
            value = this.currentGroup.prgName;
        } else if (arg0.getName().equals("chain")) {
            value = this.currentGroup.getRowAsString();
            List<String> tmp = this.currentGroup.getRowAsList();
            this.restricted = this.cgRestrictions != null && tmp.size() == 1 ? ((String)value).endsWith(" !") : false;
            this.writeRowToCSV();
            this.currentGroup.removeRow();
        } else if (arg0.getName().equals("count")) {
            value = !this.restricted;
        }
        L.trace("fieldName: {} = ({}) {}", new Object[]{arg0.getName(), this.currentGroup.prgName, value});
        return value;
    }

    protected ReportDetailsGroup buildNextGroup() {
        ReportDetailsGroup gr = null;
        if (this.inputPrgs != null && !this.inputPrgs.isEmpty()) {
            Iterator<EZEntityID> it = this.inputPrgs.iterator();
            while (gr == null && it.hasNext()) {
                EZEntityID id = it.next();
                EZSourceProgramIDSg prgsg = (EZSourceProgramIDSg)id.getSegment(EZSourceProgramIDSg.class);
                String prg = prgsg.getListableName();
                this.monitor.subTask(Messages.getString(CalltreeReportsAbstractDS.class, "progressmonitor.preparingchains.subtask", new String[]{prg}));
                String inptKey = this.getInptKey(prgsg);
                if (this.data != null) {
                    this.data.clear();
                }
                if (this.proxyAccumulateData != null) {
                    this.proxyAccumulateData.clear();
                }
                if (inptKey != null) {
                    try {
                        this.data = this.getData(prgsg);
                    }
                    catch (Throwable th) {
                        L.error("error getting data; graphDB will be closed", th);
                        this.closeGraph();
                        throw th;
                    }
                }
                if (this.data != null && !this.data.isEmpty()) {
                    Pair<String, List<String>> pair = this.data.get(inptKey);
                    boolean hasResults = this.isNotEmpty(pair);
                    Set<String> currChildren = null;
                    int childrenNo = -1;
                    currChildren = this.children.get(inptKey);
                    int n = childrenNo = currChildren != null ? currChildren.size() : -1;
                    if (currChildren == null) {
                        currChildren = this.children.get(inptKey);
                        int n2 = childrenNo = currChildren != null ? currChildren.size() : -1;
                    }
                    if (!hasResults && childrenNo < 1) {
                        childrenNo = pair != null && pair.getSecond() != null && !((List)pair.getSecond()).isEmpty() ? ((List)pair.getSecond()).size() : 200;
                        hasResults = this.data.keySet().size() >= childrenNo + 1;
                    } else if (!hasResults) {
                        for (String child : currChildren) {
                            pair = this.data.get(child);
                            hasResults = this.isNotEmpty(pair);
                            if (hasResults) break;
                        }
                    }
                    boolean wereRestricted = false;
                    if (currChildren != null && !currChildren.isEmpty()) {
                        for (String child : currChildren) {
                            OrientVertex ov;
                            String prgName;
                            Pair<String, List<String>> pp = this.data.get(child);
                            if (pp != null || Utils.isValidName((String)(prgName = (String)(ov = this.dbg.getVertex((Object)child)).getProperty("name")), (String[])this.cgRestrictions)) continue;
                            prgName = String.valueOf(prgName) + " !";
                            this.builder.addNameRestrictionNoteInAppendix(true);
                            wereRestricted = true;
                            prgName = String.valueOf(prgsg.getListableName()) + ":" + prgName;
                            this.addFakeData(prgName, child);
                        }
                    } else {
                        boolean bl = wereRestricted = !Utils.isValidName((String)prgsg.getProgramName(), (String[])this.cgRestrictions);
                    }
                    if (hasResults || wereRestricted) {
                        gr = new ReportDetailsGroup(this, this.direction, prgsg, inptKey, this.depthLimit, this.isForward);
                        String path = this.paths.get(prgsg.getProgramId());
                        if (path != null) {
                            gr.prgName = String.valueOf(gr.prgName) + " (" + path + ")";
                        }
                        if (currChildren != null && !currChildren.isEmpty()) {
                            if (prgsg.getTypeId() == 1) {
                                currChildren.add(inptKey);
                            }
                            gr.setChildren(currChildren);
                        }
                        if (wereRestricted && !hasResults) {
                            this.updateCountersWhenNoResults();
                        }
                    }
                }
                if (gr == null) {
                    this.updateCountersWhenNoResults();
                }
                it.remove();
            }
        }
        return gr;
    }

    private void updateCountersWhenNoResults() {
        ++this.withoutResults;
        --this.withResults;
    }

    private boolean isNotEmpty(Pair<String, List<String>> pair) {
        boolean vb;
        boolean bl = vb = pair != null && pair.getSecond() != null && !((List)pair.getSecond()).isEmpty();
        if (vb) {
            vb = ((List)pair.getSecond()).size() != 1 || ((List)pair.getSecond()).get(0) != "";
        }
        return vb;
    }

    protected void changeGroup() {
        this.currentGroup = null;
        this.nrChain = 0;
        this.maxLength = 1;
    }

    protected abstract String getQuery(EZSourceProgramIDSg var1, boolean var2);

    protected abstract String getFirstStepQuery(EZSourceProgramIDSg var1, boolean var2);

    protected abstract boolean vertexHasDirectionalEdges(Vertex var1);

    protected Map<String, Pair<String, List<String>>> getData(EZSourceProgramIDSg inpt) {
        HashMap<String, Pair<String, List<String>>> tmp = new HashMap<String, Pair<String, List<String>>>();
        HashSet<String> allCalledProxies = new HashSet<String>();
        HashSet<String> ridsToResolve = new HashSet<String>();
        boolean restrictedVisibilityStatus = WorkspacePrefUtils.getPreferenceStore().getBoolean("callgraphRestrictedNodesVisibility");
        String queryStep1 = this.getFirstStepQuery(inpt, true);
        boolean decreaseLimit = false;
        if (queryStep1 != null) {
            decreaseLimit = true;
            CloseableIterable resStep1 = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(queryStep1)).execute(new Object[0]);
            this.processResult(inpt, resStep1, tmp, allCalledProxies, ridsToResolve, restrictedVisibilityStatus);
        }
        String queryForCollectProxies = this.getFirstStepQuery(inpt, false);
        CloseableIterable resProxies = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(queryForCollectProxies)).execute(new Object[0]);
        Set<EZSourceProgramIDSg> proxiesFromStep1 = this.collectCalledProxies(resProxies);
        for (EZSourceProgramIDSg inptSg : proxiesFromStep1) {
            String query = this.getQuery(inptSg, decreaseLimit);
            if (query != null && !query.isEmpty()) {
                L.trace("executed query: {}", (Object)query);
                long startLocal = System.currentTimeMillis();
                CloseableIterable res = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
                L.debug("execute query in: {}ms", (Object)(System.currentTimeMillis() - startLocal));
                this.processResult(inpt, res, tmp, allCalledProxies, ridsToResolve, restrictedVisibilityStatus);
                continue;
            }
            L.warn("please get a query");
        }
        return tmp;
    }

    protected void processResult(EZSourceProgramIDSg inpt, CloseableIterable res, Map<String, Pair<String, List<String>>> tmp, Set<String> allCalledProxies, Set<String> ridsToResolve, boolean restrictedVisibilityStatus) {
        if (res != null && res.iterator().hasNext()) {
            String ancestor;
            boolean isInput = false;
            for (Object r : res) {
                Object proxyRids;
                OrientElement elem = (OrientElement)r;
                if (elem.getProperty("startRid") == null) break;
                String startProxyRid = ((String)elem.getProperty("startRid")).trim();
                String prgName = (String)elem.getProperty("name");
                Integer prgTypeID = (Integer)elem.getProperty("type");
                if (prgTypeID != null && prgTypeID == 19 && com.ez.mainframe.data.utils.Utils.isSCLStandardProcedure((String)prgName)) continue;
                ancestor = (String)elem.getProperty("ancestor");
                if (ancestor != null) {
                    prgName = String.valueOf(ancestor) + ":" + prgName;
                }
                isInput = prgName.equalsIgnoreCase(inpt.getListableName());
                ArrayList called = null;
                HashMap<Integer, List> programProxies = new HashMap<Integer, List>();
                HashMap<Integer, Boolean> programHasAnotherProxyWithCallchain = new HashMap<Integer, Boolean>();
                String calledProxies = (String)elem.getProperty("calledProxies");
                String calledProxiesName = (String)elem.getProperty("calledProxiesName");
                if (calledProxies != null && calledProxies.length() > 2) {
                    calledProxies = calledProxies.substring(1, calledProxies.length() - 1);
                    calledProxiesName = calledProxiesName.substring(1, calledProxiesName.length() - 1);
                    if (!calledProxies.isEmpty()) {
                        called = new ArrayList();
                        proxyRids = calledProxies.split(",");
                        String[] proxyNames = calledProxiesName.split(",");
                        HashMap<String, String> proxies = new HashMap<String, String>();
                        int i = 0;
                        while (i < ((String[])proxyRids).length) {
                            proxies.put(proxyRids[i].trim(), proxyNames[i].trim());
                            ++i;
                        }
                        for (String proxyRid : proxies.keySet()) {
                            String proxyName = (String)proxies.get(proxyRid);
                            boolean doCollectInfo = restrictedVisibilityStatus ? Utils.isValidName((String)proxyName, (String[])this.cgRestrictions) : true;
                            OrientVertex currentProxy = elem.getGraph().getVertex((Object)proxyRid);
                            Integer programSid = (Integer)currentProxy.getProperty("sid");
                            boolean currentProxyHasAdditionalEdgesInCallchain = this.vertexHasDirectionalEdges((Vertex)currentProxy);
                            if (!doCollectInfo) continue;
                            if (programProxies.containsKey(programSid)) {
                                if (currentProxyHasAdditionalEdgesInCallchain) {
                                    if (((Boolean)programHasAnotherProxyWithCallchain.get(programSid)).booleanValue()) {
                                        ((List)programProxies.get(programSid)).add(proxyRid);
                                        continue;
                                    }
                                    programProxies.compute(programSid, (k, v) -> new ArrayList()).add(proxyRid);
                                    programHasAnotherProxyWithCallchain.put(programSid, true);
                                    continue;
                                }
                                if (((Boolean)programHasAnotherProxyWithCallchain.get(programSid)).booleanValue()) continue;
                                ((List)programProxies.get(programSid)).add(proxyRid);
                                continue;
                            }
                            programProxies.compute(programSid, (k, v) -> new ArrayList()).add(proxyRid);
                            programHasAnotherProxyWithCallchain.put(programSid, currentProxyHasAdditionalEdgesInCallchain);
                        }
                        for (List proxiesRids : programProxies.values()) {
                            called.addAll(proxiesRids);
                        }
                    }
                } else {
                    L.debug("program {} doesn't call other programs", (Object)inpt.getListableName());
                }
                if (isInput) {
                    String inptKey = this.getInptKey(inpt);
                    if (tmp.containsKey(inptKey)) {
                        if (called != null) {
                            tmp.put(inptKey, (Pair<String, List<String>>)new Pair((Object)prgName, called));
                        }
                    } else {
                        tmp.put(inptKey, (Pair<String, List<String>>)new Pair((Object)prgName, called));
                    }
                    tmp.put(startProxyRid, (Pair<String, List<String>>)new Pair((Object)prgName, called));
                } else {
                    tmp.put(startProxyRid, (Pair<String, List<String>>)new Pair((Object)prgName, called));
                }
                isInput = false;
                if (called != null) {
                    allCalledProxies.addAll(called);
                }
                if ((proxyRids = this.nameToProxies.get(prgName)) == null) {
                    proxyRids = new HashSet();
                    this.nameToProxies.put(prgName, (Set<String>)proxyRids);
                }
                proxyRids.add(startProxyRid);
                this.proxiesForPrg.put(startProxyRid, (Set<String>)proxyRids);
            }
            for (String rId : allCalledProxies) {
                if (tmp.containsKey(rId)) continue;
                ridsToResolve.add(rId);
            }
            if (!ridsToResolve.isEmpty()) {
                HashSet<String> toMark = new HashSet<String>();
                if (this.builder.isMarkOnlyExpandable()) {
                    StringBuilder restrictions = Utils.getWhileRestrictions((String[])this.cgRestrictions);
                    Utils.fillExpandablePrograms((OrientBaseGraph)this.dbg, (boolean)this.isForward, ridsToResolve, (StringBuilder)restrictions, toMark);
                } else {
                    toMark.addAll(ridsToResolve);
                }
                CloseableIterable resPrg = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(PRG_DETAILS_QUERY + ridsToResolve)).execute(new Object[0]);
                for (OrientElement elem : resPrg) {
                    String prgRid = (String)elem.getProperty("rid");
                    String prgName = (String)elem.getProperty("name");
                    ancestor = (String)elem.getProperty("ancestor");
                    Integer prgTypeID = (Integer)elem.getProperty("type");
                    if (prgTypeID != null && prgTypeID == 19 && com.ez.mainframe.data.utils.Utils.isSCLStandardProcedure((String)prgName)) continue;
                    if (!Utils.isValidName((String)prgName, (String[])this.cgRestrictions)) {
                        prgName = String.valueOf(prgName) + " !";
                        this.builder.addNameRestrictionNoteInAppendix(true);
                    } else if (toMark.contains(prgRid)) {
                        prgName = String.valueOf(prgName) + " *";
                        this.builder.addLimitNoteInAppendix(true);
                    }
                    if (ancestor != null) {
                        prgName = String.valueOf(ancestor) + ":" + prgName;
                    }
                    tmp.put(prgRid, (Pair<String, List<String>>)new Pair((Object)prgName, null));
                }
                toMark.clear();
                ridsToResolve.clear();
            }
            res = null;
        } else {
            String inptRID = this.getInptKey(inpt);
            String prgName = inpt.getProgramName();
            if (!Utils.isValidName((String)prgName, (String[])this.cgRestrictions)) {
                prgName = String.valueOf(inpt.getListableName()) + " !";
                this.builder.addNameRestrictionNoteInAppendix(true);
            }
            this.addFakeData(prgName, inptRID);
        }
    }

    protected String getInptKey(EZSourceProgramIDSg inpt) {
        String inptKey = inpt.getOdbRID();
        if (inptKey == null) {
            inptKey = inpt.getProgramId() != null ? inpt.getProgramId().toString() : "-1";
        }
        return inptKey;
    }

    private void addFakeData(String prgName, String key) {
        if (this.data == null) {
            this.data = new HashMap<String, Pair<String, List<String>>>();
        }
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("");
        this.data.put(key, (Pair<String, List<String>>)new Pair((Object)prgName, tmp));
    }

    protected Map<String, String> getChildren(Map<String, Pair<String, List<String>>> tmp, Pair<String, List<String>> p) {
        HashMap<String, String> children = new HashMap<String, String>();
        for (String cRID : (List)p.getSecond()) {
            Pair<String, List<String>> pp = tmp.get(cRID);
            if (pp != null) {
                children.put((String)pp.getFirst(), cRID);
                continue;
            }
            L.debug("child not loaded; cRID={}", (Object)cRID);
        }
        return children;
    }

    @Override
    public void clear() {
        this.builder = null;
        if (this.children != null) {
            this.children.clear();
            this.children = null;
        }
        if (this.currentGroup != null) {
            this.currentGroup.clear();
            this.currentGroup = null;
        }
        if (this.xydataset != null) {
            this.xydataset.clear();
            this.xydataset = null;
        }
        if (this.inputPrgs != null) {
            this.inputPrgs.clear();
            this.inputPrgs = null;
        }
        this.usedProgramsSet.clear();
        this.proxiesForPrg.clear();
        this.nameToProxies.clear();
        super.clear();
    }

    protected void addFinalParams() {
        this.builder.h.setMax(new Integer(this.max));
        if (this.max == 1) {
            this.builder.h.setPrgs(new Integer(this.withResults));
            if (this.withResults == 0) {
                this.builder.h.setMax(new Integer(0));
            }
        } else {
            this.builder.h.setPrgs(new Integer(this.nrPrgs));
        }
        this.builder.h.setNotCalled(new Integer(this.withoutResults));
    }

    protected EZXYDataset.PlotGroup getPlotGroup(Group group) {
        EZXYZDataset eZXYZDataset = this.xydataset;
        eZXYZDataset.getClass();
        EZXYDataset.PlotGroup gr = new EZXYDataset.PlotGroup((EZXYDataset)eZXYZDataset, group.prgName);
        gr.nrChain = this.nrChain;
        gr.maxDeep = this.maxLength;
        L.trace("groupPlot: {} :: maxDeep - {}; chains: {}", new Object[]{gr.prgName, gr.maxDeep, gr.nrChain});
        return gr;
    }

    public XYZDataset getDistributionDataset() {
        return this.xydataset;
    }

    protected void writeRowToCSV() {
        if (this.csvWriter != null) {
            this.csvWriter.write(this.currentGroup.getRowAsList().toArray(new String[0]));
        }
    }

    public Set<String> getUsedProgramsSet() {
        return this.usedProgramsSet;
    }

    public void checkAndAddUsedProgram(String prgName) {
        if (prgName.endsWith(" !")) {
            prgName = prgName.substring(0, prgName.length() - 2);
        }
        if (prgName.endsWith(" *")) {
            prgName = prgName.substring(0, prgName.length() - 2);
        }
        this.usedProgramsSet.add(prgName);
    }

    protected String generateQuery(EZSourceProgramIDSg inpt, String command, boolean withSid) {
        String query = "";
        String key = this.getInptKey(inpt);
        Set<String> childIds = this.registerChildren(inpt, key, withSid);
        query = !childIds.isEmpty() ? command.replace(ID_MARKER, childIds.toString()) : command.replace(ID_MARKER, "[" + (withSid ? inpt.getProgramId() : key) + "]");
        return query;
    }

    protected Set<String> registerChildren(EZSourceProgramIDSg inpt, String inputKey, boolean withSid) {
        String inputRid = inpt.getOdbRID();
        HashSet<String> childId = new HashSet<String>();
        boolean addInput = false;
        if (inpt.getTypeId() == 1 || inpt.getTypeId() == 8 || inpt.getTypeId() == 13) {
            Set<String> cChildren = this.children.get(inputKey);
            if (cChildren == null) {
                cChildren = new HashSet<String>();
                this.children.put(inputKey, cChildren);
            }
            String q = "select ifnull(out('ProxyFor')[0].@rid, @rid).asString() as childRid, sid.asString() as childSid from ProgramProxy \n let $a=out('Ancestor')[0]  where (type=1 or type=15 or type = 16 or type = 19) ";
            CloseableIterable res = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(q = String.valueOf(q) + " and $a.type=" + inpt.getTypeId().toString() + " and $a.name = '" + inpt.getProgramName() + "'")).execute(new Object[0]);
            if (res != null) {
                for (Object r : res) {
                    OrientElement elem = (OrientElement)r;
                    String childRid = (String)elem.getProperty("childRid");
                    if (withSid) {
                        String childSid = (String)elem.getProperty("childSid");
                        childId.add(childSid);
                    } else {
                        childId.add(childRid);
                    }
                    cChildren.add(childRid);
                }
            }
            if (inpt.getTypeId() == 1) {
                addInput = true;
            } else if (childId.isEmpty()) {
                addInput = true;
            }
        } else {
            addInput = true;
        }
        if (addInput) {
            if (withSid) {
                childId.add(String.valueOf(inpt.getProgramId()));
            } else {
                childId.add(inputRid);
            }
        }
        return childId;
    }

    protected String replaceLimitMarkersInQuery(EZSourceProgramIDSg inpt, String query, boolean decreaseLimit) {
        boolean hasWhile = false;
        if (this.depthLimit != null && this.depthLimit >= 0) {
            int localLimit = this.depthLimit;
            if (decreaseLimit && this.depthLimit > 1) {
                --localLimit;
            }
            query = this.depthLimit == 0 ? query.replace(LIMIT_MARKER, "\n\twhile ($depth <= 0)") : query.replace(LIMIT_MARKER, "\n\twhile ($depth <= " + 2 * (localLimit - 1) + ")");
            hasWhile = true;
        } else {
            query = query.replace(LIMIT_MARKER, "");
        }
        StringBuilder whileRestrictions = Utils.getWhileRestrictions((String[])this.cgRestrictions);
        if (whileRestrictions != null && whileRestrictions.length() > 0) {
            String oldwhileRestrictions = whileRestrictions.toString();
            whileRestrictions = new StringBuilder(" ( " + this.queryFilter + " in " + ID_MARKER + ") or (");
            whileRestrictions.append(oldwhileRestrictions).append(")");
            query = hasWhile ? query.replace(WHILE_MARKER, " and (" + whileRestrictions + ")") : query.replace(WHILE_MARKER, "\n\twhile (" + whileRestrictions + ")");
            String ss = " and (" + oldwhileRestrictions + ") ";
            query = query.replace(NAME_RESTRICTIONS_MARKER, ss);
            query = this.generateQuery(inpt, query, false);
        } else {
            query = query.replace(NAME_RESTRICTIONS_MARKER, "");
            query = query.replace(WHILE_MARKER, "");
        }
        return query;
    }

    @Override
    protected String getProject() {
        return this.builder.getProject();
    }

    private Set<EZSourceProgramIDSg> collectCalledProxies(Object resStep1) {
        HashSet<EZSourceProgramIDSg> calledProxies = new HashSet<EZSourceProgramIDSg>();
        for (OrientElement elem : (CloseableIterable)resStep1) {
            String[] proxyRids;
            String cpStr = (String)elem.getProperty("calledProxies");
            if (cpStr == null || cpStr.length() <= 2) continue;
            if (cpStr.startsWith("[")) {
                cpStr = cpStr.substring(1, cpStr.length() - 1);
            }
            if (cpStr.isEmpty()) continue;
            HashSet<String> added = new HashSet<String>();
            String[] stringArray = proxyRids = cpStr.split(", ");
            int n = proxyRids.length;
            int n2 = 0;
            while (n2 < n) {
                String ppRid = stringArray[n2];
                if (!added.contains(ppRid)) {
                    OrientVertex ppv = this.dbg.getVertex((Object)ppRid);
                    String programName = (String)ppv.getProperty("name");
                    Integer typeId = (Integer)ppv.getProperty("type");
                    Integer programId = (Integer)ppv.getProperty("sid");
                    EZSourceProgramIDSg sg = new EZSourceProgramIDSg(programName, programId, typeId, Boolean.valueOf(true));
                    sg.setOdbRID(ppv.getId().toString());
                    calledProxies.add(sg);
                    added.add(ppRid);
                }
                ++n2;
            }
        }
        return calledProxies;
    }

    public Map<Integer, String> getPaths() {
        return this.paths;
    }

    public Pair<String, List<String>> getDataFor(String rid) {
        Pair<String, List<String>> pair;
        Pair result = this.proxyAccumulateData.get(rid);
        if (result == null && (pair = this.data.get(rid)) != null) {
            HashSet proxies = null;
            if (pair.getSecond() != null) {
                proxies = new HashSet();
                proxies.addAll((Collection)pair.getSecond());
            }
            if (this.proxiesForPrg.get(rid) != null) {
                for (String pRid : this.proxiesForPrg.get(rid)) {
                    List second;
                    if (this.data.get(pRid) == null || (second = (List)this.data.get(pRid).getSecond()) == null) continue;
                    if (proxies == null) {
                        proxies = new HashSet();
                    }
                    proxies.addAll(second);
                }
            }
            ArrayList list = null;
            if (proxies != null) {
                list = new ArrayList();
                list.addAll(proxies);
            }
            result = new Pair((Object)((String)pair.getFirst()), list);
            this.proxyAccumulateData.put(rid, (Pair<String, List<String>>)result);
        }
        return result;
    }
}

