/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.calltree;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.gdb.mainframe.reports.calltree.CalltreeReportsAbstractDS;
import com.ez.gdb.mainframe.reports.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.CSVWriter;
import com.ez.report.application.ezreport.reports.calltree.EZXYZDataset;
import com.ez.report.application.ezreport.reports.calltree.ReportBuilder;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SC3DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;

public abstract class CalltreeReportsAbstractBuilder
extends ReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Set<String> usedProgramsSet = null;

    public CalltreeReportsAbstractBuilder(String reportName) {
        this.report = null;
        this.runWithLock = false;
        this.openTransaction = false;
        this.singleProject = false;
        this.markOnlyExpandable = WorkspacePrefUtils.getPreferenceStore().getBoolean("graphHighlightedOnlyExpandableAtLimit");
    }

    protected void initialize(IProgressMonitor pmonitor) {
        Collection prgList = (Collection)this.inputs.get("input_list");
        HashSet<Integer> sids = new HashSet<Integer>();
        for (EZEntityID id : prgList) {
            EZSourceProgramIDSg prgsg = (EZSourceProgramIDSg)id.getSegment(EZSourceProgramIDSg.class);
            sids.add(prgsg.getProgramId());
        }
    }

    protected void putExternalizedParameters(Map params) {
        Collection prgList = (Collection)this.inputs.get("input_list");
        this.parameters.put("report.sum2", new Integer(prgList.size()));
        Utils.setParamsForTitle((Map)this.parameters, (String)this.project, (boolean)false, (Map)this.inputs);
        Boolean showApp = (Boolean)this.getReportModel().getProperty("show appendix");
        if (showApp != null && showApp.booleanValue()) {
            this.parameters.put("showAppendix", Boolean.TRUE);
        }
        this.parameters.put("restrictedProgramNames", this.inputs.get("restrictedProgramNames"));
        this.parameters.put("group.notexpanded.summary.lbl", Messages.getString(CalltreeReportsAbstractBuilder.class, "group.notexpanded.summary.lbl"));
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        this.csvFile = this.createTempCSVFile();
        this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        Integer cgLimitation = null;
        Boolean isCgLimited = (Boolean)this.inputs.get("is graph limited");
        if (isCgLimited != null && isCgLimited.booleanValue()) {
            cgLimitation = (Integer)this.inputs.get("limit number for graph levels");
        }
        Collection inputs = (Collection)this.inputs.get("input_list");
        this.instantiateDS(inputs, cgLimitation, pmonitor);
        Boolean showApp = (Boolean)this.getReportModel().getProperty("show appendix");
        if (showApp != null && showApp.booleanValue()) {
            this.parameters.put("appendixDS", this.buildAppendix());
        }
        return this.ds;
    }

    protected abstract void instantiateDS(Collection var1, Integer var2, IProgressMonitor var3);

    public void noMoreData() {
        Boolean showApp;
        EZXYZDataset dataset = (EZXYZDataset)((CalltreeReportsAbstractDS)this.ds).getDistributionDataset();
        if (!dataset.isEmpty()) {
            JFreeChart jfreechart = this.createScatterPlot(this.summaryChartTitle, this.xAxisLbl, this.yAxisLbl, (XYDataset)dataset, PlotOrientation.VERTICAL, false, false, false);
            jfreechart.setBackgroundPaint((Paint)Color.white);
            BufferedImage img = jfreechart.createBufferedImage(1040, 700, 520.0, 350.0, null);
            this.h.setImage((Object)img);
            this.usedProgramsSet = ((CalltreeReportsAbstractDS)this.ds).getUsedProgramsSet();
            dataset.clear();
        }
        if ((showApp = (Boolean)this.getReportModel().getProperty("show appendix")) != null && showApp.booleanValue() && (this.addLimitNoteInAppendix || this.addNameRestrictionNoteInAppendix)) {
            CalltreeReportsAbstractBuilder.fillAppendixDS4Notes((SC1DataSource)this.appendixNote, (boolean)this.addLimitNoteInAppendix, (boolean)this.markOnlyExpandable, (boolean)this.addNameRestrictionNoteInAppendix);
        }
    }

    private ElementGroupInfo buildAppendix() {
        DSFactory factory = new DSFactory();
        ElementGroupInfo appendixDS = new ElementGroupInfo("appxDS");
        String[] cgRestrictions = (String[])this.inputs.get("restrictedProgramNames");
        Boolean isCgLimited = (Boolean)this.inputs.get("is graph limited");
        if (isCgLimited != null && isCgLimited.booleanValue() || cgRestrictions != null && cgRestrictions.length > 0) {
            this.appendixNote = (SC1DataSource)factory.createDS(3);
            this.appendixNote.setList(new ArrayList());
            appendixDS.addDataSource((SubreportDataSource)this.appendixNote);
        }
        SC1DataSource dataSource = (SC1DataSource)factory.createDS(3);
        dataSource.setExtraTitle(Messages.getString(CalltreeReportsAbstractBuilder.class, "rep.inputs.descr"));
        dataSource.setLayout(6);
        ArrayList<ObjectForSubreport> list = new ArrayList<ObjectForSubreport>();
        Integer cgLimitation = null;
        if (isCgLimited != null && isCgLimited.booleanValue()) {
            cgLimitation = (Integer)this.inputs.get("limit number for graph levels");
        }
        ObjectForSubreport obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(CalltreeReportsAbstractBuilder.class, "report.depth.appendix.text"));
        if (isCgLimited != null && isCgLimited.booleanValue()) {
            obj.setExpVal(cgLimitation.toString());
        } else {
            obj.setExpVal(Messages.getString(CalltreeReportsAbstractBuilder.class, "report.depth.appendix.unlimitedvalue"));
        }
        list.add(obj);
        if (cgRestrictions != null && cgRestrictions.length > 0) {
            ArrayList<ObjectForSubreport> subreportLst = new ArrayList<ObjectForSubreport>();
            String[] stringArray = cgRestrictions;
            int n = cgRestrictions.length;
            int n2 = 0;
            while (n2 < n) {
                String restriction = stringArray[n2];
                if (!(restriction = restriction.trim()).isEmpty()) {
                    String[] results = new String[]{"", ReportsUtils.stripNonValidXMLCharacters((String)restriction, (boolean)true)};
                    ObjectForSubreport o = factory.createObj(1, results, "");
                    subreportLst.add(o);
                }
                ++n2;
            }
            if (!subreportLst.isEmpty()) {
                obj = new ObjectForSubreport();
                obj.setExp(Messages.getString(CalltreeReportsAbstractBuilder.class, "report.appendix.patterns"));
                SC3DataSource appDS = new SC3DataSource();
                appDS.setLayout(5);
                appDS.setList(subreportLst);
                obj.setSubreportDS((BaseSubreportDataSource)appDS);
                obj.setSubreportName("reports/subCols3-layout5.jasper");
                list.add(obj);
            }
        }
        Collection inputs = (Collection)this.inputs.get("input_list");
        Boolean showInputs = (Boolean)this.report.getProperty("showInputDetails");
        obj = new ObjectForSubreport();
        if (showInputs.booleanValue()) {
            obj.setExp(this.getAppendixLabel());
            SC3DataSource appDS = new SC3DataSource();
            appDS.setLayout(5);
            ArrayList<ObjectForSubreport> subreportLst = new ArrayList<ObjectForSubreport>();
            Map<Integer, String> paths = ((CalltreeReportsAbstractDS)this.ds).getPaths();
            for (EZEntityID id : inputs) {
                String toPrint = null;
                EZSourceProgramIDSg prgsg = (EZSourceProgramIDSg)id.getSegment(EZSourceProgramIDSg.class);
                if (prgsg == null) {
                    prgsg = (EZSourceSQLTableIDSg)id.getSegment(EZSourceSQLTableIDSg.class);
                    toPrint = ((EZSourceSQLTableIDSg)prgsg).getSQLTableName();
                } else {
                    EZSourceProgramIDSg sg = prgsg;
                    toPrint = sg.getListableName();
                    String path = paths.get(sg.getProgramId());
                    if (path != null) {
                        toPrint = String.valueOf(toPrint) + " (" + path + ")";
                    }
                }
                String[] results = new String[]{"", ReportsUtils.stripNonValidXMLCharacters((String)toPrint, (boolean)true)};
                ObjectForSubreport o = factory.createObj(1, results, "");
                subreportLst.add(o);
            }
            appDS.setList(subreportLst);
            obj.setSubreportDS((BaseSubreportDataSource)appDS);
            obj.setSubreportName("reports/subCols3-layout5.jasper");
        } else {
            obj.setExp(this.getShortString4Appendix());
            obj.setExpVal("" + inputs.size());
        }
        list.add(obj);
        dataSource.setList(list);
        appendixDS.addDataSource((SubreportDataSource)dataSource);
        return appendixDS;
    }

    protected String getShortString4Appendix() {
        return Messages.getString(CalltreeReportsAbstractBuilder.class, "report.inputs.short");
    }

    protected String getAppendixLabel() {
        return Messages.getString(CalltreeReportsAbstractBuilder.class, "report.inputs");
    }

    public void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            boolean hasRestrictions;
            boolean hasLimit;
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            Boolean isCgLimited = (Boolean)this.inputs.get("is graph limited");
            boolean bl = hasLimit = isCgLimited != null && isCgLimited != false;
            if (hasLimit) {
                Integer cgLimitation = (Integer)this.inputs.get("limit number for graph levels");
                csv.write(new String[]{Messages.getString(CalltreeReportsAbstractBuilder.class, "csv.options.limited", new String[]{cgLimitation.toString()})});
            } else {
                csv.write(new String[]{Messages.getString(CalltreeReportsAbstractBuilder.class, "csv.options.unlimited")});
            }
            csv.writeLine("");
            String[] cgRestrictions = (String[])this.inputs.get("restrictedProgramNames");
            boolean bl2 = hasRestrictions = cgRestrictions != null && cgRestrictions.length > 0;
            if (cgRestrictions.length == 1 && cgRestrictions[0].isEmpty()) {
                hasRestrictions = false;
            }
            Utils.writeNotePartInCSV((CSVWriter)csv, (boolean)hasLimit, (boolean)this.markOnlyExpandable, (boolean)hasRestrictions);
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.input"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.called")});
        }
    }

    protected void cleanDataSource() {
        if (this.ds != null) {
            ((CalltreeReportsAbstractDS)this.ds).clear();
            this.ds = null;
        }
    }

    protected String getProcedure() {
        return null;
    }

    protected String getSelectiveProcedure() {
        return null;
    }

    protected boolean hasSCL(EZSourceConnection conn) {
        return false;
    }

    public Set<String> getUsedProgramsSet() {
        return this.usedProgramsSet;
    }

    public void cleanMemory() {
        if (this.usedProgramsSet != null) {
            this.usedProgramsSet.clear();
            this.usedProgramsSet = null;
        }
    }

    protected Object getParamValue(String parameterName) {
        return this.parameters.get(parameterName);
    }
}

