/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports;

import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.internal.utils.CSVWriter;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EZGdbReportDatasource
extends AbstractReportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZGdbReportDatasource.class);
    protected OrientBaseGraph dbg;
    protected Properties envSettings;
    protected boolean isFirst = true;
    protected CSVWriter csvWriter;

    protected void openGraph() {
        if (this.envSettings == null) {
            this.envSettings = ConnectionUtils.getODBSettings((String)this.getProject());
        }
        this.dbg = ConnectionUtils.getNoTxGraph((Properties)this.envSettings);
    }

    protected abstract String getProject();

    public void closeDatasource() {
        this.closeGraph();
    }

    protected void closeGraph() {
        try {
            try {
                if (this.dbg != null) {
                    ConnectionUtils.releaseGraph((OrientBaseGraph)this.dbg, (Properties)this.envSettings);
                }
            }
            catch (Exception e) {
                L.error("while closing conn", (Throwable)e);
                this.envSettings = null;
                this.dbg = null;
            }
        }
        finally {
            this.envSettings = null;
            this.dbg = null;
        }
    }

    protected void beforeFirstItem() {
        this.openGraph();
        this.prepareInputs();
        this.isFirst = false;
    }

    protected void prepareInputs() {
    }

    protected void closeCsvWriter() {
        if (this.csvWriter != null) {
            this.csvWriter.close();
            this.csvWriter = null;
        }
    }

    public void clear() {
        this.closeGraph();
        this.closeCsvWriter();
    }
}

