/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.viewer.execution;

import com.ez.common.model.LogMessage;
import com.ez.eclient.configuration.Configuration;
import com.ez.eclient.configuration.service.ConfigurationService;
import com.ez.report.application.ezreport.utils.Utils;
import com.ez.report.generation.common.GenerationStatus;
import com.ez.report.generation.common.ReportOutputProvider;
import com.ez.report.generation.common.ui.ReportInfoAdapter;
import java.util.Queue;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewOutputProvider
implements ReportOutputProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ViewOutputProvider.class);
    private JasperPrint print;
    protected ReportInfoAdapter graphInfo = null;
    private RefreshRunnable reportRunn;
    private Queue<LogMessage> buildMessages;

    public GenerationStatus showResults(IProgressMonitor monitor) {
        GenerationStatus status = GenerationStatus.OK;
        if (!monitor.isCanceled()) {
            if (this.reportRunn == null) {
                this.reportRunn = new RefreshRunnable();
            }
            Display.getDefault().syncExec((Runnable)this.reportRunn);
        } else {
            status = GenerationStatus.CANCELED;
        }
        return status;
    }

    public void setDocument(JasperPrint reportDocument) {
        this.print = reportDocument;
    }

    public void setInfoAdapter(ReportInfoAdapter graphInfo) {
        this.graphInfo = graphInfo;
    }

    public void setMessages(Queue<LogMessage> messages) {
        this.buildMessages = messages;
    }

    private class RefreshRunnable
    implements Runnable {
        private RefreshRunnable() {
        }

        @Override
        public void run() {
            ViewOutputProvider.this.graphInfo.setDocument(ViewOutputProvider.this.print);
            Utils.printMessages(ViewOutputProvider.this.buildMessages);
            Configuration conf = ConfigurationService.getDefault().getConfiguration("analyses.reports");
            Boolean activateView = null;
            if (conf != null) {
                activateView = (Boolean)conf.getObject("reports.activateView");
            }
            if (activateView == null) {
                activateView = true;
            }
            if (activateView.booleanValue()) {
                IWorkbenchWindow window = null;
                IWorkbench workbench = PlatformUI.getWorkbench();
                int windowc = workbench.getWorkbenchWindowCount();
                if (windowc > 0) {
                    window = workbench.getActiveWorkbenchWindow();
                }
                if (window == null) {
                    L.warn("active window is null");
                    return;
                }
                try {
                    window.getActivePage().showView("com.ez.analysis.display.view.ReportsView", null, 1);
                }
                catch (PartInitException e) {
                    L.error("AnalysisView cannot be activated!", (Throwable)e);
                }
            }
        }
    }
}

