/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.viewer.execution;

import com.ez.common.model.LogMessage;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.preferences.PreferenceUtils;
import com.ez.report.application.ezreport.utils.Utils;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractBuilder;
import com.ez.report.application.viewer.execution.ViewOutputProvider;
import com.ez.report.generation.common.ExecutorFinishListener;
import com.ez.report.generation.common.GenerationStatus;
import com.ez.report.generation.common.ReportExecutorInterface;
import com.ez.report.generation.common.ReportInputProvider;
import com.ez.report.generation.common.ReportOutputProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportExecutor
implements ReportExecutorInterface {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportExecutor.class);
    protected ReportOutputProvider outputProvider;
    protected ReportInputProvider inputProvider;
    private AbstractReport report;
    protected AbstractBuilder builder;
    protected GenerationStatus genStatus;
    protected String reportName = "";

    public ReportExecutor(Map<String, Object> settings) {
    }

    public void generateReport(IProgressMonitor pmonitor) {
        EZReportErrorLog.log(1, 2, Messages.getString(ReportExecutor.class, "generationStarted.errorlog.infoMessage", new String[]{this.reportName}), null);
        this.genStatus = GenerationStatus.OK;
        if (this.outputProvider != null) {
            Map inputs = null;
            if (this.report == null) {
                if (this.inputProvider != null) {
                    inputs = this.inputProvider.getInputs();
                    if (inputs == null || inputs.isEmpty()) {
                        this.genStatus = GenerationStatus.CANCELED;
                    }
                } else {
                    L.error("No input provider was specified!");
                    this.genStatus = GenerationStatus.ERROR;
                }
            }
            if (this.genStatus.isOK()) {
                this.processInputs(pmonitor, inputs);
            }
        } else {
            L.error("No output provider was specified!");
            this.genStatus = GenerationStatus.ERROR;
        }
    }

    protected void processInputs(IProgressMonitor pmonitor, Map<String, Object> inputs) {
        com.ez.report.generation.common.ui.utils.Utils.addParametersFromPreferences(inputs);
        inputs.put("", Utils.getGeneratedFileProperties());
        inputs.put("", Utils.getGeneratedDirectory());
        this.checkProjectName(inputs);
        if (this.report != null && this.report.print != null) {
            this.genStatus = this.callOutputProvider(pmonitor, this.report, this.report.print, false, this.builder.getMessages());
        } else if (this.builder != null) {
            this.builder.setInputs(inputs);
            IStatus status = this.builder.execute(pmonitor);
            if (status.isOK()) {
                if (pmonitor.isCanceled()) {
                    this.fillReportViewer((IProgressMonitor)new NullProgressMonitor());
                } else {
                    this.fillReportViewer(pmonitor);
                }
            } else {
                this.genStatus = status.getSeverity() == 4 ? GenerationStatus.ERROR : GenerationStatus.CANCELED;
                Utils.printMessages(this.builder.getMessages());
            }
            if (!this.genStatus.isCanceled()) {
                EZReportErrorLog.log(1, 2, Messages.getString(ReportExecutor.class, "generationComplete.errorlog.infoMessage", new String[]{this.reportName}), null);
            }
        } else {
            L.error("Builder of report {} cannot be instantiated!", (Object)(this.report != null ? this.report.name : "unknown"));
            this.genStatus = GenerationStatus.ERROR;
        }
    }

    private void checkProjectName(Map<String, Object> inputs) {
        IPreferenceStore preferenceStore = PreferenceUtils.getPreferenceStore();
        String useCurrentOpened = preferenceStore.getString("use_current_project_name");
        L.debug("useCurrentOpenedPrjName={}", (Object)useCurrentOpened);
        if (!useCurrentOpened.equals("currentProject")) {
            String customName = preferenceStore.getString("project_name");
            inputs.put("project_name_for_cover_page", customName);
        } else {
            String prjName = (String)inputs.get("project_name");
            L.debug("prjName={}", (Object)prjName);
            inputs.put("project_name_for_cover_page", prjName);
        }
    }

    protected void fillReportViewer(IProgressMonitor pmonitor) {
        JasperPrint print = this.builder.getReportDocument();
        if (print != null) {
            print.setProperty("pdf_metadata_author", Messages.getString(ReportExecutor.class, "exportedPDF.author.property"));
            print.setProperty("pdf_metadata_title", this.reportName);
            this.genStatus = this.callOutputProvider(pmonitor, this.builder.getReportModel(), print, false, this.builder.getMessages());
            this.clearPrint(print);
        }
    }

    private void clearPrint(JasperPrint print) {
        if (print != null && print.getStylesMap() != null) {
            print.getStylesMap().clear();
            print = null;
        }
    }

    public boolean isOkToContinue() {
        return true;
    }

    private GenerationStatus callOutputProvider(IProgressMonitor pmonitor, AbstractReport model, JasperPrint print, boolean writeModelOnDisk, Queue<LogMessage> messages) {
        this.outputProvider.setDocument(print);
        ((ViewOutputProvider)this.outputProvider).setMessages(messages);
        GenerationStatus st = this.outputProvider.showResults(pmonitor);
        return st;
    }

    public void addFinishListener(ExecutorFinishListener listener) {
    }

    public void setBuilder(AbstractBuilder builder) {
        this.builder = builder;
    }

    public void setInputProvider(ReportInputProvider provider) {
        this.inputProvider = provider;
    }

    public void setOutputProvider(ViewOutputProvider provider) {
        this.outputProvider = provider;
    }

    public GenerationStatus getFinishStatus() {
        return this.genStatus;
    }

    public void setReportName(String name) {
        this.reportName = name;
    }

    public List<Runnable> getCloseHandlers() {
        Runnable runn = new Runnable(){

            @Override
            public void run() {
                ReportExecutor.this.builder.dispose();
            }
        };
        ArrayList<Runnable> lst = new ArrayList<Runnable>();
        lst.add(runn);
        return lst;
    }
}

