/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.viewer.execution;

import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.execution.BasicInputProvider;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractBuilder;
import com.ez.report.application.viewer.execution.ReportExecutor;
import com.ez.report.application.viewer.execution.ViewOutputProvider;
import com.ez.report.generation.common.GenerationStatus;
import com.ez.report.generation.common.ReportExecutorInterface;
import com.ez.report.generation.common.ReportInputProvider;
import com.ez.report.generation.common.ui.ReportAnalysis;
import com.ez.report.generation.common.ui.ReportIDSegment;
import com.ez.report.generation.common.ui.ReportJob;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EZReportJob
extends ReportJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZReportJob.class);
    private static final int MAXNAMES = 2;
    protected Map<String, Object> inputs;
    protected JLabel initialComponent;
    protected Shell shell;
    protected AbstractReport report;
    protected String reportName;
    protected String projectName;
    GenerationStatus execStatus;
    protected AbstractBuilder builder;

    public EZReportJob(String arg0, EZEntityID arg1) {
        super(arg0, arg1);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus st = Status.OK_STATUS;
        if (this.analysis == null) {
            L.warn("start a job without analysis! was previous canceled?");
            st = Status.CANCEL_STATUS;
        }
        if (st.isOK()) {
            this.jobStartTime = System.currentTimeMillis();
            L.info("{} - start time: {}", (Object)this.analysis.getType().toString(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
            ReportExecutorInterface executor = this.buildExecutor();
            executor.generateReport(monitor);
            if (this.graphInfo != null) {
                this.graphInfo.setCloseHandlers(executor.getCloseHandlers());
                Map files = this.builder.getExtraFilesToExport();
                if (files != null && !files.isEmpty()) {
                    this.graphInfo.addExportedFiles(files);
                }
            }
            this.builder.cleanMemory();
            this.builder = null;
            GenerationStatus status = executor.getFinishStatus();
            this.callFinishListeners(status);
            if (status.isCanceled()) {
                st = Status.CANCEL_STATUS;
            } else if (status.isError()) {
                st = new Status(4, "com.ez.mainframe.reports.gui", Messages.getString(EZReportJob.class, "error.status"));
            }
            long jobDuration = System.currentTimeMillis() - this.jobStartTime;
            L.info("{} - duration: {} ms.", (Object)this.analysis.getType().toString(), (Object)jobDuration);
        }
        if (this.analysis != null) {
            this.computeTabName();
        }
        return st;
    }

    protected void computeTabName() {
        String prjName = this.analysis.getContextValue("input_project_names").toString();
        Set inputs = this.analysis.getContextSetValue("inputs name string");
        StringBuffer buf = new StringBuffer();
        boolean wasTruncated = false;
        int idx = 0;
        if (inputs != null) {
            Iterator it = inputs.iterator();
            while (it.hasNext()) {
                if (idx >= 2) {
                    wasTruncated = true;
                    break;
                }
                buf.append((String)it.next());
                ++idx;
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
        }
        this.viewTabLabel = inputs == null ? Messages.getString(EZReportJob.class, "report.tab.noinputs.name", new String[]{prjName}) : (wasTruncated ? Messages.getString(EZReportJob.class, "report.tab.truncated.name", new Object[]{buf.toString(), inputs.size() - idx, prjName}) : Messages.getString(EZReportJob.class, "report.tab.name", new String[]{buf.toString(), prjName}));
    }

    protected ReportExecutorInterface buildExecutor() {
        ReportExecutor executor = this.instantiateExecutor();
        executor.setInputProvider((ReportInputProvider)new BasicInputProvider(this.inputs));
        executor.setOutputProvider(this.getOutputProvider());
        this.builder = this.getBuilder();
        executor.setBuilder(this.builder);
        executor.setReportName(this.analysis.getType().toString());
        return executor;
    }

    protected ReportExecutor instantiateExecutor() {
        return new ReportExecutor(new HashMap<String, Object>());
    }

    public ViewOutputProvider getOutputProvider() {
        ViewOutputProvider outputProvider = new ViewOutputProvider();
        outputProvider.setInfoAdapter(this.graphInfo);
        outputProvider.setDocument(this.print);
        return outputProvider;
    }

    protected abstract AbstractBuilder getBuilder();

    public void setParameters(Map<String, Object> params) {
        this.inputs = params;
        if (params != null) {
            this.reportName = (String)params.get("report_name");
            this.projectName = (String)params.get("project_name");
            this.report = (AbstractReport)params.get("report_model");
        }
    }

    protected void callFinishListeners(GenerationStatus status) {
        L.trace("callFinishListeners on {}; analysis={}; status={}", new Object[]{this, this.analysis, status});
        if (status.isOK()) {
            if (this.analysis != null) {
                this.analysis.jobFinished(null);
            } else {
                L.warn("callFinishListeners(statusOK) on a job without analysis! was previous canceled?");
            }
        } else {
            if (this.analysis != null) {
                this.analysis.cancellRequest(null);
            } else {
                L.warn("callFinishListeners({}) on a job without analysis! was previous canceled?", (Object)status.toString());
            }
            if (this.graphInfo != null) {
                this.graphInfo.close();
            } else {
                L.warn("callFinishListeners() on a job without graphInfo! was previous canceled?");
            }
        }
    }

    protected void customizeJasperPrint(JasperPrint arg0) {
    }

    public JRDataSource getDataSource() {
        return null;
    }

    public Map getReportParameters() {
        return null;
    }

    public String getReportTemplate() {
        return null;
    }

    protected boolean useScriptlet() {
        return false;
    }

    protected void initialize(EZEntityID id) {
        ReportIDSegment sg = (ReportIDSegment)id.getSegment(ReportIDSegment.class);
        if (sg != null) {
            this.analysis = (ReportAnalysis)sg.getAnalysis();
        }
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        if (this.graphInfo != null) {
            this.graphInfo.setCanvasComponent((Component)this.initialComponent);
        } else {
            L.warn("you must initialize graph info object");
        }
    }
}

