/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.viewer.execution;

import com.ez.common.model.BaseResourceInput;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Activator;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.preferences.PreferenceUtils;
import com.ez.report.application.ezreport.reports.wu.idmsUtils.IDMSInput;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.model.DDCLElementInput;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.generation.common.ui.ReportAnalysis;
import com.ez.report.generation.common.ui.ReportIDSegment;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSRecordIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSSetIDSg;
import com.ez.workspace.model.segments.EZSourceIncludeIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceResourceIDSg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EZReportAnalysis
extends ReportAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZReportAnalysis.class);
    public static final String IGNORED_PROGRAMS_KEY = "ignoredPrograms";
    protected String projectName;
    protected boolean projectIsUCMDB = false;
    protected int projectDatabasebEngine;
    protected Map<String, Object> params;
    protected AbstractReport report;
    protected boolean openProject = true;
    protected static final int DIALOG_MIN_HEIGHT = 570;
    protected static final int DIALOG_MIN_WIDTH = 700;
    public static final int INCLUDE_TYPE = -100;
    private boolean dataCollectionwithError = false;
    protected boolean filterCobolEmbedded = false;

    public void setInputs(List inputs) {
        if (inputs != null) {
            HashMap<String, ProgramInputNoGUI> tmp = new HashMap<String, ProgramInputNoGUI>();
            ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
            ArrayList<BaseMainframeResourceInput> sel = new ArrayList<BaseMainframeResourceInput>();
            HashSet<String> inputNames = new HashSet<String>();
            ProjectInfo pInfo = null;
            for (Object inpObj : inputs) {
                if (inpObj instanceof EZSourceProjectInputType) {
                    String prjName = ((EZSourceProjectInputType)inpObj).getName();
                    if (prjName != null) {
                        this.setPrjName(prjName);
                        this.addContextValue("input_project_names", prjName);
                    }
                    this.addContextValue("input_list", inputs);
                    pInfo = (ProjectInfo)((EZSourceProjectInputType)inpObj).getProperty("PROJECT_INFO");
                    com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                    this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
                    continue;
                }
                if (inpObj instanceof EZSourceProgram) {
                    EZEntityID entity = ((EZSourceProgram)inpObj).getEntID();
                    list.add(entity);
                    EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
                    if (prjSg == null) continue;
                    if (!prjSg.getProjectName().equals(this.projectName)) {
                        this.setPrjName(prjSg.getProjectName());
                        this.addContextValue("input_project_names", prjSg.getProjectName());
                        pInfo = prjSg.getProjectInfo();
                        com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                        this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
                    }
                    EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)entity.getSegment(EZSourceProgramIDSg.class);
                    String prgName = prgSg.getListableName();
                    ProgramInputNoGUI programInput = new ProgramInputNoGUI(prgSg.getProgramName(), prgSg.getTypeId(), prgSg.getProgramId());
                    programInput.setAncestorName(prgSg.getAncestorName());
                    programInput.setAncestorDBId(prgSg.getAncestorId());
                    programInput.setPath(prgSg.getPath());
                    String key = programInput.getNameNoPath().toString();
                    ProgramInputNoGUI existing = (ProgramInputNoGUI)tmp.get(key);
                    if (existing != null) {
                        existing.displayPath(true);
                        programInput.displayPath(true);
                    }
                    tmp.put(key, programInput);
                    if (programInput.getTypeCode() == 8 || programInput.getTypeCode() == 13) {
                        HashSet<String> parents = new HashSet<String>();
                        ArrayList<ProgramInputNoGUI> toComplete = new ArrayList<ProgramInputNoGUI>();
                        parents.add(programInput.getName());
                        toComplete.add(programInput);
                        this.collectDataForProgram(parents, toComplete);
                    }
                    sel.add((BaseMainframeResourceInput)programInput);
                    inputNames.add(prgName);
                    continue;
                }
                if (!(inpObj instanceof EZObjectType)) continue;
                this.processSpecificInput((EZObjectType)inpObj, list, sel, inputNames);
            }
            tmp.clear();
            tmp = null;
            if (!sel.isEmpty()) {
                this.setParams(sel);
                this.addAllContextValues(this.params);
                this.addContextValue("input_list", list);
                this.addContextValue("inputs name string", inputNames);
            }
            if (pInfo != null) {
                this.addContextValue("PROJECT_INFO", pInfo);
            }
        }
    }

    protected void processSpecificInput(EZObjectType inpObj, List<EZEntityID> list, List<BaseMainframeResourceInput> sel, Set<String> inputNames) {
        EZObjectType objType = inpObj;
        EZEntityID entity = objType.getEntID();
        list.add(entity);
        EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
        if (prjSg != null) {
            EZSourceResourceIDSg resourceSg;
            if (!prjSg.getProjectName().equals(this.projectName)) {
                this.setPrjName(prjSg.getProjectName());
                this.addContextValue("input_project_names", prjSg.getProjectName());
                ProjectInfo pInfo = prjSg.getProjectInfo();
                com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
            }
            if ((resourceSg = (EZSourceResourceIDSg)objType.getProperty("mainframe resource id sg")) == null) {
                resourceSg = (EZSourceResourceIDSg)entity.getSegment(EZSourceResourceIDSg.class);
            }
            if (resourceSg != null) {
                this.prepareInputFromResourceSg(sel, inputNames, resourceSg);
            } else {
                L.debug("resource segment id null for: {}", (Object)objType.getName());
                EZEntityID entityId = objType.getEntID();
                if (entityId != null) {
                    EZSourceDDCLElementIDSg ddclSg = (EZSourceDDCLElementIDSg)entityId.getSegment(EZSourceDDCLElementIDSg.class);
                    if (ddclSg != null) {
                        String name = ddclSg.getName();
                        L.debug("input is an ddcl element {}", (Object)name);
                        Integer type = ddclSg.getType();
                        Integer dbID = ddclSg.getId();
                        sel.add((BaseMainframeResourceInput)new DDCLElementInput(name, type, dbID));
                        inputNames.add(name);
                    }
                } else {
                    L.debug("resource or ddcl segment id null for: {}", (Object)objType.getName());
                }
            }
        }
    }

    protected void prepareInputFromResourceSg(List<BaseMainframeResourceInput> sel, Set<String> inputNames, EZSourceResourceIDSg resourceSg) {
        String name = resourceSg.getResourceName();
        if (resourceSg.isOfType(EZSourceIncludeIDSg.class)) {
            L.debug("input is include {}", (Object)name);
            int inclPathId = ((EZSourceIncludeIDSg)resourceSg).getIncludePathID();
            sel.add((BaseMainframeResourceInput)new ProgramInputNoGUI(name, Integer.valueOf(-100), Integer.valueOf(inclPathId)));
        } else if (resourceSg.isOfType(EZSourceIDMSRecordIDSg.class) || resourceSg.isOfType(EZSourceIDMSSetIDSg.class)) {
            L.debug("input is idms record or set {}", (Object)name);
            sel.add((BaseMainframeResourceInput)new IDMSInput(name));
        } else {
            sel.add((BaseMainframeResourceInput)new ProgramInputNoGUI(name));
        }
        inputNames.add(name);
    }

    protected void collectDataForProgram(final Set<String> parents, final List<ProgramInputNoGUI> toComplete) {
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(this.projectName, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor arg1) {
                    Utils.queryForProgramChildren((EZSourceConnection)conn, (Set)parents, (List)toComplete);
                }
            }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            this.dataCollectionwithError = true;
            L.error("error at executing of report", (Throwable)e);
            LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(EZReportAnalysis.class, "errorAtExecuting.logView.message"), (String)Messages.getString(EZReportAnalysis.class, "errorAtExecuting.logView.title"), (Plugin)Activator.getDefault(), (boolean)true);
        }
    }

    protected void setParams(List<BaseMainframeResourceInput> selInputs) {
        this.setParams();
        this.params.put("selected resources", selInputs);
    }

    protected void setParams() {
        this.params = this.params == null ? new HashMap() : this.params;
        this.params.put("project_name", this.projectName);
        this.params.put("report_model", this.report);
        this.params.put("show summary only", Boolean.FALSE);
        Boolean showAppendix = PreferenceUtils.getPreferenceStore().getBoolean("showAppendix");
        this.params.put("show appendix", showAppendix);
        this.params.put("all resources selected", Boolean.FALSE);
        Boolean showInputs = PreferenceUtils.getPreferenceStore().getBoolean("showInputDetails");
        this.params.put("showInputDetails", showInputs);
    }

    public EZReportAnalysis(AbstractReport model) {
        this.report = model;
    }

    protected boolean checkInputs(List inputs) {
        return inputs.size() == 1 && inputs.get(0) instanceof EZSourceProjectInputType;
    }

    public boolean filterInputs() {
        List inputs = this.getContextListValue("input_list");
        boolean[] result = new boolean[1];
        boolean[] getModel = new boolean[]{true};
        final PrepareReportWizard[] wizard = new PrepareReportWizard[]{this.getWizard()};
        if (this.checkInputs(inputs)) {
            this.filterCobolEmbedded = false;
            try {
                if (wizard[0] != null) {
                    wizard[0].setProject(this.projectName);
                    wizard[0].setWindowTitle(String.valueOf(this.projectName) + "  -  " + wizard[0].getWindowTitle());
                    wizard[0].setProjectDatabaseEngine(this.projectDatabasebEngine);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ReportWizardDialog dialog = EZReportAnalysis.this.getWizardDialog(wizard[0], wizard[0].getShell());
                            dialog.create();
                            dialog.setMinimumPageSize(700, 570);
                            dialog.open();
                        }
                    });
                    if (wizard[0].isCanceled()) {
                        getModel[0] = false;
                        result[0] = true;
                    } else {
                        this.completeSelectedPrograms(wizard[0]);
                    }
                }
            }
            catch (Exception e) {
                L.error("error at executing of report", (Throwable)e);
                LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(EZReportAnalysis.class, "errorAtExecuting.logView.message"), (String)Messages.getString(EZReportAnalysis.class, "errorAtExecuting.logView.title"), (Plugin)Activator.getDefault(), (boolean)true);
                getModel[0] = false;
                result[0] = true;
            }
            if (getModel[0]) {
                if (this.params == null) {
                    this.params = new HashMap<String, Object>();
                }
                if (wizard != null && wizard[0] != null) {
                    this.params.putAll(wizard[0].getValues());
                }
            } else {
                this.params = null;
            }
            if (this.params != null) {
                this.params.put("project_name", this.projectName);
                this.params.put("report_model", this.report);
                this.params.put("project_databaseEngine", this.projectDatabasebEngine);
                this.addAllContextValues(this.params);
                this.putDefaultParams();
            }
            if (result[0]) {
                this.notifyFinish();
            }
        }
        if (this.dataCollectionwithError) {
            result[0] = this.dataCollectionwithError;
            this.notifyFinish();
        }
        return result[0];
    }

    protected void putDefaultParams() {
    }

    protected void completeSelectedPrograms(PrepareReportWizard wizard) throws Exception {
        List sel = wizard.getList("selected resources");
        if (sel != null) {
            final HashSet<String> parents = new HashSet<String>();
            final ArrayList<ProgramInputNoGUI> toComplete = new ArrayList<ProgramInputNoGUI>();
            HashSet<String> inputNames = new HashSet<String>();
            for (Object input : sel) {
                if (input instanceof ProgramInputNoGUI) {
                    ProgramInputNoGUI inpt = (ProgramInputNoGUI)input;
                    if (inpt.getTypeCode() == 8 || inpt.getTypeCode() == 13) {
                        parents.add(inpt.getName());
                        toComplete.add(inpt);
                    }
                    inputNames.add(((ProgramInputNoGUI)input).getListableName());
                    continue;
                }
                if (!(input instanceof BaseResourceInput)) continue;
                inputNames.add(((BaseResourceInput)input).getName());
            }
            this.addContextValue("inputs name string", inputNames);
            if (!parents.isEmpty()) {
                IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler ph = service.getProjectHandler(this.projectName, null);
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor arg1) {
                        Utils.queryForProgramChildren((EZSourceConnection)conn, (Set)parents, (List)toComplete);
                    }
                }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected abstract PrepareReportWizard getWizard();

    public boolean scopeIsShared() {
        return false;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setPrjName(String name) {
        this.projectName = name;
    }

    public void mustOpenPrj(boolean openPrj) {
        this.openProject = openPrj;
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        ReportIDSegment sg = new ReportIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    public boolean equals(Object obj) {
        boolean ret;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EZReportAnalysis)) {
            return false;
        }
        EZReportAnalysis a2 = (EZReportAnalysis)((Object)obj);
        boolean bl = this.type == null && a2.getType() == null ? true : (ret = this.type != null && a2.getType() != null && this.type.equals((Object)a2.getType()));
        if (ret) {
            Map<String, Object> params2 = a2.getParams();
            ret = this.params != null && params2 != null ? this.parametersEquals(this.params, params2) : this.params == null && params2 == null;
        }
        return ret;
    }

    protected boolean parametersEquals(Map<String, Object> params1, Map<String, Object> params2) {
        boolean ret = false;
        String p1 = (String)params1.get("project_name");
        String p2 = (String)params2.get("project_name");
        if (p1 != null) {
            ret = p1.equals(p2);
        } else {
            boolean bl = ret = p2 == null;
        }
        if (ret && (ret = this.resourcesEquals(params1, params2))) {
            Boolean v1 = (Boolean)params1.get("show summary only");
            Boolean v2 = (Boolean)params2.get("show summary only");
            if (v1 != null) {
                ret = v1.equals(v2);
            } else {
                boolean bl = ret = v2 == null;
            }
            if (ret) {
                v1 = (Boolean)params1.get("show appendix");
                v2 = (Boolean)params2.get("show appendix");
                if (v1 != null) {
                    ret = v1.equals(v2);
                } else {
                    boolean bl = ret = v2 == null;
                }
                if (ret) {
                    Object app1 = params1.get("selected applications");
                    Object app2 = params2.get("selected applications");
                    if (app1 instanceof Collection && app2 instanceof Collection) {
                        Collection c1 = (Collection)app1;
                        Collection c2 = (Collection)app2;
                        if (c1 != null) {
                            ret = c1.equals(c2);
                        } else {
                            boolean bl = ret = c2 == null;
                        }
                    }
                }
                if (ret) {
                    v1 = (Boolean)params1.get("showInputDetails");
                    v2 = (Boolean)params2.get("showInputDetails");
                    ret = v1 != null ? v1.equals(v2) : v2 == null;
                }
            }
        }
        return ret;
    }

    protected boolean resourcesEquals(Map<String, Object> params1, Map<String, Object> params2) {
        boolean ret = false;
        List lst1 = (List)params1.get("selected resources");
        List lst2 = (List)params2.get("selected resources");
        ret = lst1 != null ? lst1.equals(lst2) : lst2 == null;
        return ret;
    }

    protected ReportWizardDialog getWizardDialog(PrepareReportWizard wiz, Shell shell) {
        ReportWizardDialog dialog = new ReportWizardDialog(shell, (IWizard)wiz);
        return dialog;
    }

    protected void continueAnalysisForLocal() {
        if (this.filterCobolEmbedded) {
            this.filterOutCobolEmbedded();
        }
        super.continueAnalysisForLocal();
    }

    protected void filterOutCobolEmbedded() {
        List prgList = this.getContextListValue("selected resources");
        Iterator it = prgList.iterator();
        ArrayList<BaseResourceInput> toRem = new ArrayList<BaseResourceInput>();
        ArrayList<String> toRemNames = new ArrayList<String>();
        while (it.hasNext()) {
            BaseResourceInput prg = (BaseResourceInput)it.next();
            if (prg.getTypeCode() != 1 || ((ProgramInputNoGUI)prg).getAncestorName() == null || ((ProgramInputNoGUI)prg).getAncestorName().isEmpty()) continue;
            toRem.add(prg);
            toRemNames.add(prg.getListableName());
        }
        if (!toRem.isEmpty()) {
            prgList.removeAll(toRem);
            Set names = this.getContextSetValue("inputs name string");
            names.removeAll(toRemNames);
            this.params.put(IGNORED_PROGRAMS_KEY, toRemNames);
            toRem.clear();
            toRem = null;
        }
    }

    public void addAllContextValues(Map<String, Object> context) {
        super.addAllContextValues(context);
        Collection c = (Collection)this.getContextValue("projects");
        if (c != null) {
            this.addContextValue("projects", null);
        }
    }

    protected void verifyLicenseForLocal() {
        this.continueAnalysisForLocal();
    }
}

