/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.tree.PropertiesFileFilter;
import com.ez.report.application.utils.Utils;
import java.io.File;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SaveAsDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String DEFAULT_TITLE = Messages.getString(SaveAsDialog.class, "saveAs.title");
    private static final String OVERWRITE_BUTTON = Messages.getString(SaveAsDialog.class, "overwrite.button");
    private static final int DIALOG_MIN_HEIGHT = 300;
    private static final int DIALOG_MIN_WIDTH = 400;
    private static final int SETTING_NAME_MAX_LENGTH = 40;
    protected final Color redColor = new Color(null, 255, 0, 0);
    private String settingDirectoryName;
    private Text settingNameTxt;
    private List existentSettingList;
    private String[] existentSettings;
    private String choosenSettingPathName;
    private Label errorMsgLbl;
    private Button ok_button;

    public SaveAsDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public void setSettingDirectoryName(String settingDirectoryName) {
        this.settingDirectoryName = settingDirectoryName;
    }

    public String getChoosenSettingName() {
        return this.choosenSettingPathName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DEFAULT_TITLE);
        newShell.setSize(400, 300);
        Rectangle rect = newShell.getParent().getBounds();
        newShell.setLocation(rect.x + rect.width / 4, rect.y + rect.height / 6);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        area.setLayoutData((Object)data);
        GridLayout gl = (GridLayout)area.getLayout();
        area.setLayout((Layout)gl);
        Label lbl = new Label(area, 0);
        lbl.setText(Messages.getString(SaveAsDialog.class, "saveAs.lbl"));
        lbl.setFocus();
        this.settingNameTxt = new Text(area, 2052);
        this.settingNameTxt.setTextLimit(40);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.settingNameTxt.setLayoutData((Object)data);
        this.settingNameTxt.addModifyListener((ModifyListener)new NewSettingNameListener());
        this.createExistentSettingGroup(area);
        return area;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        composite.setFont(parent.getFont());
        this.errorMsgLbl = new Label(composite, 0);
        this.errorMsgLbl.setForeground(this.redColor);
        this.errorMsgLbl.setText("");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        this.errorMsgLbl.setLayoutData((Object)data);
        Control buttonSection = super.createButtonBar(composite);
        ((GridData)buttonSection.getLayoutData()).grabExcessHorizontalSpace = true;
        this.ok_button = this.getButton(0);
        this.ok_button.setEnabled(false);
        return composite;
    }

    private void createExistentSettingGroup(Composite parent) {
        this.existentSettingList = new List(parent, 66308);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.existentSettingList.setLayoutData((Object)data);
        if (this.settingDirectoryName != null) {
            File settDirectory = new File(this.settingDirectoryName);
            this.existentSettings = settDirectory.list(new PropertiesFileFilter(false));
            if (this.existentSettings.length > 0) {
                int ii = 0;
                while (ii < this.existentSettings.length) {
                    this.existentSettings[ii] = this.existentSettings[ii].substring(0, this.existentSettings[ii].lastIndexOf("."));
                    ++ii;
                }
            }
            this.existentSettingList.setItems(this.existentSettings);
            this.existentSettingList.addSelectionListener((SelectionListener)new SelectSettingListener());
        }
    }

    public boolean close() {
        this.redColor.dispose();
        return super.close();
    }

    protected void okPressed() {
        this.choosenSettingPathName = this.settingDirectoryName.concat(File.separator).concat(this.settingNameTxt.getText().trim()).concat(".properties");
        super.okPressed();
    }

    class NewSettingNameListener
    implements ModifyListener {
        NewSettingNameListener() {
        }

        public void modifyText(ModifyEvent e) {
            String choosenSettName = SaveAsDialog.this.settingNameTxt.getText().trim();
            if (choosenSettName.length() == 0) {
                SaveAsDialog.this.errorMsgLbl.setText(Messages.getString(SaveAsDialog.class, "empty.fileName.err"));
                SaveAsDialog.this.ok_button.setEnabled(false);
                return;
            }
            if (Utils.hasIlegalCharacter((String)choosenSettName)) {
                SaveAsDialog.this.errorMsgLbl.setText(Messages.getString(SaveAsDialog.class, "illegal.fileName.err"));
                SaveAsDialog.this.ok_button.setEnabled(false);
                return;
            }
            boolean exist = false;
            int i = 0;
            while (i < SaveAsDialog.this.existentSettings.length) {
                if (SaveAsDialog.this.existentSettings[i].equalsIgnoreCase(choosenSettName.trim())) {
                    SaveAsDialog.this.existentSettingList.select(i);
                    SaveAsDialog.this.ok_button.setEnabled(true);
                    SaveAsDialog.this.ok_button.setText(OVERWRITE_BUTTON);
                    exist = true;
                    break;
                }
                ++i;
            }
            if (!exist) {
                SaveAsDialog.this.existentSettingList.deselectAll();
                SaveAsDialog.this.ok_button.setEnabled(true);
                SaveAsDialog.this.ok_button.setText(IDialogConstants.OK_LABEL);
            }
            SaveAsDialog.this.errorMsgLbl.setText("");
        }
    }

    class SelectSettingListener
    extends SelectionAdapter {
        SelectSettingListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String[] str = ((List)e.widget).getSelection();
            if (str.length > 0) {
                SaveAsDialog.this.settingNameTxt.setText(str[0]);
            }
        }
    }
}

