/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.reports.wu;

import com.ez.report.generation.common.scriptlets.HeadingsScriptlet;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRScriptletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryScriptlet
extends HeadingsScriptlet {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SummaryScriptlet.class);
    protected String STMT_FIELD_NAME = "stmt_name";
    protected String SECOND_GROUP_DISCRIMINATOR_NAME = "file_name";
    protected String FIRST_GROUP_DISCRIMINATOR_NAME = "prg_name";
    protected String FIRST_GROUP_NAME = "program";
    protected String SECOND_GROUP_NAME = "comp";
    private int mostAccessed;
    private int compAccess;
    private String accessed = "";
    String retur = "";
    Map<String, Integer> stmtOcc = new HashMap<String, Integer>();
    String prevThirdGroup = null;
    String prevSecondGroup = null;
    String prevFirstGroup = null;

    public void afterDetailEval() throws JRScriptletException {
        String stmtType = (String)this.getFieldValue(this.STMT_FIELD_NAME);
        L.debug("afterDetailEval {}", (Object)stmtType);
        boolean mustCount = true;
        String v1 = (String)this.getFieldValue(this.FIRST_GROUP_DISCRIMINATOR_NAME);
        String v2 = (String)this.getFieldValue(this.SECOND_GROUP_DISCRIMINATOR_NAME);
        String v3 = (String)this.getFieldValue(this.STMT_FIELD_NAME);
        if (v1.equalsIgnoreCase(this.prevFirstGroup) && v2.equalsIgnoreCase(this.prevSecondGroup) && v3.equalsIgnoreCase(this.prevThirdGroup)) {
            mustCount = false;
        }
        this.prevFirstGroup = v1;
        this.prevSecondGroup = v2;
        this.prevThirdGroup = v3;
        if (mustCount) {
            Integer stmtCount = (Integer)this.getFieldValue("stmt_count");
            this.compAccess += stmtCount.intValue();
            Integer occ = this.stmtOcc.get(stmtType);
            if (occ == null) {
                this.stmtOcc.put(stmtType, stmtCount);
            } else {
                int val = occ + stmtCount;
                this.stmtOcc.put(stmtType, new Integer(val));
            }
        }
    }

    public void afterGroupInit(String groupName) throws JRScriptletException {
        L.debug("afterinit {}", (Object)groupName);
        if (groupName.equalsIgnoreCase(this.SECOND_GROUP_NAME)) {
            this.accessed = (String)this.getFieldValue(this.SECOND_GROUP_DISCRIMINATOR_NAME);
        }
    }

    public void beforeGroupInit(String groupName) throws JRScriptletException {
        L.debug("beforegroupinit {}", (Object)groupName);
        if (groupName.equalsIgnoreCase(this.FIRST_GROUP_NAME)) {
            this.mostAccessed = 0;
            this.retur = "";
            this.accessed = "";
            this.compAccess = 0;
            this.stmtOcc.clear();
        } else if (groupName.equalsIgnoreCase(this.SECOND_GROUP_NAME)) {
            if (this.accessed == null || this.accessed.equals("")) {
                this.accessed = (String)this.getFieldValue(this.SECOND_GROUP_DISCRIMINATOR_NAME);
                if (this.accessed == null) {
                    this.accessed = "";
                }
            }
            if (this.compAccess > this.mostAccessed) {
                this.mostAccessed = this.compAccess;
                this.retur = this.buildMostAccFile();
                L.debug("retur: {}", (Object)this.retur);
            } else if (this.compAccess == this.mostAccessed && this.compAccess != 0) {
                this.retur = this.accessed.concat(", ").concat(this.retur);
                L.debug("retur: {}", (Object)this.retur);
            }
            this.compAccess = 0;
        }
    }

    public String getMostAcc() {
        try {
            L.debug("getmostacc; prgName: " + this.getFieldValue(this.FIRST_GROUP_DISCRIMINATOR_NAME));
            L.debug("getmostacc; fileName: " + this.getFieldValue(this.SECOND_GROUP_DISCRIMINATOR_NAME));
            L.debug("getmostacc; stmt: " + this.getFieldValue(this.STMT_FIELD_NAME));
            if (this.compAccess > this.mostAccessed) {
                this.mostAccessed = this.compAccess;
                this.retur = this.buildMostAccFile();
                L.debug("retur: {}", (Object)this.retur);
            } else if (this.compAccess == this.mostAccessed) {
                this.retur = this.accessed.concat(", ").concat(this.retur);
                L.debug("retur: {}", (Object)this.retur);
            }
        }
        catch (JRScriptletException e) {
            L.error("getMostAcc", (Throwable)e);
        }
        L.info("- getmostacc; retur: {}", (Object)this.retur);
        return this.retur;
    }

    public String getMostStmt() {
        int max = 0;
        String stmt = "";
        try {
            L.debug("getMostStmt; prgName: {}", this.getFieldValue(this.FIRST_GROUP_DISCRIMINATOR_NAME));
            L.debug("getMostStmt; fileName: {}", this.getFieldValue(this.SECOND_GROUP_DISCRIMINATOR_NAME));
            L.debug("getMostStmt; stmt: {}", this.getFieldValue(this.STMT_FIELD_NAME));
            for (String stmtName : this.stmtOcc.keySet()) {
                Integer val = this.stmtOcc.get(stmtName);
                if (val > max) {
                    max = val;
                    stmt = stmtName;
                    continue;
                }
                if (val != max) continue;
                stmt = stmt.concat(", ").concat(stmtName);
            }
        }
        catch (JRScriptletException e) {
            L.error("getMostStmt", (Throwable)e);
        }
        String ret = stmt.concat(" (").concat(String.valueOf(max)).concat(")");
        L.info("- getMostStmt; ret: {}", (Object)ret);
        return ret;
    }

    private String buildMostAccFile() {
        String result = "";
        if (this.accessed != null) {
            result = this.accessed.concat(" (").concat(String.valueOf(this.mostAccessed)).concat(")");
        }
        return result;
    }
}

