/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.properties;

import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.mainframe.model.StmtGroup;
import com.ez.mainframe.model.StmtType;
import com.ez.mainframe.model.StmtWeight;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.selection.Manager;
import com.ez.report.application.ezreport.reports.threshold.ThresholdAbstractSettingsDialog;
import com.ez.report.application.properties.ReportSettingsDialog;
import com.ez.report.application.ui.ColumnResizer;
import com.ez.report.application.ui.StmtTreeObject;
import com.ez.report.application.ui.StmtTreeViewContentProvider;
import com.ez.report.application.ui.StmtTreeViewLabelProvider;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.utils.RGB;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightSettingsDialog
extends ThresholdAbstractSettingsDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(WeightSettingsDialog.class);
    private TreeViewer lstGroups;
    private StmtTreeObject root = null;
    private Table tblValues;
    private Group groupSetVal;
    private Button btnGroupValue;
    private Label lblStmtType;
    private Text txtValue;
    private Button btnChange;
    private Button btnRestore;
    private TabItem weightsTab;
    private StmtGroup currentGroup;
    private StmtWeight currentWeight;
    private Map<String, StmtGroup> groups;
    private Set<StmtWeight> toSave = new HashSet<StmtWeight>();
    private boolean isFilled;
    private StmtGroup allGroup;
    private int selIndex;
    private static final Integer defaultWeightValue = 1;

    public WeightSettingsDialog(Shell shell, ProjectInfo pInfo) {
        super(shell, pInfo);
    }

    @Override
    protected void createPage(Composite page) {
        super.createPage(page);
        this.weightsTab = new TabItem(this.tabFolder, 0);
        this.weightsTab.setText(Messages.getString(WeightSettingsDialog.class, "weight.tab.title"));
        this.weightsTab.setControl(this.createWeightsTab(this.tabFolder));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WeightSettingsDialog.this.tabChanged(e.item);
            }
        });
    }

    @Override
    protected void update(boolean justDefaults) {
        super.update(justDefaults);
        this.loadStatements();
        L.debug("after loadStatements");
        L.debug("before fillUI");
        if (this.weightsTab.getControl().isVisible()) {
            this.fillUI();
        }
        L.debug("after fillUI");
    }

    private Control createWeightsTab(TabFolder parent) {
        Composite myParent = new Composite((Composite)parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 8;
        myParent.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        myParent.setLayoutData((Object)data);
        Label lblGroups = new Label(myParent, 0);
        lblGroups.setText(Messages.getString(WeightSettingsDialog.class, "label.stmtTypes.groups"));
        data = new GridData();
        data.horizontalAlignment = 1;
        lblGroups.setLayoutData((Object)data);
        Label lblValues = new Label(myParent, 0);
        lblValues.setText(Messages.getString(WeightSettingsDialog.class, "label.stmtWeights"));
        data = new GridData();
        data.horizontalAlignment = 1;
        lblValues.setLayoutData((Object)data);
        this.createGroupsList(myParent, lblGroups);
        this.createTableValues(myParent, lblValues);
        this.createGroupSetValue(myParent);
        return myParent;
    }

    private void createGroupsList(Composite parent, final Label lblGroups) {
        this.lstGroups = new TreeViewer(parent, 68356);
        this.lstGroups.setContentProvider((IContentProvider)new StmtTreeViewContentProvider());
        this.lstGroups.setLabelProvider((IBaseLabelProvider)new StmtTreeViewLabelProvider());
        GridData data = new GridData();
        data.verticalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.lstGroups.getControl().setLayoutData((Object)data);
        this.lstGroups.addSelectionChangedListener((ISelectionChangedListener)new GroupSelectionListener());
        Accessible accessibleTbl = this.lstGroups.getTree().getAccessible();
        lblGroups.getAccessible().addRelation(8, accessibleTbl);
        accessibleTbl.addRelation(9, lblGroups.getAccessible());
        accessibleTbl.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = lblGroups.getText();
                }
                L.trace("statementTypes.getDescription: {} for: {}", (Object)event.result, (Object)event.childID);
            }
        });
    }

    private void createTableValues(Composite parent, final Label caption) {
        this.tblValues = new Table(parent, 68352);
        GridData data = new GridData();
        data.heightHint = 100;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.tblValues.setLayoutData((Object)data);
        final String[] titles = new String[]{Messages.getString(WeightSettingsDialog.class, "stmtType.column.title"), Messages.getString(WeightSettingsDialog.class, "stmtWeight.column.title")};
        int i = 0;
        while (i < titles.length) {
            TableColumn tc = new TableColumn(this.tblValues, 0);
            tc.setText(titles[i]);
            ++i;
        }
        this.tblValues.setHeaderVisible(true);
        this.tblValues.setLinesVisible(true);
        this.tblValues.addSelectionListener((SelectionListener)new StmtWeightSelectionListener());
        int[] nArray = new int[2];
        nArray[1] = 150;
        int[] lengths = nArray;
        this.tblValues.addControlListener((ControlListener)new ColumnResizer(this.tblValues, lengths));
        this.tblValues.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = Messages.getString(WeightSettingsDialog.class, "stmtWeights.table.name", new Object[]{caption.getText(), titles[0], titles[1]});
                }
                L.trace("getName={} for: {}", (Object)event.result, (Object)event.childID);
            }

            public void getDescription(AccessibleEvent event) {
                super.getDescription(event);
                L.trace("getDescription for {}={}", (Object)event.childID, (Object)event.result);
            }
        });
    }

    private void setCurrWeight(StmtWeight obj) {
        this.currentWeight = obj;
        if (this.currentWeight != null) {
            this.txtValue.setText(this.currentWeight.getValue().toString());
            if (!this.btnGroupValue.getSelection()) {
                this.lblStmtType.setText(this.currentWeight.getStmtType().getName());
            }
        } else {
            this.txtValue.setText("");
            if (!this.btnGroupValue.getSelection()) {
                this.lblStmtType.setText("");
            }
        }
    }

    protected void checkGroup(SelectionEvent e) {
        if (this.btnGroupValue.getSelection()) {
            this.lblStmtType.setText(Messages.getString(WeightSettingsDialog.class, "label.group.text", new Object[]{Messages.getString(ReportSettingsDialog.class, this.currentGroup.getName().replace(" ", "."))}));
        } else {
            this.lblStmtType.setText(this.currentWeight.getStmtType().getName());
        }
    }

    private void createGroupSetValue(Composite parent) {
        this.groupSetVal = new Group(parent, 0);
        this.groupSetVal.setText(Messages.getString(WeightSettingsDialog.class, "label.setValue.group"));
        GridLayout lay = new GridLayout(3, false);
        lay.marginBottom = 5;
        lay.marginLeft = 5;
        lay.marginRight = 5;
        lay.marginTop = 5;
        this.groupSetVal.setLayout((Layout)lay);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        this.groupSetVal.setLayoutData((Object)data);
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WeightSettingsDialog.this.checkGroup(e);
            }
        };
        this.btnGroupValue = new Button((Composite)this.groupSetVal, 32);
        this.btnGroupValue.setText(Messages.getString(WeightSettingsDialog.class, "label.setValue.check"));
        this.btnGroupValue.addSelectionListener(listener);
        data = new GridData();
        data.horizontalSpan = 3;
        this.btnGroupValue.setLayoutData((Object)data);
        this.lblStmtType = new Label((Composite)this.groupSetVal, 1);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.lblStmtType.setLayoutData((Object)data);
        this.txtValue = new Text((Composite)this.groupSetVal, 2052);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.txtValue.setLayoutData((Object)data);
        SelectionListener changeListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WeightSettingsDialog.this.changeVal(e);
            }
        };
        this.btnChange = new Button((Composite)this.groupSetVal, 1032);
        this.btnChange.setText(Messages.getString(WeightSettingsDialog.class, "change.button.text"));
        this.btnChange.addSelectionListener(changeListener);
        SelectionListener restoreListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WeightSettingsDialog.this.restoreDefault(e);
            }
        };
        this.btnRestore = new Button((Composite)this.groupSetVal, 1032);
        this.btnRestore.setText(Messages.getString(WeightSettingsDialog.class, "restore.button.text"));
        this.btnRestore.addSelectionListener(restoreListener);
        data = new GridData();
        data.horizontalAlignment = 131072;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 3;
        this.btnRestore.setLayoutData((Object)data);
    }

    protected void restoreDefault(SelectionEvent e) {
        this.saveWeight(this.btnGroupValue.getSelection(), true, false);
    }

    protected void changeVal(SelectionEvent e) {
        if (!this.hasErrors()) {
            this.saveWeight(this.btnGroupValue.getSelection(), false, false);
        }
    }

    private void saveWeight(boolean allWeights, boolean restoreDefault, boolean indexChanged) {
        int oldIndex = this.tblValues.getSelectionIndex();
        if (indexChanged) {
            TableItem[] itms = this.tblValues.getItems();
            int i = 0;
            while (i < itms.length) {
                TableItem itm = itms[i];
                if (itm.getData() instanceof StmtType) {
                    if (((StmtType)itm.getData()).getObj().equals(this.currentWeight)) {
                        oldIndex = i;
                        i = itms.length + 1;
                    }
                } else {
                    L.warn("strange data in table {}", itm.getData().getClass());
                }
                ++i;
            }
        }
        Integer newValue = new Integer(-1);
        if (!restoreDefault) {
            if (this.txtValue.getText() != null && !"".equalsIgnoreCase(this.txtValue.getText())) {
                newValue = new Integer(this.txtValue.getText());
            } else {
                L.error("Value must be an Integer greater or equal with 0");
                return;
            }
        }
        if (allWeights) {
            Set types = this.currentGroup.getTypes();
            for (StmtType type : types) {
                StmtWeight obj = type.getObj();
                if (restoreDefault) {
                    obj.setDefValue(defaultWeightValue);
                    obj.restoreDefault();
                    this.txtValue.setText(obj.getValue().toString());
                } else {
                    obj.setValue(newValue);
                }
                this.toSave.add(obj);
            }
            this.fillTable(this.tblValues.getSelectionIndex());
        } else {
            if (restoreDefault) {
                this.currentWeight.setDefValue(defaultWeightValue);
                this.currentWeight.restoreDefault();
                this.txtValue.setText(this.currentWeight.getValue().toString());
            } else {
                this.currentWeight.setValue(newValue);
            }
            StmtType type = this.currentWeight.getStmtType();
            this.toSave.add(this.currentWeight);
            this.currentGroup.getType(type).setWeight(this.currentWeight);
            this.tblValues.getItem(oldIndex).setData((Object)type);
            this.tblValues.getItem(oldIndex).setText(1, this.currentWeight.getValue().toString());
        }
    }

    private boolean hasErrors() {
        String newVal = this.txtValue.getText();
        boolean err = false;
        if (newVal == null || "".equalsIgnoreCase(newVal)) {
            err = true;
            MessageDialog.openError((Shell)this.display.getActiveShell(), (String)Messages.getString(WeightSettingsDialog.class, "error.dialog.title"), (String)Messages.getString(WeightSettingsDialog.class, "error.dialog.text.notNull"));
        } else {
            try {
                int nr = Integer.parseInt(newVal);
                if (nr < 0) {
                    err = true;
                    MessageDialog.openError((Shell)this.display.getActiveShell(), (String)Messages.getString(WeightSettingsDialog.class, "error.dialog.title"), (String)Messages.getString(WeightSettingsDialog.class, "error.dialog.text.greater0"));
                }
            }
            catch (NumberFormatException e1) {
                L.info("bad weight format", (Throwable)e1);
                err = true;
                MessageDialog.openError((Shell)this.display.getActiveShell(), (String)Messages.getString(WeightSettingsDialog.class, "error.dialog.title"), (String)Messages.getString(WeightSettingsDialog.class, "error.dialog.text.greater0"));
            }
        }
        return err;
    }

    private void fillUI() {
        try {
            Shell shell = this.display.getActiveShell();
            this.isFilled = true;
            if (shell != null) {
                shell.setCursor(this.waitCursor);
            }
            L.debug("fillUI call to fillList()");
            this.fillList();
            L.debug("list was filled");
            this.fillTable(this.selIndex);
            L.debug("table was filled");
            if (shell != null) {
                shell.setCursor(this.defCursor);
            }
        }
        catch (EZSourceNativeException e) {
            L.error("fill UI", (Throwable)e);
        }
    }

    private void fillTable(int selectedIndex) {
        if (this.currentGroup != null) {
            StmtWeight w;
            TableItem item;
            StmtType type2;
            this.tblValues.removeAll();
            TreeSet types = new TreeSet(this.currentGroup.getTypes());
            for (StmtType type2 : types) {
                TableItem ti = new TableItem(this.tblValues, 0x1000000);
                String[] str = new String[]{type2.getName(), type2.getObj().getValue().toString()};
                ti.setText(str);
                ti.setData((Object)type2);
            }
            this.tblValues.setSelection(selectedIndex);
            if (selectedIndex < this.tblValues.getItemCount() && (item = this.tblValues.getItem(selectedIndex)) != null && (w = (type2 = (StmtType)item.getData()).getObj()) != null) {
                this.setCurrWeight(w);
            }
        }
    }

    private void loadStatements() {
        List allGroupsList = com.ez.report.application.ezreport.utils.Utils.readStmtGroups(this.defProp, this.thisProp, 5);
        this.createStmtTreeModel(allGroupsList);
        this.lstGroups.refresh();
        this.lstGroups.setSelection(this.lstGroups.getSelection());
    }

    private void createStmtTreeModel(List allGroupsList) {
        HashMap<Integer, StmtTreeObject> stmtTreeObjects = new HashMap<Integer, StmtTreeObject>();
        if (allGroupsList != null && allGroupsList.size() > 0) {
            if (this.groups == null) {
                this.groups = new HashMap<String, StmtGroup>();
            }
            this.root = new StmtTreeObject("");
            int k = 0;
            while (k < allGroupsList.size()) {
                StmtGroup gr = (StmtGroup)allGroupsList.get(k);
                boolean isAvailable = Manager.getInstance().checkAvailability(this.pInfo, "stmtType", new Integer(k).toString());
                if (k != 0 && !isAvailable) {
                    Set notAvailable = gr.getTypes();
                    Set allTypes = this.allGroup.getTypes();
                    if (notAvailable != null) {
                        L.debug("group not available: {}", (Object)gr);
                    } else {
                        Set subgroups = gr.getSubgroups();
                        if (subgroups != null) {
                            for (Integer subgroupID : subgroups) {
                                StmtGroup subgroup = (StmtGroup)allGroupsList.get(subgroupID);
                                Set types = subgroup.getTypes();
                                if (types == null || types.size() <= 0) continue;
                                allTypes.removeAll(types);
                            }
                        }
                    }
                } else {
                    String grDisplayName = Messages.getString(ReportSettingsDialog.class, gr.getName());
                    gr.setDisplayName(grDisplayName);
                    StmtTreeObject to = new StmtTreeObject(grDisplayName);
                    to.setStmtId(gr.getName());
                    if (k == 0) {
                        this.allGroup = gr;
                        this.root.addChild(to);
                        to.setParent(this.root);
                        stmtTreeObjects.put(gr.getId(), to);
                        this.allGroup.getTypes().clear();
                    } else {
                        String parentString = gr.getParent();
                        Integer parentId = new Integer(parentString);
                        StmtTreeObject parentTreeObject = (StmtTreeObject)stmtTreeObjects.get(parentId);
                        StmtGroup parentGroup = (StmtGroup)allGroupsList.get(parentId);
                        if (parentTreeObject != null) {
                            to.setParent(parentTreeObject);
                            parentTreeObject.addChild(to);
                        }
                        if (parentGroup != null && gr.getTypes() != null) {
                            Set typesSet = gr.getTypes();
                            for (StmtType stmtType : typesSet) {
                                parentGroup.addType(stmtType);
                            }
                        }
                    }
                    stmtTreeObjects.put(gr.getId(), to);
                    this.groups.put(gr.getName(), gr);
                    this.allGroup.getTypes().addAll(gr.getTypes());
                }
                ++k;
            }
        }
    }

    private void fillList() {
        this.loadStatements();
        this.lstGroups.setInput((Object)this.root);
        this.lstGroups.refresh();
        this.lstGroups.expandAll();
        TreeItem ti = this.lstGroups.getTree().getItem(this.selIndex);
        this.lstGroups.getTree().setSelection(ti);
        if (this.lstGroups.getTree().getItemCount() > this.selIndex) {
            String name = ti.getText();
            this.currentGroup = this.groups.get(name);
        }
    }

    private void verifyCurrWeightChanged() {
        if (this.currentWeight != null && !this.currentWeight.getValue().toString().equalsIgnoreCase(this.txtValue.getText())) {
            L.info("value changed! old: {}; new: {}", (Object)this.currentWeight.getValue().toString(), (Object)this.txtValue.getText());
            final Shell shell = this.display.getActiveShell();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    boolean toSave = MessageDialog.openQuestion((Shell)shell, (String)Messages.getString(WeightSettingsDialog.class, "changedValue.dialog.title"), (String)Messages.getString(WeightSettingsDialog.class, "changedValue.dialog.text"));
                    if (toSave && !WeightSettingsDialog.this.hasErrors()) {
                        WeightSettingsDialog.this.saveWeight(WeightSettingsDialog.this.btnGroupValue.getSelection(), false, true);
                    }
                }
            });
        }
    }

    private void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            TabItem tabItem = (TabItem)widget;
            if (tabItem.equals(this.weightsTab)) {
                if (!this.isFilled) {
                    this.fillUI();
                }
            } else {
                this.verifyCurrWeightChanged();
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    protected void saveToFile(File where, boolean asDefault) {
        Properties properties = new Properties();
        if (this.allGroup != null) {
            for (StmtType type : this.allGroup.getTypes()) {
                Integer value = type.getObj().getValue();
                Integer defValue = type.getObj().getDefValue();
                if (asDefault) {
                    if (value == 1) continue;
                    properties.setProperty(type.getId().toString(), value.toString());
                    continue;
                }
                if (value.intValue() == defValue.intValue()) continue;
                properties.setProperty(type.getId().toString(), value.toString());
            }
        }
        Properties prop = this.thresholdSelectionUI.getProperties();
        properties.putAll((Map<?, ?>)prop);
        if (!asDefault) {
            this.thisProp.clear();
            this.thisProp.putAll((Map<?, ?>)properties);
        }
        L.debug("saving to file: {}", (Object)where);
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(where);
                properties.store(fileOutputStream, "#stmt type = weight value\n#if not present, falls to default. In default file, default value = 1");
            }
            catch (FileNotFoundException e) {
                L.error("error at saving to file: {}", (Object)where, (Object)e);
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e2) {
                    L.error("saveToFile", (Throwable)e2);
                }
            }
            catch (IOException e) {
                L.error("error at saving to file: {}", (Object)where, (Object)e);
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e3) {
                    L.error("saveToFile", (Throwable)e3);
                }
            }
            catch (Throwable t) {
                L.error("error at saving to file: {}", (Object)where, (Object)t);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    L.error("saveToFile", (Throwable)e);
                }
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                L.error("saveToFile", (Throwable)e);
            }
        }
    }

    @Override
    public Properties getDefProp() {
        return this.defProp;
    }

    @Override
    public Properties getThisProp() {
        return this.thisProp;
    }

    @Override
    protected void initPage() {
        this.defaultFile = this.getDefaultSettFile();
        this.defProp = com.ez.mainframe.data.utils.Utils.readSettings((File)this.defaultFile);
        if (!this.isFilled && this.weightsTab.getControl().isVisible()) {
            this.fillUI();
        }
        this.initiated = true;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.btnChange.setEnabled(!readOnly);
        this.txtValue.setEditable(!readOnly);
        this.btnGroupValue.setEnabled(!readOnly);
        this.btnRestore.setEnabled(!readOnly);
        super.setReadOnly(readOnly);
    }

    @Override
    public String getThresholdTypeString() {
        return Messages.getString(WeightSettingsDialog.class, "threshold.tab.description");
    }

    @Override
    public String getFirstThresholdTypeString() {
        return Messages.getString(WeightSettingsDialog.class, "first.prag");
    }

    @Override
    public String getThirdThresholdTypeString() {
        return Messages.getString(WeightSettingsDialog.class, "second.prag");
    }

    @Override
    public org.eclipse.swt.graphics.RGB getFirstDefaultColor() {
        RGB color = Utils.DEF_COMPLEXITY_SIMPLE_COLOR;
        return new org.eclipse.swt.graphics.RGB(color.red, color.green, color.blue);
    }

    @Override
    public Integer getFirstDefaultThreshold() {
        return Utils.DEF_COMPLEXITY_SIMPLE;
    }

    @Override
    public org.eclipse.swt.graphics.RGB getSecondDefaultColor() {
        RGB color = Utils.DEF_COMPLEXITY_MEDIUM_COLOR;
        return new org.eclipse.swt.graphics.RGB(color.red, color.green, color.blue);
    }

    @Override
    public Integer getSecondDefaultThreshold() {
        return Utils.DEF_COMPLEXITY_MEDIUM;
    }

    @Override
    public org.eclipse.swt.graphics.RGB getThirdDefaultColor() {
        RGB color = Utils.DEF_COMPLEXITY_COMPLEX_COLOR;
        return new org.eclipse.swt.graphics.RGB(color.red, color.green, color.blue);
    }

    private class GroupSelectionListener
    implements ISelectionChangedListener {
        private GroupSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            StmtTreeObject to = (StmtTreeObject)((TreeSelection)selection).getFirstElement();
            String name = to.getName();
            if (name != null && !name.equalsIgnoreCase("")) {
                WeightSettingsDialog.this.verifyCurrWeightChanged();
                WeightSettingsDialog.this.currentGroup = (StmtGroup)WeightSettingsDialog.this.groups.get(to.getStmtId());
                WeightSettingsDialog.this.lblStmtType.setText(Messages.getString(WeightSettingsDialog.class, "label.group.text", new Object[]{name}));
                WeightSettingsDialog.this.fillTable(WeightSettingsDialog.this.selIndex);
            }
        }
    }

    private class StmtWeightSelectionListener
    extends SelectionAdapter {
        private StmtWeightSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem item = (TableItem)e.item;
            StmtType type = (StmtType)item.getData();
            WeightSettingsDialog.this.verifyCurrWeightChanged();
            WeightSettingsDialog.this.setCurrWeight(type.getObj());
            L.debug("current weight: {}", (Object)WeightSettingsDialog.this.currentWeight);
        }
    }
}

