/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.properties;

import com.ez.ezsource.connection.ProjectInfo;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.event.ErrorEvent;
import com.ez.report.application.event.ErrorEventListener;
import com.ez.report.application.event.ErrorMessage;
import com.ez.report.generation.common.model.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReportSettingsDialog
extends Dialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportSettingsDialog.class);
    protected Display display = Display.getDefault();
    protected final Cursor waitCursor = new Cursor((Device)this.display, 1);
    protected final Cursor defCursor = new Cursor((Device)this.display, 0);
    protected final Color redColor = new Color((Device)this.display, 255, 0, 0);
    protected Font titleFont = null;
    protected ErrorMessage msg;
    protected Label title = null;
    protected String projectName;
    protected ProjectInfo pInfo;
    protected String fileName = "default";
    public boolean addToHistory = true;
    protected File defaultFile = null;
    protected Properties defProp;
    public boolean addInMyreportsOnSaveAs = false;
    protected boolean initiated = false;
    private String analysisFolder;

    public ReportSettingsDialog(Shell shell, ProjectInfo pInfo) {
        super(shell);
        this.pInfo = pInfo;
    }

    public void setDetails(String projectName, String fileName) {
        this.projectName = projectName;
        this.fileName = fileName;
        this.initPage();
        String viewName = Messages.getString(((Object)((Object)this)).getClass(), "view.name");
        String titleText = Messages.getString(((Object)((Object)this)).getClass(), "view.title", new String[]{viewName, projectName});
        this.title.setText(titleText);
        this.refreshView();
    }

    protected abstract void update(boolean var1);

    public Control createDialogArea(Composite parent) {
        Composite page = (Composite)super.createDialogArea(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        GridLayout layout = new GridLayout();
        page.setLayout((Layout)layout);
        this.title = new Label(page, 0);
        this.titleFont = new Font((Device)this.display, new FontData("Arial", 12, 0));
        this.title.setFont(this.titleFont);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.title.setLayoutData((Object)data);
        Accessible accessibleDlg = this.getShell().getAccessible();
        this.title.getAccessible().addRelation(8, accessibleDlg);
        accessibleDlg.addRelation(9, this.title.getAccessible());
        accessibleDlg.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = ReportSettingsDialog.this.title.getText();
                }
                L.trace("dialog.getDescription={} for: {}", (Object)event.result, (Object)event.childID);
            }
        });
        this.msg = new ErrorMessage(page, 0);
        this.msg.addErrorListener(new ErrorEventListener(){

            public void errorEventHappend(ErrorEvent errEv) {
                Button okB = ReportSettingsDialog.this.getButton(0);
                if (errEv.error != null && !errEv.error.equals("")) {
                    if (okB != null) {
                        okB.setEnabled(false);
                    }
                } else if (okB != null) {
                    okB.setEnabled(true);
                }
            }
        });
        this.createPage(page);
        this.checkInitiated();
        return page;
    }

    protected void checkInitiated() {
        String message = Messages.getString(ReportSettingsDialog.class, "notInitiated.errorMessage");
        if (!this.initiated) {
            this.setErrorMessage(message);
        } else {
            this.removeErrorMessage(message);
        }
    }

    protected abstract void createPage(Composite var1);

    protected void okPressed() {
        this.save();
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public void setErrorMessage(String message) {
        L.info("ERROR: {}", (Object)message);
        this.msg.notify(message);
    }

    public void removeErrorMessage(String messageErr) {
        L.info("ERROR: {}", (Object)messageErr);
        this.msg.remove(messageErr);
    }

    protected void initPage() {
        if (this.defaultFile == null) {
            this.defaultFile = this.getDefaultSettFile();
            this.defProp = Utils.readSettings((File)this.defaultFile);
        }
    }

    protected File getDefaultSettFile() {
        String path = Utils.getProjectPathName((String)this.projectName).concat(File.separator).concat(this.getAnalysisFolder()).concat(Constants.PATH_SEPARATOR).concat("default.properties");
        return new File(path);
    }

    public void setAnalysisFolder(String analysisFolder) {
        this.analysisFolder = analysisFolder;
    }

    public String getAnalysisFolder() {
        return this.analysisFolder;
    }

    protected void save() {
        String path = Utils.getProjectPathName((String)this.projectName).concat(File.separator).concat(this.getAnalysisFolder()).concat(Constants.PATH_SEPARATOR).concat(this.fileName).concat(".properties");
        File sFile = new File(path);
        this.saveToFile(sFile, false);
    }

    /*
     * Loose catch block
     */
    protected void saveToFile(File where, boolean asDefault) {
        Properties properties = new Properties();
        this.collectProperties4Save(properties);
        L.debug("saving to file: {}", (Object)where);
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(where);
                properties.store(fileOutputStream, "#comment");
            }
            catch (FileNotFoundException e) {
                L.error("error at saving to file: {}", (Object)where, (Object)e);
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e2) {
                    L.error("saveToFile {}", (Object)where, (Object)e2);
                }
            }
            catch (IOException e) {
                L.error("error at saving to file: {}", (Object)where, (Object)e);
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e3) {
                    L.error("saveToFile {}", (Object)where, (Object)e3);
                }
            }
            catch (Throwable t) {
                L.error("error at saving to file: {}", (Object)where, (Object)t);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    L.error("saveToFile {}", (Object)where, (Object)e);
                }
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                L.error("saveToFile {}", (Object)where, (Object)e);
            }
        }
    }

    protected void collectProperties4Save(Properties properties) {
    }

    public void refreshView() {
        try {
            this.update(false);
            this.checkInitiated();
            this.refreshGUI();
        }
        catch (Throwable e) {
            L.error("refreshView", e);
        }
    }

    public String getActionText() {
        return this.title.getText();
    }

    public void setFocus() {
    }

    public void refreshGUI() {
        boolean enabled = this.isSaveEnabled();
        this.setReadOnly(!enabled);
    }

    private boolean isSaveEnabled() {
        return true;
    }

    public abstract void setReadOnly(boolean var1);

    protected boolean isResizable() {
        return true;
    }
}

