/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.properties;

import com.ez.ezsource.connection.ProjectInfo;
import com.ez.mainframe.model.StmtGroup;
import com.ez.mainframe.model.StmtState;
import com.ez.mainframe.model.StmtType;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.selection.Manager;
import com.ez.report.application.ezreport.utils.Utils;
import com.ez.report.application.properties.ReportSettingsDialog;
import com.ez.report.application.ui.ColumnResizer;
import com.ez.report.application.ui.StmtTreeObject;
import com.ez.report.application.ui.StmtTreeViewContentProvider;
import com.ez.report.application.ui.StmtTreeViewLabelProvider;
import com.ez.report.generation.common.model.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HalsteadSettingsDialog
extends ReportSettingsDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(HalsteadSettingsDialog.class);
    private TreeViewer lstGroups;
    private StmtTreeObject root = null;
    private Table tblValues;
    private Group groupSetVal;
    private Button btnSelectAll;
    private Button btnDeselectAll;
    private Button btnRestoreDefaults;
    private TabFolder tabFolder;
    private TabItem stmtsTab;
    private StmtGroup currentGroup;
    private StmtState currentState;
    private Map groups;
    File defaultFile = null;
    private StmtGroup allGroup;
    private int selIndex;
    private Properties defProp;
    private File thisFile;
    private Properties thisProp;
    private Set stmtTypeUnchecked = new HashSet();
    String connFailedMes = Messages.getString(HalsteadSettingsDialog.class, "connectionError.message");
    private static final String no_operators_err = Messages.getString(HalsteadSettingsDialog.class, "empty.operators.list.message");
    private static final String BTN_KEY = "btn";
    private static final String IDX_KEY = "idx";

    public HalsteadSettingsDialog(Shell shell, ProjectInfo pInfo) {
        super(shell, pInfo);
    }

    @Override
    protected void createPage(Composite page) {
        this.tabFolder = new TabFolder(page, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)data);
        this.stmtsTab = new TabItem(this.tabFolder, 0);
        this.stmtsTab.setText(Messages.getString(HalsteadSettingsDialog.class, "operator.tab.title"));
        this.stmtsTab.setControl(this.createWeightsTab(this.tabFolder));
    }

    @Override
    protected void update(boolean justDefaults) {
        L.debug("update {}", (Object)justDefaults);
        this.defProp = com.ez.mainframe.data.utils.Utils.readSettings((File)this.defaultFile);
        L.debug("after readSettings {}", (Object)this.defaultFile);
        L.debug("after readSettings {}", (Object)this.defaultFile);
        String prjPath = com.ez.mainframe.data.utils.Utils.getProjectPathName((String)this.projectName);
        String path = prjPath.concat(File.separator).concat(this.getAnalysisFolder()).concat(Constants.PATH_SEPARATOR).concat(this.fileName);
        if (!path.endsWith(".properties")) {
            path = path.concat(".properties");
        }
        this.thisFile = new File(path);
        L.debug("before readSettings {}", (Object)this.thisFile);
        this.thisProp = com.ez.mainframe.data.utils.Utils.readSettings((File)this.thisFile);
        L.debug("after readSettings {}", (Object)this.thisFile);
        this.loadStatements();
        L.debug("after loadStatements");
        L.debug("before fillUI");
        if (this.stmtsTab.getControl().getVisible()) {
            this.fillUI();
        }
        L.debug("after fillUI");
    }

    private Control createWeightsTab(TabFolder parent) {
        Composite myParent = new Composite((Composite)parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 8;
        myParent.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        myParent.setLayoutData((Object)data);
        Text lblGroups = new Text(myParent, 8);
        lblGroups.setText(Messages.getString(HalsteadSettingsDialog.class, "label.stmtTypes.groups"));
        data = new GridData();
        data.horizontalAlignment = 1;
        lblGroups.setLayoutData((Object)data);
        Label lblValues = new Label(myParent, 0);
        lblValues.setText(Messages.getString(HalsteadSettingsDialog.class, "label.stmtStates"));
        data = new GridData();
        data.horizontalAlignment = 1;
        lblValues.setLayoutData((Object)data);
        this.createGroupsList(myParent, lblGroups);
        this.createTableValues(myParent, lblValues);
        this.createGroupSetValue(myParent);
        return myParent;
    }

    private void createGroupsList(Composite parent, final Text lblGroups) {
        this.lstGroups = new TreeViewer(parent, 68356);
        this.lstGroups.setContentProvider((IContentProvider)new StmtTreeViewContentProvider());
        this.lstGroups.setLabelProvider((IBaseLabelProvider)new StmtTreeViewLabelProvider());
        Accessible accessibleTbl = this.lstGroups.getTree().getAccessible();
        accessibleTbl.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = lblGroups.getText();
                }
                L.trace("statementTypes.getDescription={} for {}", (Object)event.result, (Object)event.childID);
            }

            public void getName(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = lblGroups.getText();
                }
                L.trace("statementTypes.getName={} for {}", (Object)event.result, (Object)event.childID);
            }
        });
        GridData data = new GridData();
        data.verticalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.lstGroups.getControl().setLayoutData((Object)data);
        this.lstGroups.addSelectionChangedListener((ISelectionChangedListener)new GroupSelectionListener());
    }

    private void createTableValues(Composite parent, final Label caption) {
        this.tblValues = new Table(parent, 68096);
        GridData data = new GridData();
        data.heightHint = 100;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.tblValues.setLayoutData((Object)data);
        final TableColumn tc1 = new TableColumn(this.tblValues, 16384);
        tc1.setText(Messages.getString(HalsteadSettingsDialog.class, "stmtType.column.title"));
        tc1.setWidth(200);
        final TableColumn tc0 = new TableColumn(this.tblValues, 131072);
        tc0.setText(Messages.getString(HalsteadSettingsDialog.class, "state.column.title"));
        tc0.setWidth(50);
        this.tblValues.setHeaderVisible(true);
        this.tblValues.setLinesVisible(true);
        int[] nArray = new int[2];
        nArray[1] = 100;
        int[] lengths = nArray;
        this.tblValues.addControlListener((ControlListener)new ColumnResizer(this.tblValues, lengths));
        this.tblValues.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = Messages.getString(HalsteadSettingsDialog.class, "statements.table.name", new Object[]{caption.getText(), tc1.getText(), tc0.getText()});
                }
                L.trace("table.getName={} for: {}", (Object)event.result, (Object)event.childID);
            }

            public void getDescription(AccessibleEvent event) {
                L.trace("table.getDescription={} for: {}", (Object)event.result, (Object)event.childID);
            }
        });
    }

    private void setCurrState(StmtState obj) {
        this.currentState = obj;
    }

    private void createGroupSetValue(Composite parent) {
        this.groupSetVal = new Group(parent, 0);
        this.groupSetVal.setText(Messages.getString(HalsteadSettingsDialog.class, "label.setValue.group"));
        GridLayout lay = new GridLayout(4, true);
        lay.marginBottom = 5;
        lay.marginLeft = 5;
        lay.marginRight = 5;
        lay.marginTop = 5;
        this.groupSetVal.setLayout((Layout)lay);
        GridData data = new GridData();
        data.horizontalAlignment = 131072;
        data.grabExcessHorizontalSpace = true;
        this.groupSetVal.setLayoutData((Object)data);
        SelectionAdapter selectAllListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HalsteadSettingsDialog.this.checkAll();
            }
        };
        SelectionAdapter deselectAllListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = HalsteadSettingsDialog.this.tblValues.getItems();
                int i = 0;
                while (i < items.length) {
                    Button btn = (Button)items[i].getData(HalsteadSettingsDialog.BTN_KEY);
                    btn.setSelection(false);
                    btn.update();
                    StmtType type = (StmtType)items[i].getData();
                    StmtState obj = type.getState();
                    obj.setValue(Boolean.FALSE.toString());
                    items[i].setData((Object)type);
                    HalsteadSettingsDialog.this.stmtTypeUnchecked.add(type);
                    ++i;
                }
                HalsteadSettingsDialog.this.tblValues.update();
                if (HalsteadSettingsDialog.this.allGroup.getTypes().size() == HalsteadSettingsDialog.this.stmtTypeUnchecked.size()) {
                    HalsteadSettingsDialog.this.setErrorMessage(no_operators_err);
                }
            }
        };
        this.btnSelectAll = new Button((Composite)this.groupSetVal, 1032);
        data = new GridData();
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 1;
        this.btnSelectAll.setLayoutData((Object)data);
        this.btnSelectAll.setText(Messages.getString(HalsteadSettingsDialog.class, "selall.button.text"));
        this.btnSelectAll.addSelectionListener((SelectionListener)selectAllListener);
        this.btnDeselectAll = new Button((Composite)this.groupSetVal, 1032);
        data = new GridData();
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 1;
        this.btnDeselectAll.setLayoutData((Object)data);
        this.btnDeselectAll.setText(Messages.getString(HalsteadSettingsDialog.class, "deselall.button.text"));
        this.btnDeselectAll.addSelectionListener((SelectionListener)deselectAllListener);
        SelectionListener restoreDefaultsListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HalsteadSettingsDialog.this.checkAll();
            }
        };
        this.btnRestoreDefaults = new Button((Composite)this.groupSetVal, 1032);
        this.btnRestoreDefaults.setText(Messages.getString(HalsteadSettingsDialog.class, "restoreDefaults.button.text"));
        this.btnRestoreDefaults.addSelectionListener(restoreDefaultsListener);
        data = new GridData();
        data.horizontalAlignment = 131072;
        data.horizontalSpan = 2;
        this.btnRestoreDefaults.setLayoutData((Object)data);
    }

    private void checkAll() {
        TableItem[] items = this.tblValues.getItems();
        int i = 0;
        while (i < items.length) {
            ((Button)items[i].getData(BTN_KEY)).setSelection(true);
            StmtType type = (StmtType)items[i].getData();
            StmtState obj = type.getState();
            obj.setValue("true");
            items[i].setData((Object)type);
            ++i;
        }
        this.stmtTypeUnchecked.clear();
        this.tblValues.update();
        this.removeErrorMessage(no_operators_err);
    }

    private boolean hasErrors() {
        boolean err = false;
        if (this.allGroup.getTypes().size() == this.stmtTypeUnchecked.size()) {
            err = true;
        }
        return err;
    }

    private void fillUI() {
        Shell shell = this.display.getActiveShell();
        if (shell != null) {
            shell.setCursor(this.waitCursor);
        }
        L.debug("fillUI call to fillList()");
        this.fillList();
        L.debug("list was filled");
        this.fillTable(this.selIndex);
        L.debug("table was filled");
        if (shell != null) {
            shell.setCursor(this.defCursor);
        }
    }

    private void fillTable(int selectedIndex) {
        if (this.currentGroup != null) {
            StmtType type;
            StmtState s;
            TableItem item;
            TableItem[] tableItemArray = this.tblValues.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem ti = tableItemArray[n2];
                Button button = (Button)ti.getData(BTN_KEY);
                button.dispose();
                ++n2;
            }
            this.tblValues.removeAll();
            this.stmtTypeUnchecked.clear();
            TreeSet types = new TreeSet(this.currentGroup.getTypes());
            for (StmtType type2 : types) {
                TableItem ti = new TableItem(this.tblValues, 131072);
                TableEditor editor = new TableEditor(this.tblValues);
                Button checkButton = new Button((Composite)this.tblValues, 32);
                checkButton.addListener(13, (Listener)new StmtWeightSelectionListener());
                checkButton.pack();
                editor.minimumWidth = checkButton.getSize().x;
                editor.horizontalAlignment = 16384;
                editor.setEditor((Control)checkButton, ti, 1);
                ti.setData(BTN_KEY, (Object)checkButton);
                checkButton.setData(IDX_KEY, (Object)new Integer(this.tblValues.getItemCount() - 1));
                String[] str = new String[2];
                str[0] = type2.getName();
                String value = type2.getState().getValue();
                if (value.equalsIgnoreCase("true")) {
                    checkButton.setSelection(true);
                }
                if (value.equalsIgnoreCase(Boolean.FALSE.toString())) {
                    checkButton.setSelection(false);
                }
                ti.setText(str);
                ti.setData((Object)type2);
            }
            this.tblValues.setSelection(selectedIndex);
            if (selectedIndex < this.tblValues.getItemCount() && (item = this.tblValues.getItem(selectedIndex)) != null && (s = (type = (StmtType)item.getData()).getState()) != null) {
                this.setCurrState(s);
            }
        }
        if (this.allGroup != null) {
            for (StmtType type : this.allGroup.getTypes()) {
                String value = type.getState().getValue();
                if (!value.equalsIgnoreCase(Boolean.FALSE.toString())) continue;
                this.stmtTypeUnchecked.add(type);
            }
        }
    }

    private void loadStatements() {
        List allGroupsList = Utils.readStmtGroups(this.defProp, this.thisProp, 4);
        this.createStmtTreeModel(allGroupsList);
        this.lstGroups.refresh();
        this.lstGroups.setSelection(this.lstGroups.getSelection());
    }

    private void createStmtTreeModel(List allGroupsList) {
        HashMap<Integer, StmtTreeObject> stmtTreeObjects = new HashMap<Integer, StmtTreeObject>();
        if (allGroupsList != null && allGroupsList.size() > 0) {
            if (this.groups == null) {
                this.groups = new HashMap();
            }
            this.root = new StmtTreeObject("");
            int k = 0;
            while (k < allGroupsList.size()) {
                StmtGroup gr = (StmtGroup)allGroupsList.get(k);
                boolean isAvailable = Manager.getInstance().checkAvailability(this.pInfo, "stmtType", new Integer(k).toString());
                if (k != 0 && !isAvailable) {
                    Set notAvailable = gr.getTypes();
                    Set allTypes = this.allGroup.getTypes();
                    if (notAvailable != null) {
                        L.debug("group not available: {}", (Object)gr);
                    } else {
                        Set subgroups = gr.getSubgroups();
                        if (subgroups != null) {
                            for (Integer subgroupID : subgroups) {
                                StmtGroup subgroup = (StmtGroup)allGroupsList.get(subgroupID);
                                Set types = subgroup.getTypes();
                                if (types == null || types.size() <= 0) continue;
                                allTypes.removeAll(types);
                            }
                        }
                    }
                } else {
                    String grDisplayName = Messages.getString(ReportSettingsDialog.class, gr.getName());
                    gr.setDisplayName(grDisplayName);
                    StmtTreeObject to = new StmtTreeObject(grDisplayName);
                    to.setStmtId(gr.getName());
                    if (k == 0) {
                        this.allGroup = gr;
                        this.root.addChild(to);
                        to.setParent(this.root);
                        stmtTreeObjects.put(gr.getId(), to);
                        this.allGroup.getTypes().clear();
                    } else {
                        String parentString = gr.getParent();
                        Integer parentId = new Integer(parentString);
                        StmtTreeObject parentTreeObject = (StmtTreeObject)stmtTreeObjects.get(parentId);
                        StmtGroup parentGroup = (StmtGroup)allGroupsList.get(parentId);
                        if (parentTreeObject != null) {
                            to.setParent(parentTreeObject);
                            parentTreeObject.addChild(to);
                        }
                        if (parentGroup != null && gr.getTypes() != null) {
                            Set typesSet = gr.getTypes();
                            for (StmtType stmtType : typesSet) {
                                parentGroup.addType(stmtType);
                            }
                        }
                    }
                    stmtTreeObjects.put(gr.getId(), to);
                    this.groups.put(gr.getName(), gr);
                    this.allGroup.getTypes().addAll(gr.getTypes());
                }
                ++k;
            }
        }
    }

    private void fillList() {
        this.loadStatements();
        this.lstGroups.setInput((Object)this.root);
        this.lstGroups.refresh();
        this.lstGroups.expandAll();
        TreeItem ti = this.lstGroups.getTree().getItem(this.selIndex);
        this.lstGroups.getTree().setSelection(ti);
        if (this.lstGroups.getTree().getItemCount() > this.selIndex) {
            String name = ti.getText();
            this.currentGroup = (StmtGroup)this.groups.get(name);
        }
    }

    @Override
    protected void save() {
        String prjPath = com.ez.mainframe.data.utils.Utils.getProjectPathName((String)this.projectName);
        String path = prjPath.concat(File.separator).concat(this.getAnalysisFolder()).concat(Constants.PATH_SEPARATOR).concat(this.fileName);
        if (!path.endsWith(".properties")) {
            path = path.concat(".properties");
        }
        File sFile = new File(path);
        this.saveToFile(sFile, true);
    }

    /*
     * Loose catch block
     */
    @Override
    protected void saveToFile(File where, boolean asDefault) {
        Properties properties = new Properties();
        if (this.allGroup != null) {
            for (StmtType type : this.allGroup.getTypes()) {
                String value = type.getState().getValue();
                String defValue = type.getState().getDefValue();
                if (asDefault) {
                    if (!value.equalsIgnoreCase(Boolean.FALSE.toString())) continue;
                    properties.setProperty(type.getId().toString(), value.toString());
                    continue;
                }
                if (value.equals(defValue)) continue;
                properties.setProperty(type.getId().toString(), value.toString());
            }
        }
        if (!asDefault) {
            this.thisProp.clear();
            this.thisProp.putAll((Map<?, ?>)properties);
        }
        L.debug("saving to file: {}", (Object)where);
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(where);
                properties.store(fileOutputStream, "#stmt type = check state\n#if not present, falls to default. In default file, default value = check");
            }
            catch (FileNotFoundException e) {
                L.error("error at saving to file: {}", (Object)where, (Object)e);
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e2) {
                    L.error("saveToFile", (Throwable)e2);
                }
            }
            catch (IOException e) {
                L.error("error at saving to file: {}", (Object)where, (Object)e);
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e3) {
                    L.error("saveToFile", (Throwable)e3);
                }
            }
            catch (Throwable t) {
                L.error("error at saving to file: {}", (Object)where, (Object)t);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    L.error("saveToFile", (Throwable)e);
                }
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                L.error("saveToFile", (Throwable)e);
            }
        }
    }

    public Properties getDefProp() {
        return this.defProp;
    }

    public Properties getThisProp() {
        return this.thisProp;
    }

    @Override
    protected void initPage() {
        this.defaultFile = this.getDefaultSettFile();
        this.defProp = com.ez.mainframe.data.utils.Utils.readSettings((File)this.defaultFile);
        this.initiated = true;
    }

    @Override
    protected File getDefaultSettFile() {
        String prjPath = com.ez.mainframe.data.utils.Utils.getProjectPathName((String)this.projectName);
        String analysisPath = prjPath.concat(File.separator).concat(this.getAnalysisFolder());
        File folder = new File(analysisPath);
        boolean created = false;
        if (!folder.exists()) {
            try {
                created = folder.mkdirs();
            }
            catch (Exception e) {
                L.error("error at creating analysis setting directory: {}", (Object)analysisPath, (Object)e);
            }
        }
        String path = analysisPath.concat(Constants.PATH_SEPARATOR).concat("default.properties");
        return new File(path);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.btnDeselectAll.setEnabled(!readOnly);
        this.btnSelectAll.setEnabled(!readOnly);
        this.btnRestoreDefaults.setEnabled(!readOnly);
        if (!readOnly && this.defaultFile == null) {
            this.defaultFile = this.getDefaultSettFile();
        }
    }

    private class GroupSelectionListener
    implements ISelectionChangedListener {
        private GroupSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            StmtTreeObject to = (StmtTreeObject)((TreeSelection)selection).getFirstElement();
            String name = to.getStmtId();
            if (name != null && !name.equalsIgnoreCase("")) {
                HalsteadSettingsDialog.this.currentGroup = (StmtGroup)HalsteadSettingsDialog.this.groups.get(name);
                HalsteadSettingsDialog.this.fillTable(HalsteadSettingsDialog.this.selIndex);
            }
        }
    }

    private class StmtWeightSelectionListener
    implements Listener {
        private StmtWeightSelectionListener() {
        }

        public void handleEvent(Event e) {
            Integer tiIdx = (Integer)e.widget.getData(HalsteadSettingsDialog.IDX_KEY);
            TableItem item = HalsteadSettingsDialog.this.tblValues.getItem(tiIdx.intValue());
            StmtType type = (StmtType)item.getData();
            if (e.type == 13) {
                if (((Button)e.widget).getSelection()) {
                    HalsteadSettingsDialog.this.stmtTypeUnchecked.remove(type);
                    HalsteadSettingsDialog.this.removeErrorMessage(no_operators_err);
                } else {
                    HalsteadSettingsDialog.this.stmtTypeUnchecked.add(type);
                    if (HalsteadSettingsDialog.this.hasErrors()) {
                        HalsteadSettingsDialog.this.setErrorMessage(no_operators_err);
                    }
                }
                HalsteadSettingsDialog.this.setCurrState(type.getState());
                if (HalsteadSettingsDialog.this.currentState != null) {
                    if (type.getState().getValue().equalsIgnoreCase("true")) {
                        HalsteadSettingsDialog.this.currentState.setValue(Boolean.FALSE.toString());
                    } else if (type.getState().getValue().equalsIgnoreCase(Boolean.FALSE.toString())) {
                        HalsteadSettingsDialog.this.currentState.setValue("true");
                    }
                    HalsteadSettingsDialog.this.currentGroup.getType(type).setState(HalsteadSettingsDialog.this.currentState);
                    item.setData((Object)type);
                }
            }
        }
    }
}

