/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.menuHandlers.validators;

import com.ez.report.application.menuHandlers.validators.GeneratedReportsTableValidator;
import com.ez.report.generation.common.ReportsRepository;
import com.ez.report.generation.common.model.ReportInformation;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportsFileValidatorOnTable
extends GeneratedReportsTableValidator {
    private static final Logger L = LoggerFactory.getLogger(ReportsFileValidatorOnTable.class);

    @Override
    public boolean canShow() {
        return super.canShow();
    }

    @Override
    public boolean isEnabled() {
        boolean ret = true;
        TableItem[] titems = this.parentTable.getSelection();
        if (titems == null || titems.length == 0) {
            ret = false;
        } else {
            this.loadGeneratedConfig();
            int i = 0;
            while (i < titems.length) {
                TableItem item = titems[i];
                String reportValues = this.generatedPropFile.getProperty(item.getText());
                if (reportValues == null) {
                    L.error("NULL values in generated.properties for report: " + item.getText());
                    ret = false;
                } else {
                    String[] values = reportValues.split(",");
                    if (values == null || values.length < 3) {
                        L.error("Wrong values [" + reportValues + "] in generated.properties for report: " + item.getText());
                        ret = false;
                    } else {
                        String repIndicator = values[0].trim();
                        ReportInformation repInfo = ReportsRepository.getReportInformation((String)repIndicator);
                        if (!repInfo.hasProperties()) {
                            ret = false;
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        return ret;
    }
}

