/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.utils;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.model.LogMessage;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.ezsource.connection.ServerType;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.PathUtils;
import com.ez.mainframe.model.StmtState;
import com.ez.mainframe.model.StmtType;
import com.ez.mainframe.model.StmtWeight;
import com.ez.mainframe.reports.gui.internal.Activator;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.preferences.PreferenceUtils;
import com.ez.mainframe.selection.Manager;
import com.ez.report.application.ezreport.reports.summary.ProgramSummaryScriptlet;
import com.ez.report.generation.common.model.Constants;
import com.ez.report.generation.common.utils.ReportsUtils;
import com.ez.scl.procedures.SCLProceduresReader;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Utils.class);
    private static final Integer DEFAULT_VALUE_OF_WEIGHTS = new Integer(1);
    public static final String GENERATED_PROPERTIES_FILENAME = "generated.properties";

    public static List readStmtGroups(Properties defProp, Properties thisProp, int reportType) {
        Map allStmtTypes = null;
        allStmtTypes = com.ez.mainframe.data.utils.Utils.readStmtTypes();
        if (reportType == 5) {
            Utils.fillStmtWeightInfo(allStmtTypes, defProp, true);
            Utils.fillStmtWeightInfo(allStmtTypes, thisProp, false);
        } else if (reportType == 4) {
            Utils.fillStmtState(allStmtTypes, defProp, true);
            Utils.fillStmtState(allStmtTypes, thisProp, false);
        }
        List groups = com.ez.mainframe.data.utils.Utils.getStmtGroups((Map)allStmtTypes, null, null);
        return groups;
    }

    private static void fillStmtWeightInfo(Map stmtTypes, Properties prop, boolean readAsDefault) {
        for (StmtType type : stmtTypes.values()) {
            StmtWeight weight = type.getObj();
            if (weight == null) {
                weight = new StmtWeight(type);
                type.setWeight(weight);
            }
            String value = DEFAULT_VALUE_OF_WEIGHTS.toString();
            if (prop != null) {
                value = prop.getProperty(type.getId().toString());
            }
            weight.setDefValue(DEFAULT_VALUE_OF_WEIGHTS);
            if (value != null) {
                weight.setValue(Integer.valueOf(value));
                continue;
            }
            weight.setValue(weight.getDefValue());
        }
    }

    private static void fillStmtState(Map stmtTypes, Properties prop, boolean readAsDefault) {
        for (StmtType type : stmtTypes.values()) {
            StmtState state = type.getState();
            if (state == null) {
                state = new StmtState(type);
                type.setState(state);
            }
            String value = null;
            if (prop != null && prop.containsKey(type.getId().toString())) {
                value = prop.getProperty(type.getId().toString());
            }
            if (value != null) {
                if (readAsDefault) {
                    state.setDefValue(value);
                    continue;
                }
                state.setValue(value);
                continue;
            }
            if (readAsDefault) {
                state.setDefValue("true");
                continue;
            }
            state.setValue(state.getDefValue());
        }
    }

    public static boolean lockProject(String prjName, EZSourceConnection conn) {
        return com.ez.report.application.utils.Utils.lockProject((EZSourceConnection)conn);
    }

    public static void addScriptlet(Map parameters, String className) {
        if (className == null || className.isEmpty()) {
            className = ProgramSummaryScriptlet.class.getName();
        }
        ClassLoader loader = Activator.class.getClassLoader();
        ReportsUtils.addScriptlet((Map)parameters, (String)className, (ClassLoader)loader);
    }

    public static Set<Integer> getIDs(Collection<BaseResourceInput> resources) {
        HashSet<Integer> selectedIds = new HashSet<Integer>();
        for (BaseResourceInput inpt : resources) {
            selectedIds.add(inpt.getResourceID());
        }
        return selectedIds;
    }

    public static boolean hasSCL(Collection<Integer> inputIds) {
        return Utils.hasSCL(inputIds, null);
    }

    public static boolean hasSCL(Collection<Integer> inputIds, EZSourceConnection conn) {
        boolean ret = true;
        EZSourceConnection bridge = null;
        try {
            try {
                String[][] res;
                bridge = conn == null ? EZSourceConnectionManager.getCurrent() : conn;
                String sqlString = "select count(*) from programs where programtypeid in (13,19) ";
                if (inputIds != null && inputIds.size() > 0) {
                    String idsStr = inputIds.toString();
                    idsStr = idsStr.substring(1);
                    idsStr = idsStr.substring(0, idsStr.length() - 1);
                    sqlString = String.valueOf(sqlString) + "and programid in (" + idsStr + ")";
                }
                ret = (res = bridge.executeSQL(sqlString)) != null && res.length > 0 && !res[0][0].equals("0");
            }
            catch (EZSourceConnectionException e) {
                L.error("exception at counting SCLs", (Throwable)e);
                EZReportErrorLog.err(Messages.getString(Utils.class, "countingSCLProgramsError.logMessage"), e);
                if (conn == null && bridge != null) {
                    EZSourceConnectionManager.release((EZSourceConnection)bridge);
                }
            }
        }
        finally {
            if (conn == null && bridge != null) {
                EZSourceConnectionManager.release((EZSourceConnection)bridge);
            }
        }
        return ret;
    }

    public static boolean isVME(EZSourceConnection bridge) {
        boolean ret = false;
        ProjectInfo prjInfo = bridge.getProjectInfo();
        if (prjInfo != null) {
            Properties parameters = new Properties();
            parameters.setProperty("env", "VME");
            ret = Manager.getInstance().checkAvailability(prjInfo, parameters);
            L.debug("{} isVME={}", (Object)bridge.getOpenedProject(), (Object)ret);
        } else {
            L.warn("no project info for given bridge");
        }
        return ret;
    }

    public static void insertSCLProcs(EZSourceConnection bridge, String tempTableName) {
        boolean useDBSclProcedures = Boolean.valueOf(System.getProperties().getProperty("useDbSclProcedures", "true"));
        if (useDBSclProcedures) {
            L.info("Using SCL Procedures from database.");
            L.debug("before insert into temp table.");
            bridge.executeUpdate("INSERT INTO " + com.ez.mainframe.data.utils.Utils.getTempTableName((EZSourceConnection)bridge, (String)tempTableName) + " SELECT * FROM " + "SCLStandardProcedures");
        } else {
            L.info("Using SCL Procedures from JSON.");
            Set procedures = SCLProceduresReader.getSCLProceduresContainer().getProcedureNames();
            L.debug("before insert into temp table; number of procedures: {}", (Object)procedures.size());
            if (procedures != null && !procedures.isEmpty()) {
                com.ez.mainframe.data.utils.Utils.insertValues((EZSourceConnection)bridge, (String)tempTableName, (EZSourceDataType)EZSourceDataType.String, (Collection)procedures);
            } else {
                L.warn("no SCL standard procedures to be inserted!");
            }
        }
    }

    public static String createCallingTempTable(EZSourceConnection bridge, Logger L) {
        String tempTableName = "calling_temp";
        String tempTable = com.ez.mainframe.data.utils.Utils.getTempTableName((EZSourceConnection)bridge, (String)tempTableName);
        String createStr = null;
        String columnCreateStr = " (StartRow int, PathStr varchar(255), ProgramName varchar(255), ancestor varchar(255) )";
        ServerType dbEngine = bridge.getProjectInfo().getDbEngine();
        switch (dbEngine) {
            case SqlServer: {
                createStr = "create table " + tempTable + columnCreateStr;
                break;
            }
            case Db2Z: {
                createStr = " DECLARE GLOBAL TEMPORARY TABLE " + tempTable + columnCreateStr + " CCSID UNICODE " + " ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
            case Db2: {
                createStr = " DECLARE GLOBAL TEMPORARY TABLE " + tempTable + columnCreateStr + " WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ";
            }
        }
        Assert.isNotNull(createStr);
        bridge.executeUpdate(createStr);
        L.trace("after create " + tempTable + " temp table");
        String q = String.format("insert into %s (StartRow,PathStr,ProgramName,Ancestor) SELECT DISTINCT StatementReference.StartRow, Paths.PathStr, pa.ProgramName, pa.Ancestor FROM StatementReference INNER JOIN OccurrencesStmt ON StatementReference.OccurID = OccurrencesStmt.OccurID INNER JOIN (SELECT Programs.ProgramID, Programs.ProgramTypeID, ProgramAliases.AliasName AS ProgramName \tFROM Programs INNER JOIN ProgramAliases ON Programs.ProgramID = ProgramAliases.ProgramId and ProgramAliases.AliasType = 0) AS Programs_1  ON StatementReference.ResourceID = Programs_1.ProgramID INNER JOIN (SELECT Programs.ProgramID, Programs.OccurID, ProgramAliases.AliasName AS ProgramName, Programs.Ancestor \tFROM Programs INNER JOIN ProgramAliases ON Programs.ProgramID = ProgramAliases.ProgramId and ProgramAliases.AliasType = 0) AS pa  ON OccurrencesStmt.ProgID = pa.ProgramID AND Programs_1.ProgramName <> pa.ProgramName INNER JOIN Occurrences ON pa.OccurID = Occurrences.OccurID INNER JOIN Paths ON Occurrences.PathID = Paths.PathID WHERE (StatementReference.ResourceType = 5) AND (Programs_1.ProgramTypeID not in (-1,9) ) ", tempTable);
        bridge.executeInsert(q);
        L.trace("after insert into " + tempTable + " temp table");
        return tempTableName;
    }

    public static String getGeneratedDirectory() {
        IPreferenceStore store = PreferenceUtils.getPreferenceStore();
        String pathFromPref = store.getString("reportsPathPreference");
        if (pathFromPref == null || pathFromPref.equals("")) {
            pathFromPref = store.getDefaultString("reportsPathPreference");
        }
        if (!pathFromPref.endsWith(Constants.PATH_SEPARATOR)) {
            pathFromPref = pathFromPref.concat(Constants.PATH_SEPARATOR);
        }
        return pathFromPref;
    }

    public static String getGeneratedFileProperties() {
        String path = String.valueOf(PathUtils.METADATA_FOLDER.getAbsolutePath()) + File.separator;
        String filePath = path.concat(GENERATED_PROPERTIES_FILENAME);
        return filePath;
    }

    @Deprecated
    public static IPreferenceStore getPreferenceStore() {
        Activator activator = Activator.getDefault();
        IPreferenceStore ret = null;
        if (activator != null) {
            ret = activator.getPreferenceStore();
        }
        return ret;
    }

    public static void printMessages(Queue<LogMessage> buildMessages) {
        if (buildMessages != null && !buildMessages.isEmpty()) {
            boolean b = true;
            while (b) {
                LogMessage msg = buildMessages.poll();
                boolean bl = b = msg != null;
                if (!b) continue;
                String plugin = msg.getPluginID();
                if (plugin == null) {
                    plugin = "com.ez.mainframe.reports.gui";
                }
                LogUtil.displayErrorMessage((Status)new Status(msg.getSeverity(), plugin, msg.getMessage(), msg.getThrowable()), (boolean)false);
            }
        }
    }

    public static String buildCreateStr4DSParamTable(EZSourceConnection conn, String tempTableName) {
        StringBuilder createTempSql = new StringBuilder();
        String tblName = com.ez.mainframe.data.utils.Utils.getTempTableName((EZSourceConnection)conn, (String)tempTableName);
        String columnDefs = " (dsId int not null, dsMemberName varchar(250))";
        ServerType dbEngine = conn.getProjectInfo().getDbEngine();
        switch (dbEngine) {
            case SqlServer: {
                createTempSql.append("create table ");
                createTempSql.append(tblName);
                createTempSql.append(columnDefs);
                break;
            }
            case Db2Z: {
                createTempSql.append(" DECLARE GLOBAL TEMPORARY TABLE ");
                createTempSql.append(tblName);
                createTempSql.append(columnDefs);
                createTempSql.append(" CCSID UNICODE ");
                createTempSql.append(" ON COMMIT PRESERVE ROWS NOT LOGGED ");
                break;
            }
            case Db2: {
                createTempSql.append(" DECLARE GLOBAL TEMPORARY TABLE ");
                createTempSql.append(tblName);
                createTempSql.append(columnDefs);
                createTempSql.append(" WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ");
                break;
            }
        }
        if (createTempSql.length() == 0) {
            L.warn("empty CREATE string for tableName={} and dbEngine={}", (Object)tblName, (Object)dbEngine);
        }
        return createTempSql.toString();
    }
}

