/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.twolevels;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.twolevels.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.twolevels.WULevel2Scriptlet;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WUTwoLevelsBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(WUTwoLevelsBuilder.class);
    protected String UTILITY_COLUMN2_TEXT = Messages.getString(WUTwoLevelsBuilder.class, "utility.statement.text");
    protected static final String QUERY1_DESCRIPTION_TEXT = "#EZ1#";
    protected static final String QUERY2_DESCRIPTION_TEXT = "#EZ2#";
    protected String LOADMODULE_COLUMN2_TEXT = Messages.getString(WUTwoLevelsBuilder.class, "nodatasets.label");
    protected String UNKNOWNPROGRAM_GROUPSUMMARY_LABEL = Messages.getString(WUTwoLevelsBuilder.class, "datasets.summary.lbl");
    protected String UTILITY_GROUPSUMMARY_LABEL = Messages.getString(WUTwoLevelsBuilder.class, "group.summary.utilityUsage");
    protected String UTILITY_DETAIL_FIRSTCOLUMN_PART = Messages.getString(WUTwoLevelsBuilder.class, "column1.detail.accesstype.utility");
    protected String LOADMODULE_DETAIL_FIRSTCOLUMN_PART = Messages.getString(WUTwoLevelsBuilder.class, "column1.detail.accesstype.loadmodule");
    protected String UNKOWNPROGRAM_DETAIL_FIRSTCOLUMN_PART = Messages.getString(WUTwoLevelsBuilder.class, "column1.detail.accesstype.program");
    protected String UNKOWNPROGRAM_CHART_TEXT = Messages.getString(WUTwoLevelsBuilder.class, "chart.accesstype.unknownprogram");
    protected String LOADMODULE_CHART_TEXT = Messages.getString(WUTwoLevelsBuilder.class, "chart.accesstype.loadmodule");
    protected String UTILITY_CHART_TEXT = Messages.getString(WUTwoLevelsBuilder.class, "chart.accesstype.utility");
    protected Map<String, Map<String, Integer>> allResMap = null;
    protected Map<String, Object> usedResources = null;
    protected String tempTableName = "numeric_param_temp1";

    public WUTwoLevelsBuilder(String reportName, String settings) {
        this.report = null;
        this.usedResources = new HashMap<String, Object>();
        this.allResMap = new HashMap<String, Map<String, Integer>>();
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/wuLevel2.jasper";
    }

    protected void buildSummaryStackBar() {
        String stackTitle = Messages.getString(((Object)((Object)this)).getClass(), "pie2.title");
        DefaultCategoryDataset ds = this.buildDataSet(this.usedResources);
        String subtitle = null;
        if (this.usedResources.keySet().size() >= 20) {
            Object[] msgParams = new String[]{String.valueOf(20)};
            stackTitle = stackTitle.concat(" ").concat(Messages.getString(((Object)((Object)this)).getClass(), "bar.title", msgParams));
            if (this.countsSame != 0) {
                msgParams = new String[]{String.valueOf(this.countsSame)};
                stackTitle = stackTitle.concat("*");
                subtitle = Messages.getString(((Object)((Object)this)).getClass(), "bar.subtitle", msgParams);
            }
        }
        String xAxis = Messages.getString(((Object)((Object)this)).getClass(), "bar.category.axis");
        String yAxis = Messages.getString(((Object)((Object)this)).getClass(), "bar.value.axis");
        this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(ds, stackTitle, xAxis, yAxis, 880, 540, null, subtitle));
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(WUTwoLevelsBuilder.class, "collectingData.taskName"));
        List<Obj4Report> resultList = this.data(monitor.newChild(100));
        ReportDataSource dataSource = new ReportDataSource(resultList, this.allResMap);
        return dataSource;
    }

    protected List<Obj4Report> data(SubMonitor pmonitor) {
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(WUTwoLevelsBuilder.class, "compute.taskName"));
        this.prepareParamsFromDBData();
        monitor.setWorkRemaining(90);
        List<Obj4Report> resultList = null;
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            resultList = this.getDBData((IProgressMonitor)pmonitor, csvWriter);
        }
        monitor.setWorkRemaining(20);
        int allResInputNo = this.getSelected().size();
        if (allResInputNo != 0) {
            this.buildSummaryFirstChart(allResInputNo);
            monitor.setWorkRemaining(10);
            if (this.usedResources.size() > 0) {
                this.buildSummaryStackBar();
            }
            monitor.setWorkRemaining(10);
        }
        monitor.setWorkRemaining(0);
        return resultList;
    }

    protected void prepareParamsFromDBData() {
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        if (prgList != null) {
            this.buildInputs4Appendix(prgList);
            if (this.applicationsName == null || this.applicationsName.isEmpty()) {
                this.parameters.put("title.appFieldValues", this.applicationsName);
            }
        }
        boolean isUCMDB = false;
        if (this.pInfo != null) {
            isUCMDB = this.pInfo.isUMCDB();
        } else {
            L.warn("pInfo null for project {}", (Object)this.project);
        }
        Utils.setParamsForTitle((Map)this.parameters, (String)this.project, (boolean)isUCMDB, (Map)this.inputs);
    }

    protected void clearForJasperReport() {
        this.usedResources.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    @Override
    public void cleanMemory() {
        if (this.allResMap != null) {
            this.allResMap.clear();
            this.allResMap = null;
        }
        if (this.usedResources != null) {
            this.usedResources.clear();
            this.usedResources = null;
        }
        super.cleanMemory();
    }

    protected void buildSummaryFirstChart(int allPrgNo) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        String usedCategory = this.getUsedCategoryLegendLabel();
        String unusedCategory = this.getUnusedCategoryLegendLabel();
        String not_using_category_lbl = this.getUnusedCategoryLabel();
        String using_category_lbl = this.getUsedCategoryLabel();
        dataset.setValue((Comparable)((Object)not_using_category_lbl), (Number)new Double(allPrgNo - this.usedResources.size()));
        dataset.setValue((Comparable)((Object)using_category_lbl), (Number)new Double(this.usedResources.size()));
        this.getInputTypeName();
        HashMap<String, String> formatsMap = new HashMap<String, String>();
        formatsMap.put(not_using_category_lbl, unusedCategory);
        formatsMap.put(using_category_lbl, usedCategory);
        this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap, this.getPieTitle(), 880, 540, null));
    }

    protected String getUsedCategoryLabel() {
        return Messages.getString(WUTwoLevelsBuilder.class, "using.lbl");
    }

    protected String getUnusedCategoryLabel() {
        return Messages.getString(WUTwoLevelsBuilder.class, "notUsing.lbl");
    }

    protected abstract String getUsedCategoryLegendLabel();

    protected abstract String getUnusedCategoryLegendLabel();

    protected abstract String getPieTitle();

    protected abstract String getInputTypeName();

    protected abstract List<Obj4Report> getDBData(IProgressMonitor var1, CSVWriter var2);

    @Override
    public Map<String, Object> getReportParameters(IProgressMonitor pmonitor) {
        this.parameters = super.getReportParameters(pmonitor);
        com.ez.report.application.ezreport.utils.Utils.addScriptlet(this.parameters, WULevel2Scriptlet.class.getName());
        return this.parameters;
    }

    @Override
    protected void putExternalizedParameters(Map<String, Object> params) {
        String externalized = Messages.getString(WUTwoLevelsBuilder.class, "detail.column2.name");
        params.put("column2.name", externalized);
        externalized = Messages.getString(WUTwoLevelsBuilder.class, "detail.column1.name");
        params.put("column1.name", externalized);
        externalized = Messages.getString(WUTwoLevelsBuilder.class, "detail.column3.name");
        params.put("column3.name", externalized);
        externalized = Messages.getString(WUTwoLevelsBuilder.class, "summary");
        params.put("summary", externalized);
        externalized = Messages.getString(WUTwoLevelsBuilder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(WUTwoLevelsBuilder.class, "sum4");
        params.put("sum4", externalized);
    }

    protected String getColum2Text(String stmtType, AccessingType type) {
        switch (type) {
            case PROGRAM: {
                return Messages.getString(WUTwoLevelsBuilder.class, "column2.detail.text", new String[]{stmtType});
            }
            case LOAD_MODULE: 
            case UNKNOWN_PROGRAM: {
                return this.LOADMODULE_COLUMN2_TEXT;
            }
            case UTILITY: {
                return this.UTILITY_COLUMN2_TEXT;
            }
        }
        return null;
    }

    protected String getColum1Text(String name, AccessingType type) {
        switch (type) {
            case PROGRAM: {
                return name;
            }
            case UTILITY: {
                return Messages.getString(WUTwoLevelsBuilder.class, "column1.detail.text", new String[]{name, this.UTILITY_DETAIL_FIRSTCOLUMN_PART});
            }
            case LOAD_MODULE: {
                return Messages.getString(WUTwoLevelsBuilder.class, "column1.detail.text", new String[]{name, this.LOADMODULE_DETAIL_FIRSTCOLUMN_PART});
            }
            case UNKNOWN_PROGRAM: {
                return Messages.getString(WUTwoLevelsBuilder.class, "column1.detail.text", new String[]{name, this.UNKOWNPROGRAM_DETAIL_FIRSTCOLUMN_PART});
            }
        }
        return null;
    }

    protected static enum AccessingType {
        LOAD_MODULE,
        UTILITY,
        PROGRAM,
        UNKNOWN_PROGRAM;

    }
}

