/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.twolevels;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUDataSource;
import com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report;
import java.awt.Image;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDataSource
extends WUDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportDataSource.class);
    protected List<Obj4Report> list = null;
    Obj4Report currentValue = null;
    protected Map allPrgMap;
    protected String stackedBarTitle = Messages.getString(ReportDataSource.class, "stackedBar.title");
    protected String domainAxisLabel = Messages.getString(ReportDataSource.class, "stackedBar.domainAxis.lbl");
    protected String rangeAxisLabel = Messages.getString(ReportDataSource.class, "stackedBar.rangeAxis.lbl");

    public ReportDataSource(List list, Map map) {
        this.list = list;
        this.allPrgMap = map;
    }

    public boolean nextItem() throws JRException {
        Obj4Report obj4Report = this.currentValue = this.list != null && this.list.size() > 0 ? this.list.remove(0) : null;
        if (this.currentValue != null) {
            Obj4Report nextV = this.list.size() > 0 ? this.list.get(0) : null;
            Obj4Report obj = this.currentValue;
            if (nextV != null) {
                this.firstInGroup = this.lastInGroup;
                if (nextV.level1.equalsIgnoreCase(obj.level1)) {
                    this.lastInGroup = false;
                } else {
                    this.lastInGroup = true;
                    DefaultCategoryDataset ds = this.getCountBarDataset(this.allPrgMap, obj.level1);
                    Image img = this.createStackedBar(ds, this.stackedBarTitle, this.domainAxisLabel, this.rangeAxisLabel, 1020, 600);
                    obj.setBarImg(img);
                }
                this.lastInReport = false;
            } else {
                this.firstInGroup = this.lastInGroup;
                this.lastInGroup = true;
                DefaultCategoryDataset ds = this.getCountBarDataset(this.allPrgMap, obj.level1);
                Image img = this.createStackedBar(ds, this.stackedBarTitle, this.domainAxisLabel, this.rangeAxisLabel, 1020, 600);
                obj.setBarImg(img);
                this.lastInReport = true;
            }
            L.debug("currentVal: {} -- first={} -- last={}", new Object[]{this.currentValue, this.firstInGroup, this.lastInGroup});
            return true;
        }
        return false;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (!field.getName().equalsIgnoreCase("printColsHeader") && !field.getName().equalsIgnoreCase("printGroupHeader")) {
            Obj4Report values = this.currentValue;
            value = values.get(field.getName());
        }
        return value;
    }

    public void setStackedBarTitle(String stackedBarTitle) {
        this.stackedBarTitle = stackedBarTitle;
    }

    public void setDomainAxisLabel(String domainAxisLabel) {
        this.domainAxisLabel = domainAxisLabel;
    }

    public void setRangeAxisLabel(String rangeAxisLabel) {
        this.rangeAxisLabel = rangeAxisLabel;
    }
}

