/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.sqlTablesVsJobs;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.MultiAppInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.jobsVsSQLTables.ReportModel;
import com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.twolevels.WUTwoLevelsBuilder;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUTwoLevelsBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String STORED_PROCEDURE = "EZReports_SQLTablesVsJobs";
    private static final String STORED_PROCEDURE_SEL = "EZReports_SQLTablesVsJobs_Selective";
    private static final String STORED_PROCEDURE_UCMDB = "EZReports_SQLTablesVsJobs_UCMDB";
    private static final String STORED_PROCEDURE_SEL_UCMDB = "EZReports_SQLTablesVsJobs_UCMDB_Selective";
    private Map<String, Integer> stmtCountMap = new HashMap<String, Integer>();

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    protected void putExternalizedParameters(Map<String, Object> params) {
        super.putExternalizedParameters(params);
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "detail.column2.name");
        params.put("column2.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "detail.column1.name");
        params.put("column1.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum3");
        params.put("sum3", externalized);
    }

    @Override
    protected List<Obj4Report> getDBData(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        ArrayList<Obj4Report> result = null;
        SingleQueryResult queryResult = this.queryForData(pmonitor);
        String[][] results = queryResult.data;
        if (results == null) {
            L.warn("no results for UsedSQLTablesInJobs report");
        } else {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)results.length);
            result = new ArrayList<Obj4Report>();
            L.debug("SQLTables Vs Jobs results:");
            String currentTbl = null;
            String currentJob = null;
            int count = 0;
            int i = 0;
            while (i < results.length) {
                Integer countValue;
                HashMap<String, Integer> prgMap;
                String[] row = results[i];
                results[i] = null;
                String sqlTblName = row[0];
                String jobName = row[1];
                String prgName = row[2];
                String ancestor = row[3];
                String stmtType = row[4];
                Integer stmtCount = new Integer(Integer.parseInt(row[5]));
                String memberName = row.length > 6 ? row[7] : null;
                String jobNameToPrint = memberName != null && !memberName.equalsIgnoreCase(jobName) ? String.valueOf(jobName) + " (" + memberName + ")" : jobName;
                String prgPath = row[8];
                if (ancestor != null && !ancestor.isEmpty()) {
                    prgName = String.valueOf(ancestor) + ": " + prgName;
                }
                if (prgPath != null && !prgPath.isEmpty()) {
                    prgName = prgName.concat(" (").concat(prgPath).concat(")");
                }
                if (currentTbl == null) {
                    currentTbl = sqlTblName;
                    currentJob = jobNameToPrint;
                    ++count;
                } else if (!currentTbl.equalsIgnoreCase(sqlTblName)) {
                    this.usedResources.put(currentTbl, new Integer(count));
                    currentTbl = sqlTblName;
                    currentJob = jobNameToPrint;
                    count = 1;
                } else if (!currentJob.equalsIgnoreCase(jobNameToPrint)) {
                    currentJob = jobNameToPrint;
                    ++count;
                }
                if (i == results.length - 1) {
                    this.usedResources.put(currentTbl, new Integer(count));
                }
                if ((prgMap = (HashMap<String, Integer>)this.allResMap.get(sqlTblName)) == null) {
                    prgMap = new HashMap<String, Integer>();
                    this.allResMap.put(sqlTblName, prgMap);
                }
                countValue = (countValue = (Integer)prgMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                prgMap.put(stmtType, countValue);
                if (!this.stmtCountMap.containsKey(stmtType)) {
                    this.stmtCountMap.put(stmtType, stmtCount);
                } else {
                    int temp = this.stmtCountMap.get(stmtType);
                    int currentCount = stmtCount;
                    this.stmtCountMap.put(stmtType, new Integer(temp + currentCount));
                }
                L.debug("sql table: {}", (Object)sqlTblName);
                L.debug("job: {}", (Object)jobName);
                L.debug("memberName: {}", (Object)memberName);
                L.debug("program: {}", (Object)prgName);
                L.debug("stmt type: {}", (Object)stmtType);
                L.debug("count: {}", (Object)stmtCount);
                L.debug("\n");
                Obj4Report obj = new Obj4Report();
                obj.level1 = sqlTblName;
                obj.level1Type = Messages.getString(ReportBuilder.class, "sqlTable.group.type");
                obj.level2 = jobNameToPrint;
                obj.level2Type = Messages.getString(ReportBuilder.class, "detail.resourceType");
                obj.level3 = prgName;
                obj.setStmtType(stmtType);
                obj.setCount(stmtCount);
                result.add(obj);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{sqlTblName, jobNameToPrint, prgName, stmtType, stmtCount.toString()});
                }
                monitor.worked(1);
                ++i;
            }
        }
        return result;
    }

    @Override
    protected void buildSummaryFirstChart(int allPrgNo) {
        if (this.stmtCountMap.size() > 0) {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            ArrayList<String> stmtTypes = new ArrayList<String>(this.stmtCountMap.keySet());
            Collections.sort(stmtTypes);
            for (String stmtType : stmtTypes) {
                dataset.addValue((Number)this.stmtCountMap.get(stmtType), (Comparable)((Object)stmtType), (Comparable)((Object)stmtType));
            }
            String title = Messages.getString(ReportBuilder.class, "pie1.title");
            String xAxis = Messages.getString(ReportBuilder.class, "firstbar.category.axis");
            String yAxis = Messages.getString(ReportBuilder.class, "firstbar.value.axis");
            this.parameters.put("usagePie", this.createFirstStackedBar(dataset, title, xAxis, yAxis, 1000, 760));
        } else {
            super.buildSummaryFirstChart(allPrgNo);
        }
    }

    @Override
    protected String getUsedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(ReportBuilder.class, (String)"used.category.lbl");
    }

    @Override
    protected String getUnusedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(ReportBuilder.class, (String)"unused.category.lbl");
    }

    @Override
    protected String getPieTitle() {
        return Messages.getString(ReportBuilder.class, "pie1.title");
    }

    @Override
    protected String getInputTypeName() {
        return Messages.getString(ReportBuilder.class, "inputTypeName.lbl");
    }

    @Override
    protected String getUsedCategoryLabel() {
        return Messages.getString(ReportBuilder.class, "using.lbl");
    }

    @Override
    protected String getUnusedCategoryLabel() {
        return Messages.getString(ReportBuilder.class, "notUsing.lbl");
    }

    protected String getProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return STORED_PROCEDURE_UCMDB;
        }
        return STORED_PROCEDURE;
    }

    protected String getSelectiveProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return STORED_PROCEDURE_SEL_UCMDB;
        }
        return STORED_PROCEDURE_SEL;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            Collection selected = (Collection)this.inputs.get("selected resources");
            this.report.setInput((Object)selected);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", selectedApps);
            if (selectedApps != null) {
                Collection appNames = (Collection)this.inputs.get("selected applications names");
                for (MultiAppInputNoGUI prg : selected) {
                    prg.setApplicationsName((Set)appNames);
                }
            }
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected String prepareAppendixResrsList(Set prgList) {
        String ret = "";
        ret = ret.concat(prgList.toString());
        Object selectedApps = this.report.getProperty("filtered by app");
        if (selectedApps != null && ((Boolean)selectedApps).booleanValue() && this.isMultiApp()) {
            Set apps = null;
            Iterator iterator = prgList.iterator();
            while (iterator.hasNext() && apps == null) {
                MultiAppInputNoGUI prg = (MultiAppInputNoGUI)iterator.next();
                if (prg.getApplications() == null || prg.getApplications().isEmpty()) continue;
                apps = prg.getApplications();
            }
            if (apps != null && !apps.isEmpty()) {
                ret = ret.concat("\n");
                ret = ret.concat(Messages.getString(ReportBuilder.class, "appendix.applications.part")).concat(apps.toString());
                this.setApplicationName(apps);
            }
        }
        return ret;
    }

    @Override
    protected void clearForJasperReport() {
        this.stmtCountMap.clear();
        super.clearForJasperReport();
    }

    @Override
    public void cleanMemory() {
        if (this.stmtCountMap != null) {
            this.stmtCountMap.clear();
            this.stmtCountMap = null;
        }
        super.cleanMemory();
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.sqlTable"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.job"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

