/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.smartTablesVsPrograms;

import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.wizard.GenericSelectInputPage4Report;
import com.ez.report.application.ezreport.reports.wu.WUAbstractAnalysis;
import com.ez.report.application.ezreport.reports.wu.smartTablesVsPrograms.SMARTTablesVsProgramsJob;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.collectors.ProgramsCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMARTTablesVsProgramsAnalysis
extends WUAbstractAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SMARTTablesVsProgramsAnalysis.class);

    public SMARTTablesVsProgramsAnalysis() {
        this(null);
    }

    public SMARTTablesVsProgramsAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    public PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(SMARTTablesVsProgramsAnalysis.class, "wizzard.title");
        wizard.setWindowTitle(wizardName);
        GenericSelectInputPage4Report selectProgramsPage = new GenericSelectInputPage4Report("programs page");
        selectProgramsPage.setLeftGroupLabel(Messages.getString(SMARTTablesVsProgramsAnalysis.class, "av.objectType.SMARTTables"));
        selectProgramsPage.setRightGroupLabel(Messages.getString(SMARTTablesVsProgramsAnalysis.class, "sel.objectType.SMARTTables"));
        String smartTablesQuery = "SELECT DISTINCT Variables.VarName FROM (Variables INNER JOIN        ( Occurrences INNER JOIN  Paths ON Occurrences.PathID = Paths.PathID)         ON Variables.OccurID = Occurrences.OccurID )        LEFT OUTER JOIN Variables Variables_1         ON Variables.Ancestor = Variables_1.VarID WHERE (Variables_1.VarName = 'TABLES')";
        L.debug("smart tables query: {}", (Object)smartTablesQuery);
        ProgramsCollector pc = new ProgramsCollector();
        pc.setProgramsQuery(smartTablesQuery);
        pc.setProgramsForAppQuery(smartTablesQuery);
        selectProgramsPage.setResourcesCollector((ResourcesCollector)pc);
        wizard.addPage(selectProgramsPage);
        return wizard;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_SMART_TABLES_VS_PROGRAMS_ANALYSIS;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(id, SMARTTablesVsProgramsJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }
}

