/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.smartScreensVsPrograms;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.smartScreensVsPrograms.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.smartScreensVsPrograms.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.smartScreensVsPrograms.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String STORED_PROCEDURE = "EZReports_SmartScreensVsPrograms";
    private static final String STORED_PROCEDURE_SEL = "EZReports_SmartScreensVsPrograms_Selective";
    private static final String STORED_PROCEDURE_UCMDB = "EZReports_SmartScreensVsPrograms_UCMDB";
    private static final String STORED_PROCEDURE_SEL_UCMDB = "EZReports_SmartScreensVsPrograms_UCMDB_Selective";
    Map allFilesMap = null;
    private Map stmtCountMap = null;
    private Map accesCountMap = null;

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.resultList = new ArrayList();
        this.allFilesMap = new HashMap();
        this.stmtCountMap = new HashMap();
        this.accesCountMap = new HashMap();
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
        }
        ReportDataSource dataSource = new ReportDataSource(this.resultList, this.allFilesMap);
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            Collection allResrs;
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            Collection selected = (Collection)this.inputs.get("selected resources");
            this.report.setInput((Object)selected);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", selectedApps);
            if (selectedApps != null) {
                Collection appNames = (Collection)this.inputs.get("selected applications names");
                for (ProgramInputNoGUI prg : selected) {
                    prg.setApplicationsName((Set)appNames);
                }
            }
            if ((allResrs = (Collection)this.inputs.get("available resources")) != null) {
                this.report.addProperty("totalResources", (Object)allResrs.size());
            }
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "stmtType.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "summary");
        params.put("summary", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum4");
        params.put("sum4", externalized);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/usedFiles.jasper";
    }

    private void clearForJasperReport() {
        this.accesCountMap.clear();
        this.stmtCountMap.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    protected String getProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return STORED_PROCEDURE_UCMDB;
        }
        return STORED_PROCEDURE;
    }

    protected String getSelectiveProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return STORED_PROCEDURE_SEL_UCMDB;
        }
        return STORED_PROCEDURE_SEL;
    }

    private String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        DefaultPieDataset dataset;
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "compute.taskName"));
        SingleQueryResult queryResult = this.queryForData(pmonitor);
        String[][] results = queryResult.data;
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.buildInputs4Appendix(prgList);
        this.parameters.put("title.appFieldValues", this.applicationsName);
        if (results == null) {
            L.warn("no results for SMART screens vs Programs report");
            dataset = new DefaultPieDataset();
            String usedCategory = Messages.getString4ChartLegend(ReportBuilder.class, (String)"using.category.lbl");
            String unusedCategory = Messages.getString4ChartLegend(ReportBuilder.class, (String)"notUsing.category.lbl");
            String not_using_category_lbl = Messages.getString(ReportBuilder.class, "notUsing.lbl");
            String using_category_lbl = Messages.getString(ReportBuilder.class, "using.lbl");
            dataset.setValue((Comparable)((Object)not_using_category_lbl), (Number)new Double(((Collection)this.getReportModel().getProperty("inputs")).size()));
            dataset.setValue((Comparable)((Object)using_category_lbl), (Number)new Double(0.0));
            HashMap<String, String> formatsMap = new HashMap<String, String>();
            formatsMap.put(not_using_category_lbl, unusedCategory);
            formatsMap.put(using_category_lbl, usedCategory);
            String titleStr = Messages.getString(ReportBuilder.class, "pie.title");
            this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap, titleStr, 880, 540, null));
        } else {
            L.debug("SMART screens vs Programs results:");
            int i = 0;
            while (i < results.length) {
                int currentCount;
                int temp;
                Integer countValue;
                HashMap<String, Integer> fileMap;
                String screenName = results[i][0];
                String prgName = results[i][1];
                String stmtType = results[i][2];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][3]));
                L.debug("screen: {}", (Object)screenName);
                L.debug("program: {}", (Object)prgName);
                L.debug("stmt type: {}", (Object)stmtType);
                L.debug("count: {}", (Object)stmtCount);
                L.debug("\n");
                Obj4Report obj = new Obj4Report();
                obj.setScreenName(screenName);
                obj.setProgramName(prgName);
                obj.setStmtType(stmtType);
                obj.setCount(stmtCount);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{screenName, prgName, stmtType, stmtCount.toString()});
                }
                if ((fileMap = (HashMap<String, Integer>)this.allFilesMap.get(screenName)) == null) {
                    fileMap = new HashMap<String, Integer>();
                    this.allFilesMap.put(screenName, fileMap);
                }
                countValue = (countValue = (Integer)fileMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                fileMap.put(stmtType, countValue);
                this.resultList.add(obj);
                if (!this.accesCountMap.containsKey(screenName)) {
                    this.accesCountMap.put(screenName, stmtCount);
                } else {
                    temp = (Integer)this.accesCountMap.get(screenName);
                    currentCount = stmtCount;
                    this.accesCountMap.put(screenName, new Integer(temp + currentCount));
                }
                if (!this.stmtCountMap.containsKey(stmtType)) {
                    this.stmtCountMap.put(stmtType, stmtCount);
                } else {
                    temp = (Integer)this.stmtCountMap.get(stmtType);
                    currentCount = stmtCount;
                    this.stmtCountMap.put(stmtType, new Integer(temp + currentCount));
                }
                ++i;
            }
        }
        if (this.stmtCountMap.size() > 0) {
            dataset = new DefaultCategoryDataset();
            for (String stmtType : this.stmtCountMap.keySet()) {
                dataset.addValue((Number)((Integer)this.stmtCountMap.get(stmtType)), (Comparable)((Object)stmtType), (Comparable)((Object)stmtType));
            }
            String title = Messages.getString(ReportBuilder.class, "pie1.title");
            String xAxis = Messages.getString(ReportBuilder.class, "firstbar.category.axis");
            String yAxis = Messages.getString(ReportBuilder.class, "firstbar.value.axis");
            this.parameters.put("usagePie", this.createFirstStackedBar((DefaultCategoryDataset)dataset, title, xAxis, yAxis, 1000, 760));
        }
        if (this.accesCountMap.size() > 0) {
            String titleStr = Messages.getString(ReportBuilder.class, "pie2.title");
            DefaultCategoryDataset dataset2 = this.buildDataSet(this.accesCountMap);
            String subtitle = null;
            if (this.accesCountMap.keySet().size() >= 20) {
                Object[] msgParams = new String[]{String.valueOf(20)};
                titleStr = titleStr.concat(" ").concat(Messages.getString(ReportBuilder.class, "bar.title", msgParams));
                if (this.countsSame != 0) {
                    msgParams = new String[]{String.valueOf(this.countsSame)};
                    titleStr = titleStr.concat("*");
                    subtitle = Messages.getString(ReportBuilder.class, "bar.subtitle", msgParams);
                }
            }
            String xAxisStr = Messages.getString(ReportBuilder.class, "bar.category.axis");
            String yAxisStr = Messages.getString(ReportBuilder.class, "bar.value.axis");
            this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(dataset2, titleStr, xAxisStr, yAxisStr, 880, 600, null, subtitle));
        }
        monitor.setWorkRemaining(0);
        return results;
    }

    @Override
    protected String getSubreportTemplate1() {
        return "reports/usedFilesInitialBars.jasper";
    }

    protected String prepareAppendixResrsList(Set prgList) {
        String ret = "";
        ret = ret.concat(prgList.toString());
        Object selectedApps = this.report.getProperty("filtered by app");
        boolean projectIsUCMDB = (Boolean)this.inputs.get("project_isUCMDB");
        if (selectedApps != null && ((Boolean)selectedApps).booleanValue() && projectIsUCMDB) {
            Set apps = null;
            Iterator iterator = prgList.iterator();
            while (iterator.hasNext() && apps == null) {
                ProgramInputNoGUI prg = (ProgramInputNoGUI)iterator.next();
                if (prg.getApplications() == null || prg.getApplications().isEmpty()) continue;
                apps = prg.getApplications();
            }
            if (apps != null && !apps.isEmpty()) {
                ret = ret.concat("\n");
                ret = ret.concat(Messages.getString(ReportBuilder.class, "appendix.applications.part")).concat(apps.toString());
                this.setApplicationName(apps);
            }
        }
        return ret;
    }

    @Override
    public void cleanMemory() {
        if (this.accesCountMap != null) {
            this.accesCountMap.clear();
            this.accesCountMap = null;
        }
        if (this.allFilesMap != null) {
            this.allFilesMap.clear();
            this.allFilesMap = null;
        }
        if (this.stmtCountMap != null) {
            this.stmtCountMap.clear();
            this.stmtCountMap = null;
        }
        super.cleanMemory();
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.smartScreen"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

