/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.setsVsDDCLElements;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.idmsSetsVsPrograms.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.idmsSetsVsPrograms.ReportBuilder;
import com.ez.report.application.ezreport.reports.wu.setsVsDDCLElements.Datasource;
import com.ez.report.application.ezreport.reports.wu.setsVsDDCLElements.ReportModel;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builder
extends ReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Builder.class);
    private static final String EZREP_SETS_VS_DDCLELEMENTS = "EZReports_SetsUsedByDDCL";
    private static final String EZREP_SETS_VS_DDCLELEMENTS_SELECTIVE = "EZReports_SetsUsedByDDCL_Selective";

    public Builder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    protected void instantiateModel() {
        this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
    }

    @Override
    protected AbstractReportDataSource buildReportDS() {
        boolean hideImages = (Boolean)this.getReportModel().getProperty("hide images");
        Datasource dataSource = new Datasource(this.resultList, this.allPrgMap, hideImages);
        return dataSource;
    }

    @Override
    protected String getProcedure() {
        return EZREP_SETS_VS_DDCLELEMENTS;
    }

    @Override
    protected String getSelectiveProcedure() {
        return EZREP_SETS_VS_DDCLELEMENTS_SELECTIVE;
    }

    @Override
    protected void buildData4Report(String[][] results, CSVWriter csvWriter) {
        if (results == null) {
            L.warn("no results for SetsVsDDCLEElements report");
        } else {
            L.debug("Sets vs DCLEElements results:");
            int i = 0;
            while (i < results.length) {
                int currentCount;
                int temp;
                Integer countValue;
                String setName = results[i][0];
                String elemName = results[i][1];
                String property = results[i][2];
                Integer propCount = new Integer(Integer.parseInt(results[i][3]));
                L.debug("set: {}", (Object)setName);
                L.debug("element: {}", (Object)elemName);
                L.debug("property: {}", (Object)property);
                L.debug("count: {}", (Object)propCount);
                L.debug("\n");
                Integer elemTypeId = new Integer(Integer.parseInt(results[i][4]));
                String textType = Utils.getExternalizedType4DDCLComponent((Integer)elemTypeId);
                elemName = String.valueOf(elemName) + " (" + textType.toLowerCase() + ")";
                Obj4Report obj = new Obj4Report();
                obj.setSetName(setName);
                obj.setProgramName(elemName);
                obj.setStmtType(property);
                obj.setCount(propCount);
                HashMap<String, Integer> fileMap = (HashMap<String, Integer>)this.allPrgMap.get(setName);
                if (fileMap == null) {
                    fileMap = new HashMap<String, Integer>();
                    this.allPrgMap.put(setName, fileMap);
                }
                countValue = (countValue = (Integer)fileMap.get(property)) == null ? propCount : new Integer(countValue + propCount);
                fileMap.put(property, countValue);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{setName, elemName, property, propCount.toString()});
                }
                this.resultList.add(obj);
                if (!this.accesCountMap.containsKey(setName)) {
                    this.accesCountMap.put(setName, propCount);
                } else {
                    temp = (Integer)this.accesCountMap.get(setName);
                    currentCount = propCount;
                    this.accesCountMap.put(setName, new Integer(temp + currentCount));
                }
                if (!this.stmtCountMap.containsKey(property)) {
                    this.stmtCountMap.put(property, propCount);
                } else {
                    temp = (Integer)this.stmtCountMap.get(property);
                    currentCount = propCount;
                    this.stmtCountMap.put(property, new Integer(temp + currentCount));
                }
                ++i;
            }
        }
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        super.putExternalizedParameters(params);
        String externalized = Messages.getString(Builder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(Builder.class, "second.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(Builder.class, "first.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(Builder.class, "third.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(Builder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(Builder.class, "sum2");
        params.put("sum2", null);
        externalized = Messages.getString(Builder.class, "sum3");
        params.put("sum3", null);
        externalized = Messages.getString(Builder.class, "sum4");
        params.put("sum4", null);
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.set"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.ddcl"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.property"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

