/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.sclvsfiles;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.computation.ProgramsVsCollector;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.programsVsFiles.ProgramsVSFilesReportBuilder;
import com.ez.report.application.ezreport.reports.wu.sclvsfiles.ReportModel;
import com.ez.report.application.ezreport.reports.wu.sclvsfiles.SclVsFilesCollector;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.utils.Utils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends ProgramsVSFilesReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String COUNT_AVAILABLE_PROGRAMS_QUERY = "SELECT Count(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID in (19) ";

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    protected String getProcedure() {
        return null;
    }

    @Override
    protected String getSelectiveProcedure() {
        return null;
    }

    @Override
    protected ProgramsVsCollector instantiateCollector() {
        SclVsFilesCollector collector = new SclVsFilesCollector(!this.report.useAllResources(), false);
        return collector;
    }

    @Override
    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        return Utils.countAvailablePrograms((String)COUNT_AVAILABLE_PROGRAMS_QUERY, (EZSourceConnection)conn);
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        super.putExternalizedParameters(params);
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.scl"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.file"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

