/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.recordsVsDDCLElements;

import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.idmsRecordsVsPrograms.IDMSRecordsVsProgramsAnalysis;
import com.ez.report.application.ezreport.reports.wu.recordsVsDDCLElements.RecordsVsDDCLElementsJob;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.model.DDCLElementInput;
import com.ez.report.application.ui.collectors.DDCLElementCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RecordsVsDDCLElementsAnalysis
extends IDMSRecordsVsProgramsAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public RecordsVsDDCLElementsAnalysis() {
        this(null);
    }

    public RecordsVsDDCLElementsAnalysis(AbstractReport model) {
        super(model);
        this.considerUcmdb = false;
        this.wizObjType = Messages.getString(RecordsVsDDCLElementsAnalysis.class, "wizard.objectType");
        this.filterWizardInputs = false;
    }

    @Override
    protected ResourcesCollector getCollector4Wizard() {
        String filesQuery = "select distinct DDCLElement.Id, ReferenceName, DDCLElement.DdsTypeId\r\nfrom DDCLValue INNER JOIN DDCLElement on DDCLElement.Name = ReferenceName where DDCLValue.referenceddstypeid=3 AND DDCLValue.ValueTypeId in (2,4)";
        DDCLElementCollector pc = new DDCLElementCollector();
        pc.setResourcesQuery(filesQuery);
        return pc;
    }

    @Override
    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_RECORDS_VS_DDCL_ELEMENTS_ANALYSIS;
    }

    @Override
    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(id, RecordsVsDDCLElementsJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    @Override
    protected void processSpecificInput(EZObjectType inpObj, List<EZEntityID> list, List<BaseMainframeResourceInput> sel, Set<String> inputNames) {
        EZObjectType objType = inpObj;
        EZEntityID entity = objType.getEntID();
        list.add(entity);
        EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
        if (prjSg != null) {
            EZSourceDDCLElementIDSg ddclSg;
            EZEntityID entityId;
            if (!prjSg.getProjectName().equals(this.projectName)) {
                this.setPrjName(prjSg.getProjectName());
                this.addContextValue("input_project_names", prjSg.getProjectName());
                ProjectInfo pInfo = prjSg.getProjectInfo();
                com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
            }
            if ((entityId = objType.getEntID()) != null && (ddclSg = (EZSourceDDCLElementIDSg)entityId.getSegment(EZSourceDDCLElementIDSg.class)) != null) {
                String name = ddclSg.getName();
                Integer type = ddclSg.getType();
                Integer dbID = ddclSg.getId();
                sel.add((BaseMainframeResourceInput)new DDCLElementInput(name, type, dbID));
                inputNames.add(name);
            }
        }
    }

    @Override
    protected void completeSelectedPrograms(PrepareReportWizard wizard) throws Exception {
        List sel = wizard.getList("selected resources");
        if (sel != null) {
            HashSet<String> inputNames = new HashSet<String>();
            for (DDCLElementInput input : sel) {
                if (!(input instanceof DDCLElementInput)) continue;
                inputNames.add(input.getName());
            }
            this.addContextValue("inputs name string", inputNames);
        }
    }
}

