/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.recordsVsDDCLElements;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.idmsRecordsVsPrograms.Object4Report;
import com.ez.report.application.ezreport.reports.wu.idmsRecordsVsPrograms.ReportBuilder;
import com.ez.report.application.ezreport.reports.wu.recordsVsDDCLElements.Datasource;
import com.ez.report.application.ezreport.reports.wu.recordsVsDDCLElements.ReportModel;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builder
extends ReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Builder.class);
    private static final String EZREP_RECORDS_VS_DDCLELEMENTS = "EZReports_RecordsUsedByDDCL";
    private static final String EZREP_RECORDS_VS_DDCLELEMENTS_SELECTIVE = "EZReports_RecordsUsedByDDCL_Selective";

    public Builder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    protected void instantiateModel() {
        this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
    }

    @Override
    protected AbstractReportDataSource buildReportDS() {
        boolean hideImages = (Boolean)this.getReportModel().getProperty("hide images");
        Datasource dataSource = new Datasource(this.resultList, this.allPrgMap, hideImages);
        return dataSource;
    }

    @Override
    protected String getProcedure() {
        return EZREP_RECORDS_VS_DDCLELEMENTS;
    }

    @Override
    protected String getSelectiveProcedure() {
        return EZREP_RECORDS_VS_DDCLELEMENTS_SELECTIVE;
    }

    @Override
    protected void buildData4Report(String[][] results, CSVWriter csvWriter) {
        if (results == null) {
            L.warn("no results for {} report", this.parameters.get("report.title"));
            DefaultPieDataset dataset = new DefaultPieDataset();
            String usedCategory = this.getUsedCategoryLabel4SummaryPie();
            String unusedCategory = this.getUnusedCategoryLabel4SummaryPie();
            String not_using_category_lbl = Messages.getString(Builder.class, "notUsing.lbl");
            String using_category_lbl = Messages.getString(Builder.class, "using.lbl");
            dataset.setValue((Comparable)((Object)not_using_category_lbl), (Number)new Double(((Collection)this.getReportModel().getProperty("inputs")).size()));
            dataset.setValue((Comparable)((Object)using_category_lbl), (Number)new Double(0.0));
            HashMap<String, String> formatsMap = new HashMap<String, String>();
            formatsMap.put(not_using_category_lbl, unusedCategory);
            formatsMap.put(using_category_lbl, usedCategory);
            this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap, this.getPieTitle(), 880, 540, null));
        } else {
            L.debug("Records vs DDCLElements results:");
            int i = 0;
            while (i < results.length) {
                int currentCount;
                int temp;
                Integer countValue;
                String recName = results[i][0];
                String elemName = results[i][1];
                String property = results[i][2];
                Integer propCount = new Integer(Integer.parseInt(results[i][3]));
                L.debug("record: {}", (Object)recName);
                L.debug("element: {}", (Object)elemName);
                L.debug("property: {}", (Object)property);
                L.debug("count: {}", (Object)propCount);
                L.debug("\n");
                Integer elemTypeId = new Integer(Integer.parseInt(results[i][4]));
                String textType = Utils.getExternalizedType4DDCLComponent((Integer)elemTypeId);
                elemName = String.valueOf(elemName) + " (" + textType.toLowerCase() + ")";
                Object4Report obj = new Object4Report();
                obj.setRecordName(recName);
                obj.setProgramName(elemName);
                obj.setStmtType(property);
                obj.setCount(propCount);
                HashMap<String, Integer> fileMap = (HashMap<String, Integer>)this.allPrgMap.get(recName);
                if (fileMap == null) {
                    fileMap = new HashMap<String, Integer>();
                    this.allPrgMap.put(recName, fileMap);
                }
                countValue = (countValue = (Integer)fileMap.get(property)) == null ? propCount : new Integer(countValue + propCount);
                fileMap.put(property, countValue);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{recName, elemName, property, propCount.toString()});
                }
                this.resultList.add(obj);
                if (!this.accesCountMap.containsKey(recName)) {
                    this.accesCountMap.put(recName, propCount);
                } else {
                    temp = (Integer)this.accesCountMap.get(recName);
                    currentCount = propCount;
                    this.accesCountMap.put(recName, new Integer(temp + currentCount));
                }
                if (!this.stmtCountMap.containsKey(property)) {
                    this.stmtCountMap.put(property, propCount);
                } else {
                    temp = (Integer)this.stmtCountMap.get(property);
                    currentCount = propCount;
                    this.stmtCountMap.put(property, new Integer(temp + currentCount));
                }
                ++i;
            }
        }
    }

    protected String getUnusedCategoryLabel4SummaryPie() {
        return Messages.getString4ChartLegend(Builder.class, (String)"notUsing.category.lbl");
    }

    protected String getUsedCategoryLabel4SummaryPie() {
        return Messages.getString4ChartLegend(Builder.class, (String)"using.category.lbl");
    }

    protected String getPieTitle() {
        return Messages.getString(Builder.class, "pie.title");
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        super.putExternalizedParameters(params);
        String externalized = Messages.getString(Builder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(Builder.class, "second.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(Builder.class, "first.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(Builder.class, "third.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(Builder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(Builder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(Builder.class, "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(Builder.class, "sum4");
        params.put("sum4", externalized);
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.record"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.ddcl"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.property"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

