/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.recordGroupsVsDDCLElements;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.recordGroupsVsDDCLElements.ReportModel;
import com.ez.report.application.ezreport.reports.wu.recordsVsDDCLElements.Datasource;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.Map;

public class Builder
extends com.ez.report.application.ezreport.reports.wu.recordsVsDDCLElements.Builder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String EZREP_RECORDGROUPS_VS_DDCLELEMENTS = "EZReports_RecordGroupsUsedByDDCL";
    private static final String EZREP_RECORDGROUPS_VS_DDCLELEMENTS_SELECTIVE = "EZReports_RecordGroupsUsedByDDCL_Selective";

    public Builder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    protected void instantiateModel() {
        this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
    }

    @Override
    protected AbstractReportDataSource buildReportDS() {
        boolean hideImages = (Boolean)this.getReportModel().getProperty("hide images");
        Datasource dataSource = new Datasource(this.resultList, this.allPrgMap, hideImages);
        return dataSource;
    }

    @Override
    protected String getProcedure() {
        return EZREP_RECORDGROUPS_VS_DDCLELEMENTS;
    }

    @Override
    protected String getSelectiveProcedure() {
        return EZREP_RECORDGROUPS_VS_DDCLELEMENTS_SELECTIVE;
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        super.putExternalizedParameters(params);
        String externalized = Messages.getString(Builder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(Builder.class, "sum2");
        params.put("sum2", externalized);
    }

    @Override
    protected String getUnusedCategoryLabel4SummaryPie() {
        return Messages.getString4ChartLegend(Builder.class, (String)"notUsing.category.lbl");
    }

    @Override
    protected String getUsedCategoryLabel4SummaryPie() {
        return Messages.getString4ChartLegend(Builder.class, (String)"using.category.lbl");
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.recordGroup"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.ddcl"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.property"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

