/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.programsvsimssegments;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentsReportAbstractBuilder;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentsReportAbstractDS;
import com.ez.report.application.ezreport.reports.wu.programsvsimssegments.Obj4Report;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgramsVsIMSSegmentReportDS
extends IMSSegmentsReportAbstractDS {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<String, String> prgMapByID;

    public ProgramsVsIMSSegmentReportDS(IProgressMonitor pmonitor, Collection inputs, IMSSegmentsReportAbstractBuilder reportBuilder, CSVWriter csvWriter) {
        super(pmonitor, inputs, reportBuilder, csvWriter);
        this.init();
    }

    private void init() {
        Set prgList = (Set)this.builder.getReportModel().getProperty("inputs");
        if (prgList != null) {
            this.prgMapByID = new HashMap<String, String>();
            for (ProgramInputNoGUI prg : prgList) {
                this.prgMapByID.put(prg.getProgramID().toString(), prg.getListableName());
            }
        }
    }

    @Override
    protected String getStackedBarTitle() {
        return Messages.getString(ProgramsVsIMSSegmentReportDS.class, "stackedBar.title");
    }

    @Override
    protected String getStackedBarAxisLabel() {
        return Messages.getString(ProgramsVsIMSSegmentReportDS.class, "stackedBar.domainAxis.lbl");
    }

    @Override
    protected String getStackedBarRangeLabel() {
        return Messages.getString(ProgramsVsIMSSegmentReportDS.class, "stackedBar.rangeAxis.lbl");
    }

    @Override
    protected com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report buildObj4Report(String[] row) {
        Obj4Report obj = new Obj4Report();
        String progName = this.prgMapByID.containsKey(row[1]) ? this.prgMapByID.get(row[1]) : row[0];
        obj.level1 = Messages.getString(ProgramsVsIMSSegmentReportDS.class, "details.program.groupname", new String[]{progName});
        obj.level1Type = null;
        obj.level2 = this.getListableSegmentName(row[3], row[5]);
        if (row[8] != null) {
            obj.level2Extra = Messages.getString(ProgramsVsIMSSegmentReportDS.class, "details.sourcesegment.info", new String[]{this.getListableSegmentName(row[7], row[9])});
        }
        obj.level2Type = null;
        obj.level3 = row[10];
        obj.setStmtType("");
        Integer stmtCount = new Integer(row[11]);
        obj.setCount(stmtCount);
        if (this.csvWriter != null) {
            this.csvWriter.write(new String[]{row[0], String.valueOf(row[3]) + ":" + row[5], row[8] != null ? String.valueOf(row[7]) + ":" + row[9] : "", row[10], obj.getCount().toString()});
        }
        return obj;
    }

    @Override
    protected String getLevel1Discriminator(String[] row) {
        return row[1];
    }

    @Override
    protected String getProcedureName() {
        return "EZViewer_IMSDBProgVsSegUsage";
    }

    @Override
    protected String getField4Charts(com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report obj4Report) {
        return obj4Report.level3;
    }

    @Override
    protected String getLevel2Discriminator(String[] row) {
        return row[4];
    }
}

