/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.programsVsVariables;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.programsVsVariables.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.programsVsVariables.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.programsVsVariables.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String COUNT_AVAILABLE_PROGRAMS_QUERY = "SELECT COUNT(ProgramID) FROM Programs where OccurID <> 0 and ProgramTypeID in (1, 2, 3, 8, 10, 11, 19) ";
    String tmpTblPlaceHolder = "###AncestorFunctionTempTbl###";
    String tmpTblName = "programWithAncestor";
    Map allPrgMap = null;
    private Map usedProgram = null;
    private ServerType dbEngine;
    final String queryGroupPart = "GROUP BY pgm.AncestorName, pgm.ProgramName, pgm.ProgramID, pgm.AncestorID, Variables.VarName, src2.Description ";
    final String queryOrderPart = "ORDER BY k, pgmID, varName";

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.usedProgram = new HashMap();
        this.allPrgMap = new HashMap();
        this.resultList = new ArrayList();
        this.inputWasResource = false;
    }

    String getQueryPart1() {
        return "SELECT pgm.ProgramName AS ProgramName, \n Variables.VarName as varName, src2.Description, COUNT(src2.OccurID) AS stmtCount, pgm.AncestorID, \n" + this.computeKColumn(true) + " as k, \n" + " pgm.ProgramID as pgmID \n" + " FROM Variables INNER JOIN Occurrences AS Occurrences_Var ON Variables.OccurID = Occurrences_Var.OccurID \n" + " INNER JOIN " + this.tmpTblPlaceHolder + " pgm ON Variables.ProgIDReference = pgm.ProgramID  \n" + " INNER JOIN\t(SELECT src1.ResourceID, Statements.Description, OccurrencesStmt.OccurID \n" + " FROM ( SELECT sr.ResourceID, sr.OccurID \n" + "\t\t\t\t\t\tFROM StatementReference sr\t\n" + "\t\t\t\t\t\tWHERE  sr.ResourceType = 4 \n" + " \tUNION\t\t\t\t\n" + " \t\tSELECT pcp.ResourceId, sr1.OccurID \n " + "\t\t\t\t\tFROM  StatementReference sr1 INNER JOIN \n" + "\t\t\t\t\t\tProcedureCallParameters pcp ON pcp.IDKey = sr1.ResourceID AND pcp.ResourceType = 4 \n" + "\t\t\t\t\tWHERE sr1.ResourceType = 208 \n" + "\t\t)src1 \n" + "\tINNER JOIN OccurrencesStmt ON src1.OccurID = OccurrencesStmt.OccurID \n" + "\tINNER JOIN Statements ON OccurrencesStmt.StatementType = Statements.StatementType \n" + " ) src2 ON src2.ResourceID = Variables.VarID \n" + "\tWHERE pgm.ProgramTypeID IN (1, 2, 3, 8, 10, 11, 15, 16) \n";
    }

    String getQueryPart2() {
        return "UNION SELECT pgm.ProgramName AS ProgramName, Variables.VarName as varName, \n src2.Description, COUNT(OccurrencesStmt.OccurID) AS stmtCount, " + this.getNullIntegerValue() + " AS AncestorID, " + this.computeKColumn(false) + " as k, \n" + " pgm.ProgramID as pgmID \n" + " FROM  ((( StatementReference INNER JOIN \n" + " \tOccurrencesStmt ON StatementReference.OccurID = OccurrencesStmt.OccurID) INNER JOIN \n" + "\t\tStatements as src2 ON OccurrencesStmt.StatementType = src2.StatementType) INNER JOIN \n" + "\t\t" + this.tmpTblPlaceHolder + " pgm ON OccurrencesStmt.ProgID = pgm.ProgramID) INNER JOIN \n" + "\t\tVariables ON StatementReference.ResourceID = Variables.VarID \n" + "\tWHERE (StatementReference.ResourceType = 4) \n" + " AND pgm.ProgramTypeID IN (19)";
    }

    String getQuerySelectivePart() {
        return " AND (pgm.ProgramID in (Select * from " + com.ez.mainframe.data.utils.Utils.getTempTableName((ServerType)this.dbEngine, (String)"numeric_param_temp") + "))";
    }

    private String computeKColumn(boolean considerAncestor) {
        String s = "";
        String ancestor = considerAncestor ? "pgm.AncestorName" : "''";
        Assert.isNotNull((Object)this.dbEngine);
        switch (this.dbEngine) {
            case Db2: 
            case Db2Z: {
                s = "(" + ancestor + " || pgm.ProgramName)";
                break;
            }
            case SqlServer: {
                s = "(" + ancestor + " + pgm.ProgramName) ";
                break;
            }
        }
        return s;
    }

    private String getNullIntegerValue() {
        String s = "";
        Assert.isNotNull((Object)this.dbEngine);
        switch (this.dbEngine) {
            case Db2: 
            case Db2Z: {
                s = "CAST(NULL AS INTEGER)";
                break;
            }
            case SqlServer: {
                s = "NULL";
                break;
            }
        }
        return s;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
        }
        Collections.sort(this.resultList);
        boolean hideImages = (Boolean)this.getReportModel().getProperty("hide images");
        ReportDataSource dataSource = new ReportDataSource(this.resultList, this.allPrgMap, hideImages);
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            ((ReportModel)this.report).setExpressions((List)this.inputs.get("pattern list"));
            Boolean value = (Boolean)this.inputs.get("hide images");
            this.report.addProperty("hide images", (Object)(value != null ? value : true));
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void putExternalizedParameters(Map params) {
        String exp2;
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        List<String> inps = ((ReportModel)this.report).getExpressions();
        StringBuilder inp = new StringBuilder();
        boolean first = true;
        for (String exp2 : inps) {
            if (!first) {
                inp.append("; ");
            }
            first = false;
            if (!Utils.isSpecialExpression((String)exp2)) {
                exp2 = Utils.unescapeText((String)exp2);
            }
            inp.append(exp2);
        }
        exp2 = inp.toString();
        externalized = Messages.getString(ReportBuilder.class, "pattern.label");
        params.put("patternsLabel", externalized);
        params.put("patterns", exp2.toString());
        if (exp2.length() > 20) {
            exp2 = String.valueOf(exp2.substring(0, 15)) + "[...]";
        }
        externalized = Messages.getString(ReportBuilder.class, "title.inputExpression", new String[]{exp2});
        params.put("title.varName", externalized);
        externalized = Messages.getString(ReportBuilder.class, "stmtType.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "summary");
        params.put("summary", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum4");
        params.put("sum4", externalized);
    }

    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    public InputStream getReportStream(IProgressMonitor pmonitor) {
        InputStream stream = super.getReportStream(pmonitor);
        return stream;
    }

    private void clearForJasperReport() {
        this.usedProgram.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    protected void finallyExecSQLHook(EZSourceConnection conn, IProgressMonitor pmonitor) {
        com.ez.mainframe.data.utils.Utils.cleanTable((EZSourceConnection)conn, (String)this.tmpTblName);
        com.ez.mainframe.data.utils.Utils.dropTempTable((EZSourceConnection)conn, (String)this.tmpTblName);
        L.debug("after cleaning temporary table");
        this.tmpTblName = null;
    }

    protected void beforeExecSQLHook(EZSourceConnection conn, IProgressMonitor pmonitor) {
        String fullTblName = com.ez.mainframe.data.utils.Utils.getTempTableName((EZSourceConnection)conn, (String)this.tmpTblName);
        this.dbEngine = this.pInfo.getDbEngine();
        switch (this.dbEngine) {
            case SqlServer: {
                String s1 = " SELECT * INTO " + fullTblName + " FROM fGetProgram_Ancestor_Aliases (NULL) order by ProgramID ";
                conn.executeUpdate(s1);
                break;
            }
            case Db2Z: {
                String createStr = " DECLARE GLOBAL TEMPORARY TABLE " + fullTblName + "( \n" + "   ProgramID     INTEGER,\n" + "\t  ProgramName   VARCHAR(256),\n" + "\t  ProgramTypeID INTEGER,\n" + "   OccurID       INTEGER,\n" + "   AncestorID    INTEGER,\n" + "   AncestorName  VARCHAR(256)\n" + ") " + " ON COMMIT PRESERVE ROWS NOT LOGGED ";
                conn.executeUpdate(createStr);
                String insertStr = String.format("INSERT INTO %s  (ProgramID, ProgramName, ProgramTypeID, OccurID, AncestorID, AncestorName)\nSELECT t.ProgramID, t.ProgramName, t.ProgramTypeID, t.OccurID, t.AncestorID, t.AncestorName\nFROM TABLE( fGetProgram_Ancestor_Aliases( CAST(NULL AS INTEGER) ) )t;", fullTblName);
                conn.executeUpdate(insertStr);
                break;
            }
            case Db2: {
                String createStr = " DECLARE GLOBAL TEMPORARY TABLE " + fullTblName + "( \n" + "   ProgramID     INTEGER,\n" + "\t  ProgramName   VARCHAR(256),\n" + "\t  ProgramTypeID INTEGER,\n" + "   OccurID       INTEGER,\n" + "   AncestorID    INTEGER,\n" + "   AncestorName  VARCHAR(256)\n" + ") " + " WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ";
                conn.executeUpdate(createStr);
                String insertStr = String.format("INSERT INTO %s  (ProgramID, ProgramName, ProgramTypeID, OccurID, AncestorID, AncestorName)\nSELECT t.ProgramID, t.ProgramName, t.ProgramTypeID, t.OccurID, t.AncestorID, t.AncestorName\nFROM TABLE( fGetProgram_Ancestor_Aliases( CAST(NULL AS INTEGER) ) )t", fullTblName);
                conn.executeUpdate(insertStr);
            }
        }
    }

    private String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "compute.taskName"));
        SingleQueryResult queryResult = this.querySQLForData(EZSourceDataType.Integer, this.filterSelectedIDs(), (IProgressMonitor)monitor);
        String[][] results = queryResult.data;
        int allPrgNo = this.getSelected().size();
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        HashMap<Integer, String> prgsByID = new HashMap<Integer, String>();
        if (prgList != null) {
            this.buildInputs4Appendix(prgList);
            this.parameters.put("title.appFieldValues", this.applicationsName);
            for (ProgramInputNoGUI prg : prgList) {
                prgsByID.put(prg.getProgramID(), prg.getListableName());
            }
        }
        if (results == null) {
            L.warn("no results for UsedVariables report");
        } else {
            L.debug("UsedVariables results:");
            String currentKey = null;
            int i = 0;
            while (i < results.length) {
                Integer countValue;
                HashMap<String, Integer> prgMap;
                HashSet<String> files;
                String listableName;
                String prgName = results[i][0];
                String variableName = results[i][1];
                String stmtType = results[i][2];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][3]));
                if (results[i][4] != null) {
                    new Integer(Integer.parseInt(results[i][4]));
                }
                Integer prgID = new Integer(Integer.parseInt(results[i][6]));
                String key = listableName = this.detectListableName(prgList, prgID, prgName);
                if (currentKey != null && !key.equalsIgnoreCase(currentKey)) {
                    files = (HashSet<String>)this.usedProgram.get(currentKey);
                    int count = 0;
                    if (files == null) {
                        L.warn("program without literals?! {}", (Object)currentKey);
                    } else {
                        count = files.size();
                    }
                    this.usedProgram.put(currentKey, count);
                    currentKey = key;
                } else {
                    currentKey = i == 0 ? key : currentKey;
                }
                files = (Set)this.usedProgram.get(key);
                if (files == null) {
                    files = new HashSet<String>();
                    this.usedProgram.put(key, files);
                }
                files.add(variableName);
                L.debug("program: {}", (Object)listableName);
                L.debug("variable: {}", (Object)variableName);
                L.debug("stmt type: {}", (Object)stmtType);
                L.debug("count: {}", (Object)stmtCount);
                L.debug("\n");
                Obj4Report obj = new Obj4Report();
                obj.setProgramName(listableName);
                obj.setFileName(variableName);
                obj.setStmtType(stmtType);
                obj.setCount(stmtCount);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{listableName, variableName, stmtType, stmtCount.toString()});
                }
                if ((prgMap = (HashMap<String, Integer>)this.allPrgMap.get(listableName)) == null) {
                    prgMap = new HashMap<String, Integer>();
                    this.allPrgMap.put(listableName, prgMap);
                }
                countValue = (countValue = (Integer)prgMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                prgMap.put(stmtType, countValue);
                this.resultList.add(obj);
                ++i;
            }
            if (currentKey != null) {
                Set files = (Set)this.usedProgram.get(currentKey);
                int count = 0;
                if (files == null) {
                    L.warn("last program without literals?! {}", currentKey);
                } else {
                    count = files.size();
                }
                this.usedProgram.put(currentKey, count);
            }
        }
        if (allPrgNo != 0) {
            DefaultPieDataset dataset = new DefaultPieDataset();
            String usedCategory = Messages.getString4ChartLegend(ReportBuilder.class, (String)"used.category.lbl");
            String unusedCategory = Messages.getString4ChartLegend(ReportBuilder.class, (String)"unused.category.lbl");
            String notUsingLbl = Messages.getString(ReportBuilder.class, "notUsing.lbl");
            String usingLbl = Messages.getString(ReportBuilder.class, "using.lbl");
            dataset.setValue((Comparable)((Object)notUsingLbl), (Number)new Double(allPrgNo - this.usedProgram.size()));
            dataset.setValue((Comparable)((Object)usingLbl), (Number)new Double(this.usedProgram.size()));
            HashMap<String, String> formatsMap = new HashMap<String, String>();
            formatsMap.put(notUsingLbl, unusedCategory);
            formatsMap.put(usingLbl, usedCategory);
            String titleStr = Messages.getString(ReportBuilder.class, "pie1.title");
            this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap, titleStr, 880, 540, null));
            if (this.usedProgram.size() > 0) {
                String stackTitle = Messages.getString(ReportBuilder.class, "pie2.title");
                DefaultCategoryDataset ds = this.buildDataSet(this.usedProgram);
                String subtitle = null;
                if (this.usedProgram.keySet().size() >= 20) {
                    Object[] msgParams = new String[]{String.valueOf(20)};
                    stackTitle = stackTitle.concat(" ").concat(Messages.getString(ReportBuilder.class, "bar.title", msgParams));
                    if (this.countsSame != 0) {
                        msgParams = new String[]{String.valueOf(this.countsSame)};
                        stackTitle = stackTitle.concat("*");
                        subtitle = Messages.getString(ReportBuilder.class, "bar.subtitle", msgParams);
                    }
                }
                String xAxis = Messages.getString(ReportBuilder.class, "bar.category.axis");
                String yAxis = Messages.getString(ReportBuilder.class, "bar.value.axis");
                this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(ds, stackTitle, xAxis, yAxis, 880, 540, null, subtitle));
            }
        }
        monitor.setWorkRemaining(0);
        return results;
    }

    protected String getSQLQuery() {
        ReportModel model = (ReportModel)this.report;
        StringBuffer query = new StringBuffer();
        query.append(this.getQueryPart1());
        this.buildDynamicPart(model, query);
        query.append(this.getQueryPart2());
        this.buildDynamicPart(model, query);
        query.append("ORDER BY k, pgmID, varName");
        String q = query.toString();
        q = q.replaceAll(this.tmpTblPlaceHolder, com.ez.mainframe.data.utils.Utils.getTempTableName((ServerType)this.dbEngine, (String)this.tmpTblName));
        L.debug("query (all) used: {}", (Object)q);
        return q;
    }

    private void buildDynamicPart(ReportModel model, StringBuffer query) {
        query.append(" AND (");
        List<String> expList = model.getExpressions();
        boolean caseSensitive = false;
        if (this.dbEngine == ServerType.Db2Z || this.dbEngine == ServerType.Db2) {
            caseSensitive = true;
        }
        int i = 0;
        for (String expr : expList) {
            boolean isNot = false;
            if (i > 0) {
                query.append(" OR ");
            }
            query.append(" ( ");
            if (caseSensitive) {
                query.append("upper(Variables.VarName)");
            } else {
                query.append("Variables.VarName");
            }
            if (isNot) {
                query.append(" NOT ");
            }
            query.append(" LIKE ");
            if (caseSensitive) {
                query.append("upper(");
            }
            query.append("'");
            query.append(expr);
            query.append("'");
            if (caseSensitive) {
                query.append(") ");
            }
            query.append("  ESCAPE '\\' ");
            query.append(" ) ");
            ++i;
        }
        query.append(") ");
        query.append("GROUP BY pgm.AncestorName, pgm.ProgramName, pgm.ProgramID, pgm.AncestorID, Variables.VarName, src2.Description ");
    }

    protected String getSQLQuerySelective() {
        ReportModel model = (ReportModel)this.report;
        StringBuffer query = new StringBuffer();
        query.append(this.getQueryPart1());
        query.append(this.getQuerySelectivePart());
        this.buildDynamicPart(model, query);
        query.append(this.getQueryPart2());
        query.append(this.getQuerySelectivePart());
        this.buildDynamicPart(model, query);
        query.append("ORDER BY k, pgmID, varName");
        String q = query.toString();
        q = q.replaceAll(this.tmpTblPlaceHolder, com.ez.mainframe.data.utils.Utils.getTempTableName((ServerType)this.dbEngine, (String)this.tmpTblName));
        L.debug("query (selective) used: {}", (Object)q);
        return q;
    }

    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        return Utils.countAvailablePrograms((String)COUNT_AVAILABLE_PROGRAMS_QUERY, (EZSourceConnection)conn);
    }

    @Override
    public void cleanMemory() {
        if (this.allPrgMap != null) {
            this.allPrgMap.clear();
            this.allPrgMap = null;
        }
        if (this.usedProgram != null) {
            this.usedProgram.clear();
            this.usedProgram = null;
        }
        super.cleanMemory();
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.variable"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

