/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.programsVsStringLiterals;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.programsVsStringLiterals.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.programsVsStringLiterals.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.programsVsStringLiterals.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String COUNT_AVAILABLE_PROGRAMS_QUERY = "SELECT COUNT(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID in (1, 2, 3, 10, 11,19) ";
    Map allPrgMap = null;
    private Map usedProgram = null;
    private boolean containsNonPrintableChars = false;
    static final String INITIAL_VALUE = "initial_value";
    final String query1 = "SELECT ProgramAliases.AliasName as k, Variables.szValues as stringContent, 'initial_value' as Description, COUNT(Variables.szValues) AS stmtCount, ProgramAliases.ProgramId  \nFROM ProgramAliases \nINNER JOIN Variables \t\tON ProgramAliases.ProgramId = Variables.ProgIDReference \nINNER JOIN Programs  \tON Programs.ProgramID = ProgramAliases.ProgramId AND ProgramAliases.AliasType = 0 \n";
    final String query1WherePart = " AND Programs.ProgramTypeID IN (1, 2, 3, 10, 11,19)AND ProgramAliases.AliasType = 0 ";
    final String query1GroupPart = " GROUP BY ProgramAliases.AliasName, ProgramAliases.ProgramId, Variables.szValues ";
    final String query2 = " UNION \r\n SELECT ProgramAliases.AliasName as k \n,    StringLiterals.StringContent as stringContent, Statements.Description, \n   Count(OccurrencesStmt.OccurID) AS stmtCount, ProgramAliases.ProgramId \n   FROM (SELECT sr.ResourceID, sr.OccurID \n\t\t\t\tFROM StatementReference sr \n\t\t\t\tWHERE  sr.ResourceType = 82\t \n\t\tUNION \n\t\t\tSELECT pcp.ResourceId, sr1.OccurID \n\t\t\t\tFROM  StatementReference sr1 \n\t\t\t\tINNER JOIN ProcedureCallParameters pcp ON pcp.IDKey = sr1.ResourceID AND pcp.ResourceType = 82 \n\t\t\t\tWHERE sr1.ResourceType = 208 \n\t\t)src1 \n\t\tINNER JOIN OccurrencesStmt ON src1.OccurID = OccurrencesStmt.OccurID \n\t\tINNER JOIN Statements ON OccurrencesStmt.StatementType = Statements.StatementType \n\t\tINNER JOIN ProgramAliases ON OccurrencesStmt.ProgID = ProgramAliases.ProgramId \t\t\tAND ProgramAliases.AliasType=0 \n \t\tINNER JOIN StringLiterals ON src1.ResourceID = StringLiterals.ID \n\t\tINNER JOIN Programs ON Programs.ProgramID = ProgramAliases.ProgramId \n";
    final String query2GroupPart = " GROUP BY ProgramAliases.AliasName, ProgramAliases.ProgramId, StringLiterals.StringContent,  Statements.Description  ORDER BY k, ProgramId, stringContent \n";

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.usedProgram = new HashMap();
        this.allPrgMap = new HashMap();
        this.resultList = new ArrayList();
        this.inputWasResource = false;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
        }
        boolean hideImages = (Boolean)this.getReportModel().getProperty("hide images");
        ReportDataSource dataSource = new ReportDataSource(this.resultList, this.allPrgMap, hideImages);
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            ((ReportModel)this.report).setExpressions((List)this.inputs.get("pattern list"));
            Boolean value = (Boolean)this.inputs.get("hide images");
            this.report.addProperty("hide images", (Object)(value != null ? value : true));
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "stmtType.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "summary");
        params.put("summary", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum4");
        params.put("sum4", externalized);
        externalized = Messages.getString(ReportBuilder.class, "pattern.label");
        params.put("patternsLabel", externalized);
        ReportModel model = (ReportModel)this.report;
        List<String> expList = model.getExpressions();
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (String exp : expList) {
            if (!first) {
                out.append(",");
            }
            first = false;
            if (!Utils.isSpecialExpression((String)exp)) {
                exp = Utils.unescapeText((String)exp);
            }
            out.append(exp);
        }
        params.put("patterns", out.toString());
    }

    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    public InputStream getReportStream(IProgressMonitor pmonitor) {
        return super.getReportStream(pmonitor);
    }

    private void clearForJasperReport() {
        this.usedProgram.clear();
        this.containsNonPrintableChars = false;
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    private String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "compute.taskName"));
        SingleQueryResult queryResult = this.querySQLForData(EZSourceDataType.Integer, this.filterSelectedIDs(), (IProgressMonitor)monitor.newChild(60));
        String[][] results = queryResult.data;
        int allPrgNo = this.getSelected().size();
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        HashMap<Integer, String> prgsByID = new HashMap<Integer, String>();
        if (prgList != null) {
            this.buildInputs4Appendix(prgList);
            this.parameters.put("title.appFieldValues", this.applicationsName);
            for (ProgramInputNoGUI prg : prgList) {
                prgsByID.put(prg.getProgramID(), prg.getListableName());
            }
        }
        if (results == null) {
            L.warn("no results for UsedStringLiterals report");
        } else {
            L.debug("UsedStringLiterals results:");
            String currentKey = null;
            int i = 0;
            while (i < results.length) {
                Integer countValue;
                HashMap<String, Integer> prgMap;
                HashSet<String> files;
                String stmtType;
                String[] row = results[i];
                String prgName = row[0];
                Integer prgID = new Integer(Integer.parseInt(row[4]));
                String listableName = (String)prgsByID.get(prgID);
                String key = listableName = listableName != null ? listableName : prgName;
                String stringLiteral = row[1];
                stringLiteral = this.stripNonValidXMLCharacters(stringLiteral);
                if (!this.containsNonPrintableChars && !stringLiteral.equals(row[1])) {
                    this.containsNonPrintableChars = true;
                }
                if ((stmtType = row[2]).equals(INITIAL_VALUE)) {
                    stmtType = Messages.getString(ReportBuilder.class, "initial.value");
                }
                Integer stmtCount = new Integer(Integer.parseInt(row[3]));
                if (currentKey != null && !key.equalsIgnoreCase(currentKey)) {
                    files = (HashSet<String>)this.usedProgram.get(currentKey);
                    int count = 0;
                    if (files == null) {
                        L.warn("program without literals?! {}", (Object)currentKey);
                    } else {
                        count = files.size();
                    }
                    this.usedProgram.put(currentKey, count);
                    currentKey = key;
                } else {
                    currentKey = i == 0 ? key : currentKey;
                }
                files = (Set)this.usedProgram.get(key);
                if (files == null) {
                    files = new HashSet<String>();
                    this.usedProgram.put(key, files);
                }
                files.add(stringLiteral);
                L.debug("program: {}", (Object)listableName);
                L.debug("string literal: {}", (Object)stringLiteral);
                L.debug("stmt type: {}", (Object)stmtType);
                L.debug("count: {}", (Object)stmtCount);
                L.debug("\n");
                Obj4Report obj = new Obj4Report();
                obj.setProgramName(listableName);
                obj.setProgramNameWithApp(listableName);
                obj.setStringLiteral(stringLiteral);
                obj.setStmtType(stmtType);
                obj.setCount(stmtCount);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{obj.getProgramNameWithApp() != null ? obj.getProgramNameWithApp() : listableName, stringLiteral, stmtType, stmtCount.toString()});
                }
                if ((prgMap = (HashMap<String, Integer>)this.allPrgMap.get(listableName)) == null) {
                    prgMap = new HashMap<String, Integer>();
                    this.allPrgMap.put(listableName, prgMap);
                }
                countValue = (countValue = (Integer)prgMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                prgMap.put(stmtType, countValue);
                this.resultList.add(obj);
                ++i;
            }
            if (currentKey != null) {
                Set files = (Set)this.usedProgram.get(currentKey);
                int count = 0;
                if (files == null) {
                    L.warn("last program without literals?! {}", currentKey);
                } else {
                    count = files.size();
                }
                this.usedProgram.put(currentKey, count);
            }
        }
        if (allPrgNo != 0) {
            DefaultPieDataset dataset = new DefaultPieDataset();
            String usedCategory = Messages.getString4ChartLegend(ReportBuilder.class, (String)"used.category.lbl");
            String unusedCategory = Messages.getString4ChartLegend(ReportBuilder.class, (String)"unused.category.lbl");
            String not_using_category_lbl = Messages.getString(ReportBuilder.class, "notUsing.lbl");
            String using_category_lbl = Messages.getString(ReportBuilder.class, "using.lbl");
            dataset.setValue((Comparable)((Object)not_using_category_lbl), (Number)new Double(allPrgNo - this.usedProgram.size()));
            dataset.setValue((Comparable)((Object)using_category_lbl), (Number)new Double(this.usedProgram.size()));
            HashMap<String, String> formatsMap = new HashMap<String, String>();
            formatsMap.put(not_using_category_lbl, unusedCategory);
            formatsMap.put(using_category_lbl, usedCategory);
            String titleStr = Messages.getString(ReportBuilder.class, "pie1.title");
            this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap, titleStr, 880, 540, null));
            if (this.usedProgram.size() > 0) {
                String stackTitle = Messages.getString(ReportBuilder.class, "pie2.title");
                DefaultCategoryDataset ds = this.buildDataSet(this.usedProgram);
                String subtitle = null;
                if (this.usedProgram.keySet().size() >= 20) {
                    Object[] msgParams = new String[]{String.valueOf(20)};
                    stackTitle = stackTitle.concat(" ").concat(Messages.getString(ReportBuilder.class, "bar.title", msgParams));
                    if (this.countsSame != 0) {
                        msgParams = new String[]{String.valueOf(this.countsSame)};
                        stackTitle = stackTitle.concat("*");
                        subtitle = Messages.getString(ReportBuilder.class, "bar.subtitle", msgParams);
                    }
                }
                String xAxis = Messages.getString(ReportBuilder.class, "bar.category.axis");
                String yAxis = Messages.getString(ReportBuilder.class, "bar.value.axis");
                this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(ds, stackTitle, xAxis, yAxis, 880, 540, null, subtitle));
            }
        }
        if (this.containsNonPrintableChars) {
            this.parameters.put("nonPrintableChars.label", Messages.getString(ReportBuilder.class, "nonPrintableChars", new String[]{"."}));
        }
        monitor.setWorkRemaining(0);
        return results;
    }

    final String getQuerySelectivePart() {
        return " AND (ProgramAliases.ProgramId in (Select * from " + com.ez.mainframe.data.utils.Utils.getTempTableName((ServerType)this.pInfo.getDbEngine(), (String)"numeric_param_temp") + ")) \n ";
    }

    protected String getSQLQuery() {
        ReportModel model = (ReportModel)this.report;
        StringBuffer query = new StringBuffer();
        query.append("SELECT ProgramAliases.AliasName as k, Variables.szValues as stringContent, 'initial_value' as Description, COUNT(Variables.szValues) AS stmtCount, ProgramAliases.ProgramId  \nFROM ProgramAliases \nINNER JOIN Variables \t\tON ProgramAliases.ProgramId = Variables.ProgIDReference \nINNER JOIN Programs  \tON Programs.ProgramID = ProgramAliases.ProgramId AND ProgramAliases.AliasType = 0 \n");
        query.append(" WHERE ");
        query.append(this.buildDynamicPart(model, "Variables.szValues", false));
        query.append(" AND Programs.ProgramTypeID IN (1, 2, 3, 10, 11,19)AND ProgramAliases.AliasType = 0 ");
        query.append(" GROUP BY ProgramAliases.AliasName, ProgramAliases.ProgramId, Variables.szValues ");
        query.append(" UNION \r\n SELECT ProgramAliases.AliasName as k \n,    StringLiterals.StringContent as stringContent, Statements.Description, \n   Count(OccurrencesStmt.OccurID) AS stmtCount, ProgramAliases.ProgramId \n   FROM (SELECT sr.ResourceID, sr.OccurID \n\t\t\t\tFROM StatementReference sr \n\t\t\t\tWHERE  sr.ResourceType = 82\t \n\t\tUNION \n\t\t\tSELECT pcp.ResourceId, sr1.OccurID \n\t\t\t\tFROM  StatementReference sr1 \n\t\t\t\tINNER JOIN ProcedureCallParameters pcp ON pcp.IDKey = sr1.ResourceID AND pcp.ResourceType = 82 \n\t\t\t\tWHERE sr1.ResourceType = 208 \n\t\t)src1 \n\t\tINNER JOIN OccurrencesStmt ON src1.OccurID = OccurrencesStmt.OccurID \n\t\tINNER JOIN Statements ON OccurrencesStmt.StatementType = Statements.StatementType \n\t\tINNER JOIN ProgramAliases ON OccurrencesStmt.ProgID = ProgramAliases.ProgramId \t\t\tAND ProgramAliases.AliasType=0 \n \t\tINNER JOIN StringLiterals ON src1.ResourceID = StringLiterals.ID \n\t\tINNER JOIN Programs ON Programs.ProgramID = ProgramAliases.ProgramId \n");
        query.append(" WHERE ");
        query.append(this.buildDynamicPart(model, "StringLiterals.StringContent", false));
        query.append(" AND Programs.ProgramTypeID IN (1, 2, 3, 10, 11,19)AND ProgramAliases.AliasType = 0 ");
        query.append(" GROUP BY ProgramAliases.AliasName, ProgramAliases.ProgramId, StringLiterals.StringContent,  Statements.Description  ORDER BY k, ProgramId, stringContent \n");
        L.debug("query (all) used: {}", (Object)query);
        return query.toString();
    }

    private String buildDynamicPart(ReportModel model, String fieldName, boolean withAND) {
        StringBuffer queryPart = new StringBuffer("");
        if (withAND) {
            queryPart.append(" AND ");
        }
        queryPart.append(" (");
        List<String> expList = model.getExpressions();
        int i = 0;
        for (String expr : expList) {
            boolean isNot = false;
            if (i > 0) {
                queryPart.append(" OR ");
            }
            queryPart.append(" ( ");
            if (this.isSpecialExpression(expr)) {
                queryPart.append(" ( ");
                expr = this.transformSpecialExpressions(fieldName, expr);
                queryPart.append(expr);
                queryPart.append(" ) ");
            } else {
                if (isNot) {
                    queryPart.append(" NOT ");
                }
                queryPart.append("(");
                queryPart.append(fieldName);
                queryPart.append(" LIKE '''");
                queryPart.append(expr);
                queryPart.append("''' ");
                queryPart.append("  ESCAPE '\\' ");
                queryPart.append(" OR ");
                queryPart.append(fieldName);
                queryPart.append(" LIKE '");
                queryPart.append(expr);
                queryPart.append("' ");
                queryPart.append("  ESCAPE '\\' ");
                queryPart.append(")");
            }
            queryPart.append(" ) ");
            ++i;
        }
        queryPart.append(") ");
        return queryPart.toString();
    }

    private boolean isSpecialExpression(String expression) {
        boolean vb = Utils.isSpecialExpression((String)expression);
        if (vb) {
            vb = expression.length() > 2;
        }
        return vb;
    }

    private String transformSpecialExpressions(String fieldName, String expr) {
        String specialExpressionName = expr.substring(1, expr.length() - 1);
        if (specialExpressionName.toLowerCase().startsWith("ip")) {
            expr = this.queryForIp(fieldName, specialExpressionName);
        } else if (specialExpressionName.toLowerCase().startsWith("mac")) {
            expr = this.queryForMac(fieldName, specialExpressionName);
        } else {
            StringBuilder expBuilder = new StringBuilder();
            expBuilder.append(fieldName).append(" LIKE '").append(expr).append("'");
            expr = expBuilder.toString();
        }
        return expr;
    }

    private String queryForMac(String fieldName, String specialExpressionName) {
        String name = specialExpressionName.substring(3);
        String separator = "-";
        if (name.length() > 2 && name.startsWith("(") && name.endsWith(")")) {
            separator = name.substring(1, name.length() - 1);
        }
        StringBuilder expBuilder = new StringBuilder();
        expBuilder.append(fieldName).append(" LIKE '[''\"]");
        int i = 0;
        while (i < 6) {
            if (i > 0) {
                expBuilder.append(separator);
            }
            expBuilder.append("[0-9a-fA-F][0-9a-fA-F]");
            ++i;
        }
        expBuilder.append("[''\"]'");
        return expBuilder.toString();
    }

    private String queryForIp(String fieldName, String specialExpressionName) {
        int[] idx = new int[]{1, 1, 1, 1};
        String[] parts = null;
        String name = specialExpressionName.substring(2);
        if (name.length() > 2 && name.startsWith("(") && name.endsWith(")") && (parts = (name = name.substring(1, name.length() - 1)).split("\\.")).length == 4) {
            int i = 0;
            while (i < parts.length) {
                try {
                    if (!(parts[i].equalsIgnoreCase("xxx") || parts[i].equalsIgnoreCase("xx") || parts[i].equalsIgnoreCase("x"))) {
                        Integer.valueOf(parts[i]).intValue();
                        idx[i] = -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    idx[i] = 1;
                }
                ++i;
            }
        }
        boolean first = true;
        StringBuilder expBuilder = new StringBuilder();
        boolean finish = false;
        int count = 0;
        while (!finish) {
            if (!first) {
                expBuilder.append(" OR ");
            }
            first = false;
            expBuilder.append(fieldName).append(" LIKE '[''\"]");
            this.createIpPattern(expBuilder, idx, parts);
            ++count;
            expBuilder.append("[''\"]'");
            int i = 3;
            while (i >= 0) {
                if (idx[i] != -1) {
                    idx[i] = (idx[i] + 1) % 4;
                    if (idx[i] != 0) break;
                }
                --i;
            }
            finish = true;
            i = 0;
            while (i < 4) {
                if (idx[i] == 0) {
                    idx[i] = 1;
                } else if (idx[i] != -1) {
                    finish = false;
                }
                ++i;
            }
        }
        L.trace("count: {}", (Object)count);
        return expBuilder.toString();
    }

    private void createIpPattern(StringBuilder builder, int[] idx, String[] parts) {
        int i = 0;
        while (i < 4) {
            if (i > 0) {
                builder.append(".");
            }
            if (idx[i] == -1) {
                builder.append(parts[i]);
            } else {
                int j = 0;
                while (j < idx[i]) {
                    builder.append("[0-9]");
                    ++j;
                }
            }
            ++i;
        }
    }

    protected String getSQLQuerySelective() {
        ReportModel model = (ReportModel)this.report;
        StringBuffer query = new StringBuffer();
        query.append("SELECT ProgramAliases.AliasName as k, Variables.szValues as stringContent, 'initial_value' as Description, COUNT(Variables.szValues) AS stmtCount, ProgramAliases.ProgramId  \nFROM ProgramAliases \nINNER JOIN Variables \t\tON ProgramAliases.ProgramId = Variables.ProgIDReference \nINNER JOIN Programs  \tON Programs.ProgramID = ProgramAliases.ProgramId AND ProgramAliases.AliasType = 0 \n");
        query.append(" WHERE ");
        query.append(this.buildDynamicPart(model, "Variables.szValues", false));
        query.append(this.getQuerySelectivePart());
        query.append(" GROUP BY ProgramAliases.AliasName, ProgramAliases.ProgramId, Variables.szValues ");
        query.append(" UNION \r\n SELECT ProgramAliases.AliasName as k \n,    StringLiterals.StringContent as stringContent, Statements.Description, \n   Count(OccurrencesStmt.OccurID) AS stmtCount, ProgramAliases.ProgramId \n   FROM (SELECT sr.ResourceID, sr.OccurID \n\t\t\t\tFROM StatementReference sr \n\t\t\t\tWHERE  sr.ResourceType = 82\t \n\t\tUNION \n\t\t\tSELECT pcp.ResourceId, sr1.OccurID \n\t\t\t\tFROM  StatementReference sr1 \n\t\t\t\tINNER JOIN ProcedureCallParameters pcp ON pcp.IDKey = sr1.ResourceID AND pcp.ResourceType = 82 \n\t\t\t\tWHERE sr1.ResourceType = 208 \n\t\t)src1 \n\t\tINNER JOIN OccurrencesStmt ON src1.OccurID = OccurrencesStmt.OccurID \n\t\tINNER JOIN Statements ON OccurrencesStmt.StatementType = Statements.StatementType \n\t\tINNER JOIN ProgramAliases ON OccurrencesStmt.ProgID = ProgramAliases.ProgramId \t\t\tAND ProgramAliases.AliasType=0 \n \t\tINNER JOIN StringLiterals ON src1.ResourceID = StringLiterals.ID \n\t\tINNER JOIN Programs ON Programs.ProgramID = ProgramAliases.ProgramId \n");
        query.append(this.buildDynamicPart(model, "StringLiterals.StringContent", true));
        query.append(this.getQuerySelectivePart());
        query.append(" GROUP BY ProgramAliases.AliasName, ProgramAliases.ProgramId, StringLiterals.StringContent,  Statements.Description  ORDER BY k, ProgramId, stringContent \n");
        L.debug("query (selective) used: {}", (Object)query);
        return query.toString();
    }

    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        return Utils.countAvailablePrograms((String)COUNT_AVAILABLE_PROGRAMS_QUERY, (EZSourceConnection)conn);
    }

    @Override
    public void cleanMemory() {
        if (this.allPrgMap != null) {
            this.allPrgMap.clear();
            this.allPrgMap = null;
        }
        if (this.usedProgram != null) {
            this.usedProgram.clear();
            this.usedProgram = null;
        }
        super.cleanMemory();
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.literal"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

