/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.programsVsSMARTTables;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.programsVsIncludes.ItemComparator;
import com.ez.report.application.ezreport.reports.wu.programsVsIncludes.ItemCount;
import com.ez.report.application.ezreport.reports.wu.programsVsSMARTTables.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.programsVsSMARTTables.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.programsVsSMARTTables.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private Map programUsingTable = new HashMap();
    Map includeCountsMap = new HashMap();

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.inputWasResource = false;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
        }
        ReportDataSource dataSource = new ReportDataSource(this.resultList, this.includeCountsMap);
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum1");
        params.put("report.sum1.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum2");
        params.put("report.sum2.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum3");
        externalized = Messages.getString(ReportBuilder.class, "report.sum5");
        params.put("report.sum5.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "program.group.name");
        params.put("group1.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "program.summary");
        params.put("group1.summary", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum1");
        params.put("group.sum1", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("group.sum2", externalized);
    }

    private void clearForJasperReport() {
        this.includeCountsMap.clear();
        this.programUsingTable.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/usedIncludes.jasper";
    }

    private String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "compute.taskName"));
        SingleQueryResult queryResult = this.queryForData(pmonitor);
        String[][] results = queryResult.data;
        int allPrgNo = queryResult.resourcesCount;
        this.parameters.put("report.sum1", String.valueOf(allPrgNo));
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        if (prgList != null) {
            this.buildInputs4Appendix(prgList);
            this.parameters.put("title.appFieldValues", this.applicationsName);
        }
        HashSet<String> programs = new HashSet<String>();
        if (results == null) {
            L.warn("no results for ProgramsVSSMARTTables report");
            this.parameters.put("report.sum2", String.valueOf(0));
        } else {
            L.debug("ProgramsVSSMARTTables results:");
            String currentProgram = null;
            String currentFile = null;
            int count = 0;
            int allCount = 0;
            HashSet<String> allIncl = new HashSet<String>();
            Obj4Report obj = null;
            int i = 0;
            while (i < results.length) {
                HashMap<String, Integer> includeMap;
                String prgName = results[i][0];
                String includeName = results[i][1];
                Integer stmtCount = new Integer(1);
                allIncl.add(includeName);
                if (currentProgram == null) {
                    currentProgram = prgName;
                    currentFile = includeName;
                    ++count;
                } else if (!currentProgram.equalsIgnoreCase(prgName)) {
                    this.programUsingTable.put(currentProgram, new ItemCount(count, allCount));
                    obj.setDistinctPrgCount(count);
                    currentProgram = prgName;
                    currentFile = includeName;
                    count = 1;
                } else if (!currentFile.equalsIgnoreCase(includeName)) {
                    currentFile = includeName;
                    ++count;
                }
                if (i == results.length - 1) {
                    this.programUsingTable.put(currentProgram, new ItemCount(count, allCount));
                }
                L.debug("program: {}", (Object)results[i][0]);
                L.debug("SMART table: {}", (Object)results[i][1]);
                L.debug("\n");
                programs.add(prgName);
                obj = new Obj4Report();
                obj.setProgramName(prgName);
                obj.setTableName(includeName);
                obj.setCount(stmtCount);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{prgName, includeName});
                }
                if ((includeMap = (HashMap<String, Integer>)this.includeCountsMap.get(prgName)) == null) {
                    includeMap = new HashMap<String, Integer>();
                    this.includeCountsMap.put(prgName, includeMap);
                }
                includeMap.put(includeName, stmtCount);
                this.resultList.add(obj);
                ++i;
            }
            if (obj != null) {
                obj.setDistinctPrgCount(count);
            }
            this.parameters.put("report.sum2", String.valueOf(allIncl.size()));
        }
        if (allPrgNo != 0) {
            DefaultPieDataset dataset = new DefaultPieDataset();
            String usedCategory = Messages.getString4ChartLegend(ReportBuilder.class, (String)"used.category.lbl");
            String unusedCategory = Messages.getString4ChartLegend(ReportBuilder.class, (String)"unused.category.lbl");
            String not_using_category_lbl = Messages.getString(ReportBuilder.class, "notUsing.lbl");
            String using_category_lbl = Messages.getString(ReportBuilder.class, "using.lbl");
            dataset.setValue((Comparable)((Object)not_using_category_lbl), (Number)new Double(allPrgNo - programs.size()));
            dataset.setValue((Comparable)((Object)using_category_lbl), (Number)new Double(programs.size()));
            HashMap<String, String> formatsMap = new HashMap<String, String>();
            formatsMap.put(not_using_category_lbl, unusedCategory);
            formatsMap.put(using_category_lbl, usedCategory);
            String pieTitle = Messages.getString(ReportBuilder.class, "pie1.title");
            ArrayList<Color> colors = new ArrayList<Color>();
            colors.add(0, this.PIE_PINK_COLOR);
            colors.add(1, this.PIE_YELLOW_COLOR);
            this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap, pieTitle, 880, 540, colors));
            DefaultCategoryDataset ds = this.buildDataSet();
            if (this.programUsingTable.size() > 0) {
                String subtitle = null;
                String titleStr = Messages.getString(ReportBuilder.class, "pie2.title");
                if (this.programUsingTable.keySet().size() >= 20) {
                    Object[] msgParams = new String[]{String.valueOf(20)};
                    titleStr = titleStr.concat(" ").concat(Messages.getString(ReportBuilder.class, "bar.title", msgParams));
                    if (this.countsSame != 0) {
                        msgParams = new String[]{String.valueOf(this.countsSame)};
                        titleStr = titleStr.concat("*");
                        subtitle = Messages.getString(ReportBuilder.class, "bar.subtitle", msgParams);
                    }
                }
                String xAxis = Messages.getString(ReportBuilder.class, "bar.category.axis");
                String yAxis = Messages.getString(ReportBuilder.class, "bar.value.axis");
                this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(ds, titleStr, xAxis, yAxis, 880, 640, this.BLUE_COLOR, subtitle));
            }
        }
        this.parameters.put("breakPrgGroup", new Boolean(true));
        monitor.setWorkRemaining(0);
        return results;
    }

    private DefaultCategoryDataset buildDataSet() {
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        ArrayList prgrList = new ArrayList(this.programUsingTable.keySet());
        ItemComparator pComparator = new ItemComparator();
        pComparator.setMapWithCounts(this.programUsingTable);
        Collections.sort(prgrList, pComparator);
        int i = 0;
        int prag = 0;
        boolean endOfBars = false;
        int sum = 0;
        for (String prg : prgrList) {
            ItemCount nr = (ItemCount)this.programUsingTable.get(prg);
            if (i < 20) {
                ds.addValue((double)nr.differentInclude, (Comparable)((Object)Messages.getString(ReportBuilder.class, "distinct.barCategory")), (Comparable)((Object)prg));
                prag = nr.differentInclude;
            } else if (!endOfBars) {
                if (prag == nr.differentInclude) {
                    ++this.countsSame;
                } else {
                    endOfBars = true;
                }
            }
            sum += nr.differentInclude;
            ++i;
        }
        if (i > 0) {
            double average = new BigDecimal(sum).divide(new BigDecimal(i), 2, 6).doubleValue();
            L.debug("average: {} --- for sum={} of {} programs", new Object[]{average, sum, i});
            this.parameters.put("report.sum5", String.valueOf(average));
        } else {
            L.debug("no programs in this project!!! (i={}, sum={})", (Object)i, (Object)sum);
            this.parameters.put("report.sum5", String.valueOf(0));
        }
        return ds;
    }

    protected String getProcedure() {
        return "EZReports_ProgramsVsSmartTable";
    }

    protected String getSelectiveProcedure() {
        return "EZReports_ProgramsVsSmartTable_Selective";
    }

    @Override
    public void cleanMemory() {
        if (this.includeCountsMap != null) {
            this.includeCountsMap.clear();
            this.includeCountsMap = null;
        }
        if (this.programUsingTable != null) {
            this.programUsingTable.clear();
            this.programUsingTable = null;
        }
        super.cleanMemory();
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.smartTable")});
        }
    }
}

