/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.programsVsLogicalFiles;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.programsVsLogicalFiles.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.programsVsLogicalFiles.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.programsVsLogicalFiles.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    Map allPrgMap = new HashMap();
    private Map usedProgram = new HashMap();

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.inputWasResource = false;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
        }
        ReportDataSource dataSource = new ReportDataSource(this.resultList, this.allPrgMap);
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "stmtType.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "summary");
        params.put("summary", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum4");
        params.put("sum4", externalized);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/usedFiles.jasper";
    }

    private void clearForJasperReport() {
        this.usedProgram.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    private String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "compute.taskName"));
        SingleQueryResult queryResult = this.queryForData(pmonitor);
        String[][] results = queryResult.data;
        int allPrgNo = queryResult.resourcesCount;
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        if (prgList != null) {
            this.buildInputs4Appendix(prgList);
            this.parameters.put("title.appFieldValues", this.applicationsName);
        }
        if (results == null) {
            L.warn("no results for UsedLogicalFiles report");
        } else {
            L.debug("UsedLogicalFiles results:");
            String currentProgram = null;
            String currentFile = null;
            int count = 0;
            int i = 0;
            while (i < results.length) {
                Integer countValue;
                HashMap<String, Integer> prgMap;
                String prgName = results[i][0];
                String fileName = results[i][1];
                String stmtType = results[i][2];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][3]));
                if (currentProgram == null) {
                    currentProgram = prgName;
                    currentFile = fileName;
                    ++count;
                } else if (!currentProgram.equalsIgnoreCase(prgName)) {
                    this.usedProgram.put(currentProgram, new Integer(count));
                    currentProgram = prgName;
                    currentFile = fileName;
                    count = 1;
                } else if (!currentFile.equalsIgnoreCase(fileName)) {
                    currentFile = fileName;
                    ++count;
                }
                if (i == results.length - 1) {
                    this.usedProgram.put(currentProgram, new Integer(count));
                }
                L.debug("program: {}", (Object)prgName);
                L.debug("file: {}", (Object)fileName);
                L.debug("stmt type: {}", (Object)stmtType);
                L.debug("count: {}", (Object)stmtCount);
                L.debug("\n");
                Obj4Report obj = new Obj4Report();
                obj.setProgramName(prgName);
                obj.setFileName(fileName);
                obj.setStmtType(stmtType);
                obj.setCount(stmtCount);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{prgName, fileName, stmtType, stmtCount.toString()});
                }
                if ((prgMap = (HashMap<String, Integer>)this.allPrgMap.get(prgName)) == null) {
                    prgMap = new HashMap<String, Integer>();
                    this.allPrgMap.put(prgName, prgMap);
                }
                countValue = (countValue = (Integer)prgMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                prgMap.put(stmtType, countValue);
                this.resultList.add(obj);
                ++i;
            }
        }
        if (allPrgNo != 0) {
            DefaultPieDataset dataset = new DefaultPieDataset();
            String usedCategory = Messages.getString4ChartLegend(ReportBuilder.class, (String)"used.category.lbl");
            String unusedCategory = Messages.getString4ChartLegend(ReportBuilder.class, (String)"unused.category.lbl");
            String not_using_category_lbl = Messages.getString(ReportBuilder.class, "notUsing.lbl");
            String using_category_lbl = Messages.getString(ReportBuilder.class, "using.lbl");
            dataset.setValue((Comparable)((Object)not_using_category_lbl), (Number)new Double(allPrgNo - this.usedProgram.size()));
            dataset.setValue((Comparable)((Object)using_category_lbl), (Number)new Double(this.usedProgram.size()));
            HashMap<String, String> formatsMap = new HashMap<String, String>();
            formatsMap.put(not_using_category_lbl, unusedCategory);
            formatsMap.put(using_category_lbl, usedCategory);
            String titleStr = Messages.getString(ReportBuilder.class, "pie1.title");
            this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap, titleStr, 880, 540, null));
            if (this.usedProgram.size() > 0) {
                String stackTitle = Messages.getString(ReportBuilder.class, "pie2.title");
                DefaultCategoryDataset ds = this.buildDataSet(this.usedProgram);
                String subtitle = null;
                if (this.usedProgram.keySet().size() >= 20) {
                    Object[] msgParams = new String[]{String.valueOf(20)};
                    stackTitle = stackTitle.concat(" ").concat(Messages.getString(ReportBuilder.class, "bar.title", msgParams));
                    if (this.countsSame != 0) {
                        msgParams = new String[]{String.valueOf(this.countsSame)};
                        stackTitle = stackTitle.concat("*");
                        subtitle = Messages.getString(ReportBuilder.class, "bar.subtitle", msgParams);
                    }
                }
                String xAxis = Messages.getString(ReportBuilder.class, "bar.category.axis");
                String yAxis = Messages.getString(ReportBuilder.class, "bar.value.axis");
                this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(ds, stackTitle, xAxis, yAxis, 880, 540, null, subtitle));
            }
        }
        monitor.setWorkRemaining(0);
        return results;
    }

    protected String getProcedure() {
        return "EZReports_ProgramsVsSmartLogicalFile";
    }

    protected String getSelectiveProcedure() {
        return "EZReports_ProgramsVsSmartLogicalFile_Selective";
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.logicalFile"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

