/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.programsVsIncludes;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.computation.ProgramVsIncludesCollector;
import com.ez.mainframe.computation.ProgramsVsCollector;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.programsVsIncludes.ItemComparator;
import com.ez.report.application.ezreport.reports.wu.programsVsIncludes.ItemCount;
import com.ez.report.application.ezreport.reports.wu.programsVsIncludes.Obj4ProgramsVSIncludesReport;
import com.ez.report.application.ezreport.reports.wu.programsVsIncludes.ProgramsVSIncludesDataSource;
import com.ez.report.application.ezreport.reports.wu.programsVsIncludes.ProgramsVSIncludesReport;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramsVSIncludesReportBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramsVSIncludesReportBuilder.class);
    private Map<String, ItemCount> programUsingInclude = null;

    public ProgramsVSIncludesReportBuilder(String reportName, String settings) {
        this.report = null;
        this.programUsingInclude = new HashMap<String, ItemCount>();
        this.resultList = new ArrayList();
        this.inputWasResource = false;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ProgramsVSIncludesReportBuilder.class, "collectingData.taskName"));
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
            Collections.sort(this.resultList);
        }
        ProgramsVSIncludesDataSource dataSource = new ProgramsVSIncludesDataSource(this.resultList);
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ProgramsVSIncludesReport(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ProgramsVSIncludesReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ProgramsVSIncludesReportBuilder.class, "report.sum1");
        params.put("report.sum1.lbl", externalized);
        externalized = Messages.getString(ProgramsVSIncludesReportBuilder.class, "report.sum2");
        params.put("report.sum2.lbl", externalized);
        externalized = Messages.getString(ProgramsVSIncludesReportBuilder.class, "report.sum3");
        params.put("report.sum3.lbl", externalized);
        externalized = Messages.getString(ProgramsVSIncludesReportBuilder.class, "report.sum4");
        params.put("report.sum4.lbl", externalized);
        externalized = Messages.getString(ProgramsVSIncludesReportBuilder.class, "report.sum5");
        params.put("report.sum5.lbl", externalized);
        externalized = Messages.getString(ProgramsVSIncludesReportBuilder.class, "program.group.name");
        params.put("group1.name", externalized);
        externalized = Messages.getString(ProgramsVSIncludesReportBuilder.class, "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(ProgramsVSIncludesReportBuilder.class, "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(ProgramsVSIncludesReportBuilder.class, "program.summary");
        params.put("group1.summary", externalized);
        externalized = Messages.getString(ProgramsVSIncludesReportBuilder.class, "sum1");
        params.put("group.sum1", externalized);
        externalized = Messages.getString(ProgramsVSIncludesReportBuilder.class, "sum2");
        params.put("group.sum2", externalized);
    }

    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    private void clearForJasperReport() {
        this.programUsingInclude.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/usedIncludes.jasper";
    }

    protected String getProcedure() {
        return "EZReports_ListingOfAllIncludeFilesUsedInProgram";
    }

    protected String getSelectiveProcedure() {
        return "EZReports_ListingOfAllIncludeFilesUsedInProgram_Selective";
    }

    private String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ProgramsVSIncludesReportBuilder.class, "compute.taskName"));
        ProgramVsIncludesCollector collector = new ProgramVsIncludesCollector(!this.report.useAllResources(), true);
        Collection prgIDs = this.filterSelectedIDs();
        String[][] results = this.runCollector((ProgramsVsCollector)collector, prgIDs, pmonitor);
        int allPrgNo = this.getSelected().size();
        this.parameters.put("report.sum1", String.valueOf(allPrgNo));
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        HashMap<Integer, String> prgsByID = new HashMap<Integer, String>();
        if (prgList != null) {
            this.buildInputs4Appendix(prgList);
            for (ProgramInputNoGUI prg : prgList) {
                prgsByID.put(prg.getResourceID(), prg.getListableName());
            }
        }
        this.parameters.put("title.appFieldValues", this.applicationsName);
        int prgNo = 0;
        if (results == null) {
            L.warn("no results for ProgramVSInclude report");
            this.parameters.put("report.sum2", String.valueOf(0));
        } else {
            HashSet<String> programs = new HashSet<String>();
            L.debug("ProgramVSInclude results:");
            String currentProgram = null;
            Obj4ProgramsVSIncludesReport obj = null;
            HashSet<String> allIncl = new HashSet<String>();
            String currentGr = null;
            HashSet<String> currentInclList = new HashSet<String>();
            int i = 0;
            while (i < results.length) {
                ItemCount item;
                String ancestorName;
                int pos;
                String includeName = results[i][1];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][2]));
                int ssize = results[i].length - 1;
                String prgName = results[i][0];
                Integer prgID = new Integer(Integer.parseInt(results[i][ssize - 1]));
                if (results[i][ssize] != null) {
                    new Integer(Integer.parseInt(results[i][ssize]));
                }
                if ((pos = (ancestorName = (prgName = this.detectListableName(prgList, prgID, prgName))).indexOf(":")) > 0) {
                    ancestorName = ancestorName.substring(0, pos);
                }
                allIncl.add(includeName);
                programs.add(ancestorName);
                if (currentProgram != null && !currentProgram.equalsIgnoreCase(ancestorName)) {
                    ItemCount itm = this.programUsingInclude.get(currentProgram);
                    itm.differentInclude = itm.includes.size();
                    itm.includes.clear();
                    if (obj != null) {
                        if (currentGr == null) {
                            obj.setDistinctPrgCount(itm.differentInclude);
                        } else {
                            obj.setDistinctPrgCount(currentInclList.size());
                        }
                    }
                    currentGr = null;
                    currentInclList.clear();
                }
                currentProgram = ancestorName;
                if (!prgName.equals(ancestorName)) {
                    if (currentGr != null && !currentGr.equals(prgName)) {
                        obj.setDistinctPrgCount(currentInclList.size());
                        currentGr = null;
                        currentInclList.clear();
                    }
                    currentInclList.add(includeName);
                    currentGr = prgName;
                }
                if ((item = this.programUsingInclude.get(ancestorName)) == null) {
                    item = new ItemCount(0, 0);
                    item.includes = new HashSet<String>();
                    this.programUsingInclude.put(ancestorName, item);
                } else if (item.includes.isEmpty()) {
                    L.warn("a non-Assembler program with the same name/ancestorName ({}) it was previously found", (Object)ancestorName);
                }
                item.includes.add(includeName.toUpperCase());
                ++item.allInclude;
                L.debug("program: {}", (Object)results[i][0]);
                L.debug("include: {}", (Object)results[i][1]);
                L.debug("count: {}", (Object)results[i][2]);
                L.debug("\n");
                obj = new Obj4ProgramsVSIncludesReport();
                obj.setProgramName(prgName);
                obj.setIncludeName(includeName);
                obj.setCount(stmtCount);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{prgName, includeName, stmtCount.toString()});
                }
                this.resultList.add(obj);
                results[i] = null;
                ++i;
            }
            if (currentProgram != null) {
                ItemCount itm = this.programUsingInclude.get(currentProgram);
                itm.differentInclude = itm.includes.size();
                itm.includes = null;
                if (obj != null) {
                    if (currentGr == null) {
                        obj.setDistinctPrgCount(itm.differentInclude);
                    } else {
                        obj.setDistinctPrgCount(currentInclList.size());
                        currentInclList.clear();
                        currentInclList = null;
                        currentGr = null;
                    }
                }
            } else {
                L.warn("no current program?!");
            }
            this.parameters.put("report.sum2", String.valueOf(allIncl.size()));
            allIncl.clear();
            allIncl = null;
            prgNo = programs.size();
            programs.clear();
            programs = null;
        }
        if (allPrgNo != 0) {
            DefaultPieDataset dataset = new DefaultPieDataset();
            String usedCategory = Messages.getString4ChartLegend(ProgramsVSIncludesReportBuilder.class, (String)"used.category.lbl");
            String unusedCategory = Messages.getString4ChartLegend(ProgramsVSIncludesReportBuilder.class, (String)"unused.category.lbl");
            String not_using_category_lbl = Messages.getString(ProgramsVSIncludesReportBuilder.class, "notUsing.lbl");
            String using_category_lbl = Messages.getString(ProgramsVSIncludesReportBuilder.class, "using.lbl");
            dataset.setValue((Comparable)((Object)not_using_category_lbl), (Number)new Double(allPrgNo - prgNo));
            dataset.setValue((Comparable)((Object)using_category_lbl), (Number)new Double(prgNo));
            HashMap<String, String> formatsMap = new HashMap<String, String>();
            formatsMap.put(not_using_category_lbl, unusedCategory);
            formatsMap.put(using_category_lbl, usedCategory);
            String pieTitle = Messages.getString(ProgramsVSIncludesReportBuilder.class, "pie1.title");
            ArrayList<Color> colors = new ArrayList<Color>();
            colors.add(0, this.PIE_PINK_COLOR);
            colors.add(1, this.PIE_YELLOW_COLOR);
            this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap, pieTitle, 880, 540, colors));
            DefaultCategoryDataset ds = this.buildDataSet();
            if (this.programUsingInclude.size() > 0) {
                String subtitle = null;
                String titleStr = Messages.getString(ProgramsVSIncludesReportBuilder.class, "pie2.title");
                if (this.programUsingInclude.keySet().size() >= 20) {
                    Object[] msgParams = new String[]{String.valueOf(20)};
                    titleStr = titleStr.concat(" ").concat(Messages.getString(ProgramsVSIncludesReportBuilder.class, "bar.title", msgParams));
                    if (this.countsSame != 0) {
                        msgParams = new String[]{String.valueOf(this.countsSame)};
                        titleStr = titleStr.concat("*");
                        subtitle = Messages.getString(ProgramsVSIncludesReportBuilder.class, "bar.subtitle", msgParams);
                    }
                }
                String xAxis = Messages.getString(ProgramsVSIncludesReportBuilder.class, "bar.category.axis");
                String yAxis = Messages.getString(ProgramsVSIncludesReportBuilder.class, "bar.value.axis");
                this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(ds, titleStr, xAxis, yAxis, 880, 640, this.BLUE_COLOR, subtitle));
            }
        }
        this.parameters.put("breakPrgGroup", new Boolean(true));
        monitor.setWorkRemaining(0);
        return results;
    }

    private DefaultCategoryDataset buildDataSet() {
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        ArrayList<String> prgrList = new ArrayList<String>(this.programUsingInclude.keySet());
        ItemComparator pComparator = new ItemComparator();
        pComparator.setMapWithCounts(this.programUsingInclude);
        Collections.sort(prgrList, pComparator);
        int i = 0;
        int prag = 0;
        boolean endOfBars = false;
        int sum = 0;
        for (String prg : prgrList) {
            ItemCount nr = this.programUsingInclude.get(prg);
            if (i < 20) {
                ds.addValue((double)nr.differentInclude, (Comparable)((Object)Messages.getString(ProgramsVSIncludesReportBuilder.class, "distinct.barCategory")), (Comparable)((Object)prg));
                prag = nr.differentInclude;
            } else if (!endOfBars) {
                if (prag == nr.differentInclude) {
                    ++this.countsSame;
                } else {
                    endOfBars = true;
                }
            }
            sum += nr.differentInclude;
            ++i;
        }
        if (i > 0) {
            double average = new BigDecimal(sum).divide(new BigDecimal(i), 2, 6).doubleValue();
            L.debug("average: {} --- for sum={} of {} programs", new Object[]{average, sum, i});
            this.parameters.put("report.sum5", String.valueOf(average));
        } else {
            L.debug("no programs in this project!!! (i={}, sum={})", (Object)i, (Object)sum);
            this.parameters.put("report.sum5", String.valueOf(0));
        }
        return ds;
    }

    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        return Utils.countAvailablePrograms((String)"SELECT Count(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID not in (9, 13, 14, 15, 16) ", (EZSourceConnection)conn);
    }

    @Override
    public void cleanMemory() {
        if (this.programUsingInclude != null) {
            this.programUsingInclude.clear();
            this.programUsingInclude = null;
        }
        super.cleanMemory();
    }

    @Override
    protected void customizeJasperPrint(JasperPrint print) {
        List pages;
        super.customizeJasperPrint(print);
        if (print != null && (pages = print.getPages()) != null && pages.size() > 0) {
            ReportsUtils.removeEmptyPages((List)pages, (String)"mainframe programs vs include", (boolean)true);
        }
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.include"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

