/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.programsVsIDMSRecords;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.computation.ProgramVsIDMSRecordsAndSetsCollector;
import com.ez.mainframe.computation.ProgramsVsCollector;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.programsVsIDMSRecords.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.programsVsIDMSRecords.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.programsVsIDMSRecords.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    protected Map allPrgMap = null;
    private Map usedProgram = null;

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.resultList = new ArrayList();
        this.allPrgMap = new HashMap();
        this.usedProgram = new HashMap();
        this.inputWasResource = false;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(((Object)((Object)this)).getClass(), "collectingData.taskName"));
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
            Collections.sort(this.resultList);
        }
        boolean hideImages = (Boolean)this.getReportModel().getProperty("hide images");
        return this.instantiateDataSource(hideImages);
    }

    protected AbstractReportDataSource instantiateDataSource(boolean hideImages) {
        ReportDataSource dataSource = new ReportDataSource(this.resultList, this.allPrgMap, hideImages);
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.instantiateModel();
            this.report.setInput(this.inputs.get("selected resources"));
            Boolean value = (Boolean)this.inputs.get("hide images");
            this.report.addProperty("hide images", (Object)(value != null ? value : true));
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void instantiateModel() {
        this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(((Object)((Object)this)).getClass(), "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "stmtType.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "summary");
        params.put("summary", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "sum4");
        params.put("sum4", externalized);
    }

    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    public InputStream getReportStream(IProgressMonitor pmonitor) {
        return super.getReportStream(pmonitor);
    }

    private void clearForJasperReport() {
        this.usedProgram.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    protected String getProcedure() {
        return "EZReports_ProgramsVsIdmsRecordsUsage";
    }

    protected String getSelectiveProcedure() {
        return "EZReports_ProgramsVsIdmsRecordsUsage_Selective";
    }

    private String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "compute.taskName"));
        String[][] results = this.extractDBData(pmonitor);
        int allPrgNo = this.getSelected().size();
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        HashMap<Integer, String> prgsByID = new HashMap<Integer, String>();
        if (prgList != null) {
            this.buildInputs4Appendix(prgList);
            this.parameters.put("title.appFieldValues", this.applicationsName);
            for (ProgramInputNoGUI prg : prgList) {
                prgsByID.put(prg.getProgramID(), prg.getListableName());
            }
        }
        if (results == null) {
            L.warn("no results for UsedIDMSRecords report");
        } else {
            L.debug("UsedIDMSRecords results:");
            String currentKey = null;
            int i = 0;
            while (i < results.length) {
                Integer countValue;
                HashSet<String> files;
                String key;
                String prgName = results[i][0];
                String fileName = results[i][1];
                String stmtType = results[i][2];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][3]));
                int resL = results[i].length;
                Integer prgID = new Integer(Integer.parseInt(results[i][resL - 2]));
                Integer parentID = results[i][resL - 1] != null ? new Integer(Integer.parseInt(results[i][resL - 1])) : null;
                prgName = this.detectListableName(prgList, prgID, prgName);
                String string = key = parentID != null && prgsByID.get(parentID) != null ? (String)prgsByID.get(parentID) : prgName;
                if (currentKey != null && !key.equalsIgnoreCase(currentKey)) {
                    files = (HashSet<String>)this.usedProgram.get(currentKey);
                    int count = 0;
                    if (files == null) {
                        L.warn("program without IDMS Records?! {}", (Object)currentKey);
                    } else {
                        count = files.size();
                    }
                    this.usedProgram.put(currentKey, count);
                    currentKey = key;
                } else {
                    currentKey = i == 0 ? key : currentKey;
                }
                files = (Set)this.usedProgram.get(key);
                if (files == null) {
                    files = new HashSet<String>();
                    this.usedProgram.put(key, files);
                }
                files.add(fileName.toUpperCase());
                String[] prgDetails = new String[]{prgName, fileName, stmtType, results[i][3]};
                Obj4Report obj = this.buildReportRow(prgDetails, csvWriter);
                HashMap<String, Integer> prgMap = (HashMap<String, Integer>)this.allPrgMap.get(prgName);
                if (prgMap == null) {
                    prgMap = new HashMap<String, Integer>();
                    this.allPrgMap.put(prgName, prgMap);
                }
                countValue = (countValue = (Integer)prgMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                prgMap.put(stmtType, countValue);
                this.resultList.add(obj);
                ++i;
            }
            if (currentKey != null) {
                Set files = (Set)this.usedProgram.get(currentKey);
                int count = 0;
                if (files == null) {
                    L.warn("last program without IDMS Records?! {}", currentKey);
                } else {
                    count = files.size();
                }
                this.usedProgram.put(currentKey, count);
            }
        }
        if (allPrgNo != 0) {
            DefaultPieDataset dataset = new DefaultPieDataset();
            String usedCategory = Messages.getString4ChartLegend(((Object)((Object)this)).getClass(), (String)"used.category.lbl");
            String unusedCategory = Messages.getString4ChartLegend(((Object)((Object)this)).getClass(), (String)"unused.category.lbl");
            String not_using_category_lbl = Messages.getString(ReportBuilder.class, "notUsing.lbl");
            String using_category_lbl = Messages.getString(ReportBuilder.class, "using.lbl");
            dataset.setValue((Comparable)((Object)not_using_category_lbl), (Number)new Double(allPrgNo - this.usedProgram.size()));
            dataset.setValue((Comparable)((Object)using_category_lbl), (Number)new Double(this.usedProgram.size()));
            HashMap<String, String> formatsMap = new HashMap<String, String>();
            formatsMap.put(not_using_category_lbl, unusedCategory);
            formatsMap.put(using_category_lbl, usedCategory);
            String pieTitle = Messages.getString(((Object)((Object)this)).getClass(), "pie1.title");
            this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap, pieTitle, 880, 540, null));
            DefaultCategoryDataset ds = this.buildDataSet(this.usedProgram);
            String subtitle = null;
            if (this.usedProgram.size() > 0) {
                String titleStr = Messages.getString(((Object)((Object)this)).getClass(), "pie2.title");
                if (this.usedProgram.keySet().size() >= 20) {
                    Object[] msgParams = new String[]{String.valueOf(20)};
                    titleStr = titleStr.concat(" ").concat(Messages.getString(((Object)((Object)this)).getClass(), "bar.title", msgParams));
                    if (this.countsSame != 0) {
                        msgParams = new String[]{String.valueOf(this.countsSame)};
                        titleStr = titleStr.concat("*");
                        subtitle = Messages.getString(((Object)((Object)this)).getClass(), "bar.subtitle", msgParams);
                    }
                }
                String xAxis = Messages.getString(((Object)((Object)this)).getClass(), "bar.category.axis");
                String yAxis = Messages.getString(((Object)((Object)this)).getClass(), "bar.value.axis");
                this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(ds, titleStr, xAxis, yAxis, 880, 540, null, subtitle));
            }
        }
        monitor.setWorkRemaining(0);
        return results;
    }

    protected String[][] extractDBData(IProgressMonitor pmonitor) {
        ProgramsVsCollector collector = this.instantiateCollector();
        Collection prgIDs = this.filterSelectedIDs();
        String[][] results = this.runCollector(collector, prgIDs, pmonitor);
        return results;
    }

    protected ProgramsVsCollector instantiateCollector() {
        ProgramVsIDMSRecordsAndSetsCollector collector = new ProgramVsIDMSRecordsAndSetsCollector(!this.report.useAllResources(), true, 0);
        return collector;
    }

    protected Obj4Report buildReportRow(String[] resultsRow, CSVWriter csvWriter) {
        String prgName = resultsRow[0];
        String fileName = resultsRow[1];
        String stmtType = resultsRow[2];
        Integer stmtCount = new Integer(Integer.parseInt(resultsRow[3]));
        L.debug("program: {}", (Object)prgName);
        L.debug("IDMSRecord: {}", (Object)fileName);
        L.debug("stmt type: {}", (Object)stmtType);
        L.debug("count: {}", (Object)stmtCount);
        L.debug("\n");
        Obj4Report obj = new Obj4Report();
        obj.setProgramName(prgName);
        obj.setIDMSRecordName(fileName);
        obj.setStmtType(stmtType);
        obj.setCount(stmtCount);
        if (csvWriter != null) {
            csvWriter.write(new String[]{prgName, fileName, stmtType, stmtCount.toString()});
        }
        return obj;
    }

    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        return Utils.countAvailablePrograms((String)"SELECT Count(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID not in (9, 13, 14, 15, 16) ", (EZSourceConnection)conn);
    }

    @Override
    public void cleanMemory() {
        if (this.allPrgMap != null) {
            this.allPrgMap.clear();
            this.allPrgMap = null;
        }
        if (this.usedProgram != null) {
            this.usedProgram.clear();
            this.usedProgram = null;
        }
        if (this.resultList != null) {
            this.resultList.clear();
            this.resultList = null;
        }
        super.cleanMemory();
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.idmsRecord"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

