/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.programsVsFiles;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.computation.ProgramVsFilesCollector;
import com.ez.mainframe.computation.ProgramsVsCollector;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.programsVsFiles.Obj4ProgramsVSFilesReport;
import com.ez.report.application.ezreport.reports.wu.programsVsFiles.ProgramsVSFilesDataSource;
import com.ez.report.application.ezreport.reports.wu.programsVsFiles.ProgramsVSFilesReport;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramsVSFilesReportBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramsVSFilesReportBuilder.class);
    protected Map allPrgMap = null;
    protected Map<String, Object> usedProgram = null;
    private static final String COUNT_AVAILABLE_PROGRAMS_QUERY = "SELECT Count(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID in (1, 2, 3, 8, 10, 11) ";

    public ProgramsVSFilesReportBuilder(String reportName, String settings) {
        this.report = null;
        this.resultList = new ArrayList();
        this.allPrgMap = new HashMap();
        this.usedProgram = new HashMap<String, Object>();
        this.inputWasResource = false;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ProgramsVSFilesReportBuilder.class, "collectingData.taskName"));
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
        }
        return this.buildReportDS();
    }

    protected AbstractReportDataSource buildReportDS() {
        ProgramsVSFilesDataSource dataSource = new ProgramsVSFilesDataSource(this.resultList, this.allPrgMap);
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ProgramsVSFilesReport(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ProgramsVSFilesReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ProgramsVSFilesReportBuilder.class, "stmtType.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(ProgramsVSFilesReportBuilder.class, "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(ProgramsVSFilesReportBuilder.class, "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(ProgramsVSFilesReportBuilder.class, "summary");
        params.put("summary", externalized);
        externalized = Messages.getString(ProgramsVSFilesReportBuilder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(ProgramsVSFilesReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(ProgramsVSFilesReportBuilder.class, "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(ProgramsVSFilesReportBuilder.class, "sum4");
        params.put("sum4", externalized);
    }

    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/usedFiles.jasper";
    }

    private void clearForJasperReport() {
        this.usedProgram.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    protected String getProcedure() {
        return "EZReports_ProgramsVsFiles";
    }

    protected String getSelectiveProcedure() {
        return "EZReports_ProgramsVsFiles_Selective";
    }

    private String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ProgramsVSFilesReportBuilder.class, "compute.taskName"));
        ProgramsVsCollector collector = this.instantiateCollector();
        Collection prgIDs = this.filterSelectedIDs();
        String[][] results = this.runCollector(collector, prgIDs, pmonitor);
        int allPrgNo = this.getSelected().size();
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        HashMap<Integer, String> prgsMap = new HashMap<Integer, String>();
        if (prgList != null) {
            this.buildInputs4Appendix(prgList);
            this.parameters.put("title.appFieldValues", this.applicationsName);
            for (ProgramInputNoGUI prg : prgList) {
                prgsMap.put(prg.getProgramID(), prg.getListableName());
            }
        }
        if (results == null) {
            L.warn("no results for UsedFiles report");
        } else {
            L.debug("UsedFiles results:");
            String currentKey = null;
            int i = 0;
            while (i < results.length) {
                Integer countValue;
                HashSet<String> files;
                String key;
                String prgName = results[i][0];
                String fileName = results[i][1];
                String stmtType = results[i][2];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][3]));
                Integer prgID = new Integer(Integer.parseInt(results[i][5]));
                Integer parentID = results[i][6] != null ? new Integer(Integer.parseInt(results[i][6])) : null;
                String listableName = this.detectListableName(prgList, prgID, prgName);
                String string = key = parentID != null && prgsMap.get(parentID) != null ? (String)prgsMap.get(parentID) : listableName;
                if (currentKey != null && !key.equalsIgnoreCase(currentKey)) {
                    files = (HashSet<String>)this.usedProgram.get(currentKey);
                    int count = 0;
                    if (files == null) {
                        L.warn("program without files?! {}", (Object)currentKey);
                    } else {
                        count = files.size();
                    }
                    this.usedProgram.put(currentKey, count);
                    currentKey = key;
                } else {
                    currentKey = i == 0 ? key : currentKey;
                }
                files = (Set)this.usedProgram.get(key);
                if (files == null) {
                    files = new HashSet<String>();
                    this.usedProgram.put(key, files);
                }
                files.add(fileName != null ? fileName.toUpperCase() : "");
                Obj4ProgramsVSFilesReport obj = this.buildReportRow(results[i], csvWriter, listableName);
                HashMap<String, Integer> prgMap = (HashMap<String, Integer>)this.allPrgMap.get(listableName);
                if (prgMap == null) {
                    prgMap = new HashMap<String, Integer>();
                    this.allPrgMap.put(listableName, prgMap);
                }
                countValue = (countValue = (Integer)prgMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                prgMap.put(stmtType, countValue);
                this.resultList.add(obj);
                ++i;
            }
            if (currentKey != null) {
                Set files = (Set)this.usedProgram.get(currentKey);
                int count = 0;
                if (files == null) {
                    L.warn("last program without files?! {}", currentKey);
                } else {
                    count = files.size();
                }
                this.usedProgram.put(currentKey, count);
            }
        }
        if (allPrgNo != 0) {
            DefaultPieDataset dataset = new DefaultPieDataset();
            String usedCategory = Messages.getString4ChartLegend(((Object)((Object)this)).getClass(), (String)"used.category.lbl");
            String unusedCategory = Messages.getString4ChartLegend(((Object)((Object)this)).getClass(), (String)"unused.category.lbl");
            String not_using_category_lbl = Messages.getString(ProgramsVSFilesReportBuilder.class, "notUsing.lbl");
            String using_category_lbl = Messages.getString(ProgramsVSFilesReportBuilder.class, "using.lbl");
            dataset.setValue((Comparable)((Object)not_using_category_lbl), (Number)new Double(allPrgNo - this.usedProgram.size()));
            dataset.setValue((Comparable)((Object)using_category_lbl), (Number)new Double(this.usedProgram.size()));
            HashMap<String, String> formatsMap = new HashMap<String, String>();
            formatsMap.put(not_using_category_lbl, unusedCategory);
            formatsMap.put(using_category_lbl, usedCategory);
            String titleStr = Messages.getString(ProgramsVSFilesReportBuilder.class, "pie1.title");
            this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap, titleStr, 880, 540, null));
            if (this.usedProgram.size() > 0) {
                String stackTitle = Messages.getString(ProgramsVSFilesReportBuilder.class, "pie2.title");
                DefaultCategoryDataset ds = this.buildDataSet(this.usedProgram);
                String subtitle = null;
                if (this.usedProgram.keySet().size() >= 20) {
                    Object[] msgParams = new String[]{String.valueOf(20)};
                    stackTitle = stackTitle.concat(" ").concat(Messages.getString(((Object)((Object)this)).getClass(), "bar.title", msgParams));
                    if (this.countsSame != 0) {
                        msgParams = new String[]{String.valueOf(this.countsSame)};
                        stackTitle = stackTitle.concat("*");
                        subtitle = Messages.getString(((Object)((Object)this)).getClass(), "bar.subtitle", msgParams);
                    }
                }
                String xAxis = Messages.getString(((Object)((Object)this)).getClass(), "bar.category.axis");
                String yAxis = Messages.getString(ProgramsVSFilesReportBuilder.class, "bar.value.axis");
                this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(ds, stackTitle, xAxis, yAxis, 880, 540, null, subtitle));
            }
        } else {
            this.parameters.put("SubreportStream1", null);
        }
        monitor.setWorkRemaining(0);
        return results;
    }

    protected ProgramsVsCollector instantiateCollector() {
        ProgramVsFilesCollector collector = new ProgramVsFilesCollector(!this.report.useAllResources(), true);
        return collector;
    }

    protected Obj4ProgramsVSFilesReport buildReportRow(String[] resultsRow, CSVWriter csvWriter, String listableName) {
        String prgName = listableName == null ? resultsRow[0] : listableName;
        String fileName = resultsRow[1];
        if (fileName == null) {
            fileName = Messages.getString(ProgramsVSFilesReportBuilder.class, "csv.row.file.notavailable");
        }
        String stmtType = resultsRow[2];
        Integer stmtCount = new Integer(Integer.parseInt(resultsRow[3]));
        boolean hasParrent = resultsRow.length <= 5;
        Integer prgID = hasParrent ? new Integer(Integer.parseInt(resultsRow[resultsRow.length - 1])) : new Integer(Integer.parseInt(resultsRow[5]));
        L.debug("program: {}", (Object)prgName);
        L.debug("file: {}", (Object)fileName);
        L.debug("stmt type: {}", (Object)stmtType);
        L.debug("count: {}", (Object)stmtCount);
        L.debug("programID: {}", (Object)prgID);
        L.debug("\n");
        Obj4ProgramsVSFilesReport obj = new Obj4ProgramsVSFilesReport();
        obj.setProgramName(prgName);
        obj.setFileName(fileName);
        obj.setStmtType(stmtType);
        obj.setCount(stmtCount);
        obj.setPrgID(prgID);
        if (csvWriter != null) {
            csvWriter.write(new String[]{prgName, fileName, stmtType, stmtCount.toString()});
        }
        return obj;
    }

    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        return Utils.countAvailablePrograms((String)COUNT_AVAILABLE_PROGRAMS_QUERY, (EZSourceConnection)conn);
    }

    @Override
    public void cleanMemory() {
        if (this.allPrgMap != null) {
            this.allPrgMap.clear();
            this.allPrgMap = null;
        }
        if (this.usedProgram != null) {
            this.usedProgram.clear();
            this.usedProgram = null;
        }
        super.cleanMemory();
    }

    @Override
    protected String getSubreportTemplate1() {
        return "reports/usingFilesPies.jasper";
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.file"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

