/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.programsVsDBI;

import com.ez.common.model.LogMessage;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.programsVsDBI.DBIScriptlet;
import com.ez.report.application.ezreport.reports.wu.programsVsDBI.ReportModel;
import com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.twolevels.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.twolevels.WUTwoLevelsBuilder;
import com.ez.report.application.ezreport.utils.Utils;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUTwoLevelsBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String EZREP_ALL_PROCEDURE = "EZViewer_ProgramsVsDBI";
    private static final String EZREP_SELECTIVE_PROCEDURE = "EZViewer_ProgramsVsDBI_Selective";

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
        this.inputWasResource = false;
    }

    @Override
    protected String getUsedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(ReportBuilder.class, (String)"used.category.lbl");
    }

    @Override
    protected String getUnusedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(ReportBuilder.class, (String)"unused.category.lbl");
    }

    @Override
    protected String getPieTitle() {
        return Messages.getString(ReportBuilder.class, "pie1.title");
    }

    @Override
    protected String getInputTypeName() {
        return Messages.getString(ReportBuilder.class, "inputName.lbl");
    }

    protected String getProcedure() {
        return EZREP_ALL_PROCEDURE;
    }

    protected String getSelectiveProcedure() {
        return EZREP_SELECTIVE_PROCEDURE;
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        ReportDataSource ds = (ReportDataSource)super.getDataSource(pmonitor);
        ds.setDomainAxisLabel(Messages.getString(ReportBuilder.class, "stackedBar.domainAxis.lbl"));
        ds.setStackedBarTitle(Messages.getString(ReportBuilder.class, "stackedBar.title"));
        return ds;
    }

    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    @Override
    protected List<Obj4Report> getDBData(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        List<Obj4Report> result = null;
        String[][] results = null;
        try {
            SingleQueryResult queryResult = this.queryForData(pmonitor, EZSourceDataType.Integer, this.filterSelectedIDs());
            results = queryResult.data;
        }
        catch (EZSourceConnectionException e) {
            L.error("exception at getting data for report", (Throwable)e);
            this.messages.add(new LogMessage(Messages.getString(ReportBuilder.class, "gettingDataError.logMessage"), 4, "com.ez.mainframe.reports.gui", (Throwable)e));
        }
        if (results == null || results.length == 0) {
            L.info("no results for Programs Vs DBI report");
        } else {
            result = this.buildReportData(pmonitor, results, csvWriter);
        }
        return result;
    }

    protected List<Obj4Report> buildReportData(IProgressMonitor pmonitor, String[][] results, CSVWriter csvWriter) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)results.length);
        ArrayList<Obj4Report> ret = new ArrayList<Obj4Report>();
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        HashMap<Integer, String> prgsMap = new HashMap<Integer, String>();
        if (prgList != null) {
            for (ProgramInputNoGUI prg : prgList) {
                prgsMap.put(prg.getProgramID(), prg.getListableName());
            }
        }
        L.trace("ProgramsVsDBI results:");
        String currentKey = null;
        int i = 0;
        while (i < results.length) {
            Integer countValue;
            String[] row = results[i];
            results[i] = null;
            String prgName = row[0];
            String tblName = row[1];
            String stmtType = row[2];
            String pattern = row[3] != null ? row[3] : "";
            Integer stmtCount = new Integer(Integer.parseInt(row[4]));
            Integer prgID = new Integer(Integer.parseInt(row[5]));
            String key = prgName = prgsMap.get(prgID) != null ? (String)prgsMap.get(prgID) : prgName;
            if (currentKey != null && !key.equalsIgnoreCase(currentKey)) {
                Set files = (Set)this.usedResources.get(currentKey);
                int count = 0;
                if (files == null) {
                    L.warn("program without DBI resources?! {}", (Object)currentKey);
                } else {
                    count = files.size();
                }
                this.usedResources.put(currentKey, count);
                currentKey = key;
            } else {
                currentKey = i == 0 ? key : currentKey;
            }
            HashSet<String> patterns = (HashSet<String>)this.usedResources.get(key);
            if (patterns == null) {
                patterns = new HashSet<String>();
                this.usedResources.put(key, patterns);
            }
            patterns.add(tblName.toUpperCase());
            HashMap<String, Integer> prgMap = (HashMap<String, Integer>)this.allResMap.get(prgName);
            if (prgMap == null) {
                prgMap = new HashMap<String, Integer>();
                this.allResMap.put(prgName, prgMap);
            }
            countValue = (countValue = (Integer)prgMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
            prgMap.put(stmtType, countValue);
            if (L.isTraceEnabled()) {
                L.trace("program: {}", (Object)prgName);
                L.trace("DBITable: {}", (Object)tblName);
                L.trace("stmt: {}", (Object)stmtType);
                L.trace("pattern: {}", (Object)pattern);
                L.trace("count: {}", (Object)stmtCount);
                L.trace("\n");
            }
            Obj4Report obj = new Obj4Report();
            obj.level1 = prgName;
            obj.level1Type = Messages.getString(ReportBuilder.class, "detail.programType");
            obj.level2 = tblName;
            obj.level2Type = Messages.getString(ReportBuilder.class, "detail.resourceType");
            obj.level3 = stmtType;
            obj.setStmtType(pattern);
            obj.setCount(stmtCount);
            ret.add(obj);
            if (csvWriter != null) {
                csvWriter.write(new String[]{prgName, tblName, stmtType, pattern, stmtCount.toString()});
            }
            monitor.worked(1);
            ++i;
        }
        if (currentKey != null) {
            Set files = (Set)this.usedResources.get(currentKey);
            int count = 0;
            if (files == null) {
                L.warn("last program without DBI tables?! {}", currentKey);
            } else {
                count = files.size();
            }
            this.usedResources.put(currentKey, count);
        }
        return ret;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", selectedApps);
            selectedApps = this.inputs.get("selected applications names");
            this.report.addProperty("selected app names", selectedApps);
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    public Map<String, Object> getReportParameters(IProgressMonitor pmonitor) {
        this.parameters = super.getReportParameters(pmonitor);
        Utils.addScriptlet(this.parameters, DBIScriptlet.class.getName());
        return this.parameters;
    }

    @Override
    protected void putExternalizedParameters(Map<String, Object> params) {
        super.putExternalizedParameters(params);
        params.put("report.title", Messages.getString(ReportBuilder.class, "report.title"));
        Set apps = (Set)this.getReportModel().getProperty("selected app names");
        if (apps != null) {
            params.put("title.appFieldValues", apps.toString());
        }
        String externalized = Messages.getString(ReportBuilder.class, "detail.column2.name");
        params.put("column2.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "detail.column1.name");
        params.put("column1.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum4");
        params.put("sum4", externalized);
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.dbi"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.function"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.pattern"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

