/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.programsVsAdabas;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUDataSource;
import com.ez.report.application.ezreport.reports.wu.programsVsAdabas.Obj4Report;
import java.awt.Image;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDataSource
extends WUDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportDataSource.class);
    private Object currentValue;
    private List list = null;
    Map allPrgMap;
    String stackedBarTitle = Messages.getString(ReportDataSource.class, "stackedBar.title");
    String domainAxisLabel = Messages.getString(ReportDataSource.class, "stackedBar.domainAxis.lbl");
    String rangeAxisLabel = Messages.getString(ReportDataSource.class, "stackedBar.rangeAxis.lbl");

    public ReportDataSource(List list, Map map) {
        this.list = list;
        this.allPrgMap = map;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        Obj4Report values = (Obj4Report)this.currentValue;
        if (field.getName().equalsIgnoreCase("printColsHeader")) {
            if (this.currentValue != null) {
                if (this.firstInGroup) {
                    value = Boolean.TRUE;
                } else {
                    value = Boolean.FALSE;
                    L.debug("printColsHeader=false for " + this.currentValue);
                }
            }
        } else if (field.getName().equalsIgnoreCase("printGroupHeader")) {
            if (this.currentValue != null) {
                if (this.firstInGroup) {
                    value = Boolean.TRUE;
                } else if (this.lastInGroup && !this.lastInReport) {
                    value = Boolean.TRUE;
                    L.debug("currentVal: " + this.currentValue + " lastingroup!!");
                    L.debug("<------------------------------------->");
                } else {
                    value = Boolean.FALSE;
                    L.debug("printGroupHeader=false for " + this.currentValue);
                }
            }
        } else {
            value = values.get(field.getName());
        }
        return value;
    }

    public boolean nextItem() throws JRException {
        Object object = this.currentValue = this.list.size() > 0 ? (Object)this.list.remove(0) : null;
        if (this.currentValue != null) {
            Obj4Report nextV = this.list.size() > 0 ? (Obj4Report)this.list.get(0) : null;
            Obj4Report obj = (Obj4Report)this.currentValue;
            if (nextV != null) {
                this.firstInGroup = this.lastInGroup;
                if (nextV.getProgramName().equalsIgnoreCase(obj.getProgramName())) {
                    this.lastInGroup = false;
                } else {
                    this.lastInGroup = true;
                    DefaultCategoryDataset ds = this.getCountBarDataset(this.allPrgMap, obj.getProgramName());
                    Image img = this.createStackedBar(ds, this.stackedBarTitle, this.domainAxisLabel, this.rangeAxisLabel, 1020, 600);
                    obj.setBarImg(img);
                }
                this.lastInReport = false;
            } else {
                this.firstInGroup = this.lastInGroup;
                this.lastInGroup = true;
                DefaultCategoryDataset ds = this.getCountBarDataset(this.allPrgMap, obj.getProgramName());
                Image img = this.createStackedBar(ds, this.stackedBarTitle, this.domainAxisLabel, this.rangeAxisLabel, 1020, 600);
                obj.setBarImg(img);
                this.lastInReport = true;
            }
            L.debug("currentVal: " + this.currentValue + " -- first=" + this.firstInGroup + " -- last=" + this.lastInGroup);
            return true;
        }
        return false;
    }
}

