/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.jobsVsSQLTables;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.jobsVsSQLTables.ReportModel;
import com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report;
import com.ez.report.application.model.AbstractReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends com.ez.report.application.ezreport.reports.wu.jobsVsResource.ReportBuilder {
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String EZREP_JOBSS_VS_SQLTABLES = "EZReports_JobsVsSQLTables";
    private static final String EZREP_JOBSS_VS_SQLTABLES_SELECTIVE = "EZReports_JobsVsSQLTables_Selective";
    private static final String EZREP_JOBSS_VS_SQLTABLES_SELECTIVE_UCMDB = "EZReports_JobsVsSQLTables_Selective_UCMDB";

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
        this.reportTitle = Messages.getString(ReportBuilder.class, "report.title");
    }

    @Override
    protected void putExternalizedParameters(Map<String, Object> params) {
        super.putExternalizedParameters(params);
        String externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(ReportBuilder.class, "detail.column2.name");
        params.put("column2.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "detail.column1.name");
        params.put("column1.name", externalized);
    }

    @Override
    protected AbstractReport instantiateReportModel() {
        return new ReportModel(this.project, this.getSelectionFlagFromInputs());
    }

    protected String getProcedure() {
        return EZREP_JOBSS_VS_SQLTABLES;
    }

    protected String getSelectiveProcedure() {
        boolean vb;
        Object selectedApps = this.report.getProperty("filtered by app");
        boolean bl = vb = this.isMultiApp() && selectedApps != null && (Boolean)selectedApps != false;
        if (vb) {
            return EZREP_JOBSS_VS_SQLTABLES_SELECTIVE_UCMDB;
        }
        return EZREP_JOBSS_VS_SQLTABLES_SELECTIVE;
    }

    @Override
    protected List<Obj4Report> buildReportData(IProgressMonitor pmonitor, String[][] results, CSVWriter csvWriter) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)results.length);
        ArrayList<Obj4Report> result = new ArrayList<Obj4Report>();
        L.debug("JobsVsSqlTables results:");
        String currentKey = null;
        int i = 0;
        while (i < results.length) {
            Integer countValue;
            HashSet<String> files;
            String key;
            String programPath;
            String[] row = results[i];
            results[i] = null;
            String jobName = row[0];
            String prgName = row[1];
            String ancestor = row[2];
            String sqlTable = row[3];
            String stmtType = row[4];
            Integer stmtCount = new Integer(Integer.parseInt(row[5]));
            String memberName = row.length > 6 ? row[7] : null;
            String string = programPath = row.length > 6 ? row[8] : null;
            if (ancestor != null && !ancestor.isEmpty()) {
                prgName = String.valueOf(ancestor) + ": " + prgName;
            }
            if (programPath != null && !programPath.isEmpty()) {
                prgName = prgName.concat(" (").concat(programPath).concat(")");
            }
            String string2 = key = memberName != null && !memberName.equalsIgnoreCase(jobName) ? String.valueOf(jobName) + " (" + memberName + ")" : jobName;
            if (currentKey != null && !key.equalsIgnoreCase(currentKey)) {
                files = (HashSet<String>)this.usedResources.get(currentKey);
                int count = 0;
                if (files == null) {
                    L.warn("program without files?! {}", (Object)currentKey);
                } else {
                    count = files.size();
                }
                this.usedResources.put(currentKey, count);
                currentKey = key;
            } else {
                currentKey = i == 0 ? key : currentKey;
            }
            files = (Set)this.usedResources.get(key);
            if (files == null) {
                files = new HashSet<String>();
                this.usedResources.put(key, files);
            }
            files.add(sqlTable.toUpperCase());
            HashMap<String, Integer> prgMap = (HashMap<String, Integer>)this.allResMap.get(key);
            if (prgMap == null) {
                prgMap = new HashMap<String, Integer>();
                this.allResMap.put(key, prgMap);
            }
            countValue = (countValue = (Integer)prgMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
            prgMap.put(stmtType, countValue);
            if (L.isDebugEnabled()) {
                L.debug("job: {}", (Object)jobName);
                L.debug("memberName: {}", (Object)memberName);
                L.debug("table: {}", (Object)sqlTable);
                L.debug("program: {}", (Object)prgName);
                L.debug("stmt type: {}", (Object)stmtType);
                L.debug("count: {}", (Object)stmtCount);
                L.debug("\n");
            }
            Obj4Report obj = new Obj4Report();
            obj.level1 = key;
            obj.level1Type = JOB_GROUP_TYPE;
            obj.level2 = sqlTable;
            obj.level2Type = Messages.getString(ReportBuilder.class, "detail.resourceType");
            obj.level3 = prgName;
            obj.setStmtType(stmtType);
            obj.setCount(stmtCount);
            result.add(obj);
            if (csvWriter != null) {
                csvWriter.write(new String[]{key, sqlTable, prgName, stmtType, stmtCount.toString()});
            }
            monitor.worked(1);
            ++i;
        }
        if (currentKey != null) {
            Set files = (Set)this.usedResources.get(currentKey);
            int count = 0;
            if (files == null) {
                L.warn("last job without sqlTables?! {}", currentKey);
            } else {
                count = files.size();
            }
            this.usedResources.put(currentKey, count);
        }
        return result;
    }

    @Override
    protected String getUsedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(ReportBuilder.class, (String)"used.category.lbl");
    }

    @Override
    protected String getUnusedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(ReportBuilder.class, (String)"unused.category.lbl");
    }

    @Override
    protected String getPieTitle() {
        return Messages.getString(ReportBuilder.class, "pie1.title");
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.job"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.sqlTable"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

