/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.jobsVsResource;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.twolevels.WUTwoLevelsBuilder;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReportBuilder
extends WUTwoLevelsBuilder {
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    protected static final String JOB_GROUP_TYPE = Messages.getString(ReportBuilder.class, "job.group.type");
    protected String reportTitle;

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
        this.inputWasResource = false;
    }

    @Override
    protected void putExternalizedParameters(Map<String, Object> params) {
        super.putExternalizedParameters(params);
        params.put("report.title", this.reportTitle);
        Set apps = (Set)this.getReportModel().getProperty("selected app names");
        if (apps != null) {
            params.put("title.appFieldValues", apps.toString());
        }
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = this.instantiateReportModel();
            this.report.setInput(this.inputs.get("selected resources"));
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", selectedApps);
            selectedApps = this.inputs.get("selected applications names");
            this.report.addProperty("selected app names", selectedApps);
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected abstract AbstractReport instantiateReportModel();

    @Override
    protected List<Obj4Report> getDBData(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        String[][] results;
        List<Obj4Report> result;
        block13: {
            result = null;
            results = null;
            EZSourceConnection bridge = null;
            try {
                try {
                    boolean vb;
                    Object selectedApps = this.report.getProperty("filtered by app");
                    Collection app = this.report.getSelectedApplications();
                    boolean bl = vb = this.isMultiApp() && selectedApps != null && (Boolean)selectedApps != false;
                    if (vb) {
                        bridge = EZSourceConnectionManager.getCurrent();
                        bridge.executeUpdate(Utils.buildCreateTempTableStr((EZSourceConnection)bridge, (String)this.tempTableName, (EZSourceDataType)EZSourceDataType.String));
                        ArrayList<EZSourceDataType> param = new ArrayList<EZSourceDataType>();
                        param.add(EZSourceDataType.String);
                        String[][] pVals = new String[app.size()][1];
                        Iterator it = app.iterator();
                        int j = 0;
                        while (it.hasNext()) {
                            String id;
                            pVals[j][0] = id = (String)it.next();
                            ++j;
                        }
                        bridge.insertBatch(Utils.getTempTableName((EZSourceConnection)bridge, (String)this.tempTableName), pVals, param);
                        this.report.addProperty("selected app", null);
                    }
                    SingleQueryResult queryResult = this.queryForData(pmonitor, EZSourceDataType.Integer);
                    results = queryResult.data;
                    if (vb) {
                        Utils.cleanTable((EZSourceConnection)bridge, (String)this.tempTableName);
                        Utils.dropTempTable((EZSourceConnection)bridge, (String)this.tempTableName);
                        this.report.addProperty("selected app", (Object)app);
                    }
                }
                catch (EZSourceConnectionException e) {
                    L.error("exception at getting data for report", (Throwable)e);
                    EZReportErrorLog.err(Messages.getString(ReportBuilder.class, "gettingDataError.logMessage", new String[]{this.reportTitle}), e);
                    if (bridge != null) {
                        EZSourceConnectionManager.release((EZSourceConnection)bridge);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (bridge != null) {
                    EZSourceConnectionManager.release(bridge);
                }
                throw throwable;
            }
            if (bridge != null) {
                EZSourceConnectionManager.release((EZSourceConnection)bridge);
            }
        }
        if (results == null) {
            L.warn("no results for " + this.reportTitle + " report");
        } else {
            result = this.buildReportData(pmonitor, results, csvWriter);
        }
        return result;
    }

    protected abstract List<Obj4Report> buildReportData(IProgressMonitor var1, String[][] var2, CSVWriter var3);

    @Override
    protected String getInputTypeName() {
        return Messages.getString(ReportBuilder.class, "files.lbl");
    }
}

