/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.jobsVsResource;

import com.ez.internal.analysis.config.inputs.EZJobInputType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.JobInputNoGUI;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.wizard.GenericSelectInputPage4Report;
import com.ez.report.application.ezreport.reports.wu.WUAbstractAnalysis;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.collectors.JobsInputCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class JobsVsResourceAnalysis
extends WUAbstractAnalysis {
    public JobsVsResourceAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    public void setInputs(List inputs) {
        if (inputs != null) {
            if (inputs.size() > 0 && inputs.get(0) instanceof EZSourceProjectInputType) {
                super.setInputs(inputs);
            } else {
                ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
                this.params = new HashMap();
                ArrayList<JobInputNoGUI> sel = new ArrayList<JobInputNoGUI>();
                HashSet<String> inputNames = new HashSet<String>();
                for (Object inpObj : inputs) {
                    if (!(inpObj instanceof EZJobInputType)) continue;
                    EZEntityID entity = ((EZJobInputType)inpObj).getEntID();
                    list.add(entity);
                    EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
                    if (prjSg == null) continue;
                    if (!prjSg.getProjectName().equals(this.projectName)) {
                        this.setPrjName(prjSg.getProjectName());
                        this.addContextValue("input_project_names", prjSg.getProjectName());
                        ProjectInfo pInfo = prjSg.getProjectInfo();
                        com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                        this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
                    }
                    EZSourceJobIDSg sg = (EZSourceJobIDSg)entity.getSegment(EZSourceJobIDSg.class);
                    String name = sg.getJobName();
                    String memberName = sg.getMemberName();
                    sel.add(new JobInputNoGUI(name, memberName, String.valueOf(sg.getJobId())));
                    inputNames.add(name);
                    this.addContextValue("input_project_names", prjSg.getProjectName());
                }
                if (!sel.isEmpty()) {
                    this.params = new HashMap();
                    this.params.put("project_name", this.projectName);
                    this.params.put("report_model", this.report);
                    this.params.put("selected resources", sel);
                    this.params.put("show summary only", Boolean.FALSE);
                    this.params.put("show appendix", Boolean.TRUE);
                    this.params.put("all resources selected", Boolean.FALSE);
                    this.addAllContextValues(this.params);
                    this.addContextValue("input_list", list);
                    this.addContextValue("inputs name string", inputNames);
                }
            }
        }
    }

    @Override
    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        wizard.setWindowTitle(this.getWizardTitle());
        GenericSelectInputPage4Report selectProgramsPage = new GenericSelectInputPage4Report("programs page", true);
        selectProgramsPage.setLeftGroupLabel(Messages.getString(JobsVsResourceAnalysis.class, "av.object.type"));
        selectProgramsPage.setRightGroupLabel(Messages.getString(JobsVsResourceAnalysis.class, "sel.object.type"));
        JobsInputCollector jc = new JobsInputCollector();
        selectProgramsPage.setResourcesCollector((ResourcesCollector)jc);
        wizard.addPage(selectProgramsPage);
        return wizard;
    }

    protected abstract String getWizardTitle();

    @Override
    protected void completeSelectedPrograms(PrepareReportWizard wizard) {
        List sel = wizard.getList("selected resources");
        if (sel != null) {
            HashSet<String> inputNames = new HashSet<String>();
            for (JobInputNoGUI ji : sel) {
                inputNames.add(ji.getName());
            }
            this.addContextValue("inputs name string", inputNames);
        }
    }
}

