/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.jobsVsDatasets;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.jobsVsDatasets.ReportModel;
import com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.twolevels.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.twolevels.WUTwoLevelsBuilder;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends com.ez.report.application.ezreport.reports.wu.jobsVsResource.ReportBuilder {
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String EZREP_QUERY = "EZReports_JobsVsDatasets";
    private static final String EZREP_QUERY_SELECTIVE = "EZReports_JobsVsDatasets_selective";
    private static final String EZREP_QUERY_SELECTIVE_UCMDB = "EZReports_JobsVsDatasets_selective_ucmdb";

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
        this.reportTitle = Messages.getString(ReportBuilder.class, "report.title");
    }

    @Override
    protected void putExternalizedParameters(Map<String, Object> params) {
        super.putExternalizedParameters(params);
        String externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        params.put("sum3", null);
        params.put("sum4", null);
        externalized = Messages.getString(ReportBuilder.class, "summary");
        params.put("summary", externalized);
        params.put("sum1.1", this.UTILITY_GROUPSUMMARY_LABEL);
        params.put("utilityStmtName", this.UTILITY_COLUMN2_TEXT);
        params.put("sum1.2", this.UNKNOWNPROGRAM_GROUPSUMMARY_LABEL);
        params.put("unknownProgramText", this.LOADMODULE_COLUMN2_TEXT);
    }

    protected String getProcedure() {
        return EZREP_QUERY;
    }

    protected String getSelectiveProcedure() {
        boolean vb;
        Object selectedApps = this.report.getProperty("filtered by app");
        boolean bl = vb = this.isMultiApp() && selectedApps != null && (Boolean)selectedApps != false;
        if (vb) {
            return EZREP_QUERY_SELECTIVE_UCMDB;
        }
        return EZREP_QUERY_SELECTIVE;
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        ReportDataSource ds = (ReportDataSource)super.getDataSource(pmonitor);
        ds.setDomainAxisLabel(Messages.getString(ReportBuilder.class, "stackedBar.domainAxis.lbl"));
        ds.setStackedBarTitle(Messages.getString(ReportBuilder.class, "stackedBar.title"));
        return ds;
    }

    @Override
    protected List<Obj4Report> buildReportData(IProgressMonitor pmonitor, String[][] results, CSVWriter csvWriter) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)results.length);
        ArrayList<Obj4Report> result = new ArrayList<Obj4Report>();
        L.debug("JobsVsDatasets results:");
        boolean noStmt = true;
        String currentKey = null;
        int i = 0;
        while (i < results.length) {
            block20: {
                Integer countValue;
                HashSet<String> files;
                String key;
                String stmtType4Charts;
                WUTwoLevelsBuilder.AccessingType type;
                String prgPath;
                String memberName;
                Integer stmtCount;
                String stmtType;
                String prgName;
                String dataset;
                String jobName;
                block18: {
                    block19: {
                        block17: {
                            boolean hasAncestor;
                            String[] row = results[i];
                            results[i] = null;
                            jobName = row[0];
                            dataset = row[1];
                            String dsMemberName = row[8];
                            if (dsMemberName != null && !dsMemberName.isEmpty()) {
                                dataset = String.valueOf(dataset) + "(" + dsMemberName + ")";
                            }
                            prgName = row[2];
                            String ancestor = row[3];
                            stmtType = row[4];
                            stmtCount = new Integer(row[5]);
                            memberName = row.length > 6 ? row[7] : null;
                            prgPath = row[9];
                            boolean bl = hasAncestor = ancestor != null && !ancestor.isEmpty();
                            if (hasAncestor) {
                                prgName = String.valueOf(ancestor) + ": " + prgName;
                            }
                            type = WUTwoLevelsBuilder.AccessingType.PROGRAM;
                            stmtType4Charts = "";
                            if (!"#EZ1#".equals(stmtType)) break block17;
                            stmtCount = new Integer(1);
                            noStmt = true;
                            if (Utils.isUtility((String)prgName)) {
                                stmtType = this.UTILITY_COLUMN2_TEXT;
                                stmtType4Charts = this.UTILITY_DETAIL_FIRSTCOLUMN_PART;
                                type = WUTwoLevelsBuilder.AccessingType.UTILITY;
                            } else {
                                stmtType = this.LOADMODULE_COLUMN2_TEXT;
                                stmtType4Charts = this.LOADMODULE_CHART_TEXT;
                                type = WUTwoLevelsBuilder.AccessingType.LOAD_MODULE;
                            }
                            break block18;
                        }
                        if (!"#EZ2#".equals(stmtType)) break block19;
                        if (Utils.isUtility((String)prgName)) break block20;
                        stmtCount = new Integer(1);
                        noStmt = true;
                        stmtType = this.LOADMODULE_COLUMN2_TEXT;
                        stmtType4Charts = this.UNKOWNPROGRAM_CHART_TEXT;
                        type = WUTwoLevelsBuilder.AccessingType.UNKNOWN_PROGRAM;
                        break block18;
                    }
                    noStmt = false;
                    stmtType4Charts = stmtType;
                }
                if (prgPath != null && !prgPath.isEmpty()) {
                    prgName = prgName.concat(" (").concat(prgPath).concat(")");
                }
                String string = key = memberName != null && !memberName.equalsIgnoreCase(jobName) ? String.valueOf(jobName) + " (" + memberName + ")" : jobName;
                if (currentKey != null && !key.equalsIgnoreCase(currentKey)) {
                    files = (HashSet<String>)this.usedResources.get(currentKey);
                    int count = 0;
                    if (files == null) {
                        L.warn("job without dataset?! {}", (Object)currentKey);
                    } else {
                        count = files.size();
                    }
                    this.usedResources.put(currentKey, count);
                    currentKey = key;
                } else {
                    currentKey = i == 0 ? key : currentKey;
                }
                files = (Set)this.usedResources.get(key);
                if (files == null) {
                    files = new HashSet<String>();
                    this.usedResources.put(key, files);
                }
                files.add(dataset.toUpperCase());
                HashMap<String, Integer> prgMap = (HashMap<String, Integer>)this.allResMap.get(key);
                if (prgMap == null) {
                    prgMap = new HashMap<String, Integer>();
                    this.allResMap.put(key, prgMap);
                }
                countValue = (countValue = (Integer)prgMap.get(stmtType4Charts)) == null ? stmtCount : new Integer(countValue + stmtCount);
                prgMap.put(stmtType4Charts, countValue);
                if (L.isDebugEnabled()) {
                    L.debug("job: {}", (Object)jobName);
                    L.debug("memberName: {}", (Object)memberName);
                    L.debug("dataset: {}", (Object)dataset);
                    L.debug("program: {}", (Object)prgName);
                    L.debug("stmt type: {}", (Object)stmtType);
                    L.debug("count: {}", (Object)stmtCount);
                    L.debug("\n");
                }
                Obj4Report obj = new Obj4Report();
                obj.level1 = key;
                obj.level1Type = JOB_GROUP_TYPE;
                obj.level2 = ReportsUtils.stripNonValidXMLCharacters((String)dataset, (boolean)true);
                obj.level2Type = Messages.getString(ReportBuilder.class, "detail.resourceType");
                obj.level3 = this.getColum1Text(prgName, type);
                obj.level2Tooltip = dataset;
                obj.setStmtType(noStmt ? stmtType : this.getColum2Text(stmtType, type));
                obj.setCount(noStmt ? 0 : stmtCount);
                result.add(obj);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{key, dataset, obj.level3, obj.getStmtType(), obj.getCount() == 0 ? "" : obj.getCount().toString()});
                }
                monitor.worked(1);
            }
            ++i;
        }
        if (currentKey != null) {
            Set files = (Set)this.usedResources.get(currentKey);
            int count = 0;
            if (files == null) {
                L.warn("last job without datasets?! {}", currentKey);
            } else {
                count = files.size();
            }
            this.usedResources.put(currentKey, count);
        }
        return result;
    }

    @Override
    protected AbstractReport instantiateReportModel() {
        return new ReportModel(this.project, this.getSelectionFlagFromInputs());
    }

    @Override
    protected String getUsedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(ReportBuilder.class, (String)"used.category.lbl");
    }

    @Override
    protected String getUnusedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(ReportBuilder.class, (String)"unused.category.lbl");
    }

    @Override
    protected String getPieTitle() {
        return Messages.getString(ReportBuilder.class, "pie1.title");
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.job"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.dataset"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.accessedBy"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.confirmed"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

