/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.includesVsPrograms;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.includesVsPrograms.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.includesVsPrograms.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.includesVsPrograms.ReportModel;
import com.ez.report.application.ezreport.reports.wu.programsVsIncludes.ItemComparator;
import com.ez.report.application.ezreport.reports.wu.programsVsIncludes.ItemCount;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String STORED_PROCEDURE = "EZReports_IncludesVsPrograms";
    private static final String STORED_PROCEDURE_SELECTIVE = "EZReports_IncludesVsPrograms_Selective";
    private static final String STORED_PROCEDURE_UCMDB = "EZReports_IncludesVsPrograms_UCMDB";
    private static final String STORED_PROCEDURE_SELECTIVE_UCMDB = "EZReports_IncludesVsPrograms_UCMDB_Selective";
    private Map includesCalledInProgs = null;
    Map includeCountsMap = null;

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.resultList = new ArrayList();
        this.includesCalledInProgs = new HashMap();
        this.includeCountsMap = new HashMap();
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
        }
        ReportDataSource dataSource = new ReportDataSource(this.resultList);
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            Collection allResrs;
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            Collection selected = (Collection)this.inputs.get("selected resources");
            this.report.setInput((Object)selected);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", selectedApps);
            if (selectedApps != null) {
                Collection appNames = (Collection)this.inputs.get("selected applications names");
                for (ProgramInputNoGUI prg : selected) {
                    prg.setApplicationsName((Set)appNames);
                }
            }
            if ((allResrs = (Collection)this.inputs.get("available resources")) != null) {
                this.report.addProperty("totalResources", (Object)allResrs.size());
            }
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum1");
        params.put("report.sum1.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum2");
        params.put("report.sum2.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum3");
        params.put("report.sum3.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum4");
        params.put("report.sum4.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum5");
        params.put("report.sum5.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "group1.name");
        params.put("group1.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "group.summary");
        params.put("group1.summary", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum1");
        params.put("group.sum1", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("group.sum2", externalized);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/usedIncludes.jasper";
    }

    private void clearForJasperReport() {
        this.includeCountsMap.clear();
        this.includesCalledInProgs.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    protected String getProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return STORED_PROCEDURE_UCMDB;
        }
        return STORED_PROCEDURE;
    }

    protected String getSelectiveProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return STORED_PROCEDURE_SELECTIVE_UCMDB;
        }
        return STORED_PROCEDURE_SELECTIVE;
    }

    private String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        this.clearForJasperReport();
        int prgUsingIncl = 0;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "compute.taskName"));
        SingleQueryResult queryResult = this.queryForData(pmonitor, EZSourceDataType.String);
        String[][] results = queryResult.data;
        int allPrgNo = queryResult.resourcesCount;
        this.parameters.put("report.sum1", String.valueOf(allPrgNo));
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.buildInputs4Appendix(prgList);
        this.parameters.put("title.appFieldValues", this.applicationsName);
        if (results == null) {
            L.warn("no results for IncludesVsPrograms report");
            this.parameters.put("report.sum2", String.valueOf(0));
        } else {
            L.debug("IncludesVsPrograms results:");
            String currentInclude = null;
            int count = 0;
            int allCount = 0;
            HashSet<String> includes = new HashSet<String>();
            HashSet<String> programs = new HashSet<String>();
            String currentAncestor = null;
            int i = 0;
            while (i < results.length) {
                String inclName = results[i][0];
                String progName = results[i][1];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][2]));
                String parentName = results[i][3];
                String prgPath = results[i][4];
                if ((parentName = Utils.filterNullValue((String)parentName)) != null && !parentName.isEmpty()) {
                    progName = String.valueOf(parentName) + ": " + progName;
                }
                String listableName = progName;
                if (prgPath != null) {
                    listableName = listableName.concat(" (").concat(prgPath).concat(")");
                }
                if (currentInclude == null) {
                    currentInclude = inclName;
                    currentAncestor = parentName != null && !parentName.isEmpty() ? parentName : progName;
                    ++count;
                } else if (!currentInclude.equalsIgnoreCase(inclName)) {
                    this.includesCalledInProgs.put(currentInclude, new ItemCount(count, allCount));
                    if (count > 1) {
                        // empty if block
                    }
                    currentInclude = inclName;
                    currentAncestor = parentName != null && !parentName.isEmpty() ? parentName : progName;
                    count = 1;
                } else {
                    String ancestor;
                    String string = ancestor = parentName != null && !parentName.isEmpty() ? parentName : progName;
                    if (!currentAncestor.equalsIgnoreCase(ancestor)) {
                        ++count;
                        currentAncestor = ancestor;
                    }
                }
                if (i == results.length - 1) {
                    this.includesCalledInProgs.put(currentInclude, new ItemCount(count, allCount));
                }
                L.debug("include:" + inclName);
                L.debug("program:" + listableName);
                L.debug("count:" + stmtCount);
                L.debug("\n");
                Obj4Report obj = new Obj4Report();
                obj.setIncludeName(inclName);
                obj.setProgramName(listableName);
                obj.setCount(stmtCount);
                obj.setDistinctPrgCount(count);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{inclName, listableName, stmtCount.toString()});
                }
                includes.add(inclName);
                programs.add(results[i][3] != null && !results[i][3].isEmpty() ? results[i][3] : results[i][1]);
                this.resultList.add(obj);
                ++i;
            }
            includes.size();
            prgUsingIncl = programs.size();
            programs = null;
            includes = null;
            this.parameters.put("report.sum2", String.valueOf(prgUsingIncl));
        }
        if (this.includesCalledInProgs.size() > 0) {
            String titleStr = Messages.getString(ReportBuilder.class, "bar.title");
            String subtitle = null;
            DefaultCategoryDataset ds = this.buildDataSet();
            if (this.includesCalledInProgs.keySet().size() >= 20) {
                Object[] msgParams = new String[]{String.valueOf(20)};
                titleStr = titleStr.concat(" ").concat(Messages.getString(ReportBuilder.class, "bar.title.1", msgParams));
                if (this.countsSame != 0) {
                    msgParams = new String[]{String.valueOf(this.countsSame)};
                    titleStr = titleStr.concat("*");
                    subtitle = Messages.getString(ReportBuilder.class, "bar.subtitle", msgParams);
                }
            }
            String xAxis = Messages.getString(ReportBuilder.class, "bar.category.axis");
            String yAxis = Messages.getString(ReportBuilder.class, "bar.value.axis");
            this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(ds, titleStr, xAxis, yAxis, 880, 640, this.BLUE_COLOR, subtitle));
        }
        this.parameters.put("breakPrgGroup", new Boolean(false));
        monitor.setWorkRemaining(0);
        return results;
    }

    private DefaultCategoryDataset buildDataSet() {
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        ArrayList prgrList = new ArrayList(this.includesCalledInProgs.keySet());
        ItemComparator pComparator = new ItemComparator();
        pComparator.setMapWithCounts(this.includesCalledInProgs);
        Collections.sort(prgrList, pComparator);
        int i = 0;
        int prag = 0;
        this.countsSame = 0;
        boolean endOfBars = false;
        int sum = 0;
        for (String prg : prgrList) {
            ItemCount nr = (ItemCount)this.includesCalledInProgs.get(prg);
            if (i < 20) {
                ds.addValue((double)nr.differentInclude, (Comparable)((Object)Messages.getString(ReportBuilder.class, "different.access.lbl")), (Comparable)((Object)prg));
                prag = nr.differentInclude;
            } else if (!endOfBars) {
                if (prag == nr.differentInclude) {
                    ++this.countsSame;
                } else {
                    endOfBars = true;
                }
            }
            sum += nr.differentInclude;
            ++i;
        }
        if (i > 0) {
            double average = new BigDecimal(sum).divide(new BigDecimal(i), 2, 6).doubleValue();
            L.debug("average: " + average + " --- for sum=" + sum + " of " + i + " programs");
            this.parameters.put("report.sum5", String.valueOf(average));
        } else {
            L.debug("no programs in this project!!! (i=" + i + ", sum=" + sum + ")");
            this.parameters.put("report.sum5", String.valueOf(0));
        }
        return ds;
    }

    protected String prepareAppendixResrsList(Set prgList) {
        String ret = "";
        ret = ret.concat(prgList.toString());
        Object selectedApps = this.report.getProperty("filtered by app");
        boolean projectIsUCMDB = (Boolean)this.inputs.get("project_isUCMDB");
        if (selectedApps != null && ((Boolean)selectedApps).booleanValue() && projectIsUCMDB) {
            Set apps = null;
            Iterator iterator = prgList.iterator();
            while (iterator.hasNext() && apps == null) {
                ProgramInputNoGUI prg = (ProgramInputNoGUI)iterator.next();
                if (prg.getApplications() == null || prg.getApplications().isEmpty()) continue;
                apps = prg.getApplications();
            }
            if (apps != null && !apps.isEmpty()) {
                ret = ret.concat("\n");
                ret = ret.concat(Messages.getString(ReportBuilder.class, "appendix.applications.part")).concat(apps.toString());
                this.setApplicationName(apps);
            }
        }
        return ret;
    }

    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        return (Integer)this.report.getProperty("totalResources");
    }

    @Override
    public void cleanMemory() {
        if (this.includeCountsMap != null) {
            this.includeCountsMap.clear();
            this.includeCountsMap = null;
        }
        if (this.includesCalledInProgs != null) {
            this.includesCalledInProgs.clear();
            this.includesCalledInProgs = null;
        }
        if (this.resultList != null) {
            this.resultList.clear();
            this.resultList = null;
        }
        super.cleanMemory();
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.include"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

