/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegment;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentCollector;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentReportDS;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentsReportAbstractBuilder;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class IMSSegmentsVsProgramsReportBuilder
extends IMSSegmentsReportAbstractBuilder {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    Collection selected;

    public IMSSegmentsVsProgramsReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    protected String getUsedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(IMSSegmentsVsProgramsReportBuilder.class, (String)"used.category.lbl");
    }

    @Override
    protected String getUnusedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(IMSSegmentsVsProgramsReportBuilder.class, (String)"unused.category.lbl");
    }

    @Override
    protected String getUsedCategoryLabel() {
        return Messages.getString(IMSSegmentsVsProgramsReportBuilder.class, "using.lbl");
    }

    @Override
    protected String getUnusedCategoryLabel() {
        return Messages.getString(IMSSegmentsVsProgramsReportBuilder.class, "notUsing.lbl");
    }

    @Override
    protected String getPieTitle() {
        return Messages.getString(IMSSegmentsVsProgramsReportBuilder.class, "pie.title");
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        super.putExternalizedParameters(params);
        Boolean bySegments = (Boolean)this.getReportModel().getProperty("FILTERED_SEGMENTS");
        Collection selectedInpts = (Collection)(bySegments != null && bySegments != false ? this.getSelected() : this.getReportModel().getProperty("selected_databases"));
        this.buildInputs4Appendix(new HashSet(selectedInpts));
    }

    @Override
    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        Boolean bySegments = (Boolean)this.getReportModel().getProperty("FILTERED_SEGMENTS");
        String msgKey = bySegments != null && bySegments != false ? "appendix.segmentlist.label" : "appendix.databaselist.label";
        String value = Messages.getString(IMSSegmentsVsProgramsReportBuilder.class, msgKey);
        params.put("resourcesSummary", value);
    }

    @Override
    protected void instantiateDS(SubMonitor monitor, Collection selected, CSVWriter csvWriter) {
        this.ds = new IMSSegmentReportDS((IProgressMonitor)monitor.newChild(90), selected, this, csvWriter);
    }

    @Override
    protected int getInputsNo(IProgressMonitor pMonitor) {
        int resNo = 0;
        Boolean bySegments = (Boolean)this.getReportModel().getProperty("FILTERED_SEGMENTS");
        resNo = bySegments != null && bySegments != false ? this.getSelectedInputs(pMonitor).size() : ((List)this.getReportModel().getProperty("selected_databases")).size();
        return resNo;
    }

    @Override
    protected List getSelectedInputs(IProgressMonitor pmonitor) {
        if (this.selected == null) {
            this.selected = new ArrayList();
            pmonitor.subTask(Messages.getString(IMSSegmentsVsProgramsReportBuilder.class, "monitor.collectingSegments.subtask"));
            Boolean bySegments = (Boolean)this.getReportModel().getProperty("FILTERED_SEGMENTS");
            if (bySegments != null && bySegments.booleanValue()) {
                for (IMSSegment object : this.getSelected()) {
                    this.selected.add(object.getResourceID());
                }
            } else {
                final IMSSegmentCollector sgCollector = (IMSSegmentCollector)((Object)this.getReportModel().getProperty("segmentcollector"));
                sgCollector.setDatabaseIds((List)this.getReportModel().getProperty("selected_databases"));
                IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
                try {
                    ph.executeWithLock(ph, new IMFRunnable(){

                        public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                            List<IMSSegment> segments = sgCollector.collect(false, null, conn);
                            if (segments != null) {
                                for (IMSSegment object : segments) {
                                    IMSSegmentsVsProgramsReportBuilder.this.selected.add(object.getResourceID());
                                }
                            }
                        }
                    }, LockType.Shared, pmonitor);
                }
                catch (InterruptedException interruptedException) {
                    throw new CanceledException("connection interrupted");
                }
                catch (ExecutionException e) {
                    ErrorUtils.handleExecutionException((ExecutionException)e);
                }
                this.getReportModel().addProperty("segmentcollector", null);
                pmonitor.subTask("");
            }
        }
        return (List)this.selected;
    }

    @Override
    protected void customizeJasperPrint(JasperPrint print) {
        List pages;
        if (print != null && (pages = print.getPages()) != null && pages.size() > 0) {
            ReportsUtils.removeEmptyPages((List)pages, (String)"IMS Segments Vs Programs", (boolean)true);
        }
    }

    @Override
    protected AbstractReport buildReportModel() {
        ReportModel report = new ReportModel(this.project, false);
        Object selectedSegments = this.inputs.get("selected_segments");
        report.setInput(selectedSegments);
        report.addProperty("FILTERED_SEGMENTS", selectedSegments != null);
        report.addProperty("selected_databases", this.inputs.get("selected_databases"));
        report.addProperty("segmentcollector", this.inputs.remove("segmentcollector"));
        return report;
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(IMSSegmentsVsProgramsReportBuilder.class, "report.title"));
            csv.write(new String[]{Messages.getString(IMSSegmentsVsProgramsReportBuilder.class, "csv.header.input"), Messages.getString(IMSSegmentsVsProgramsReportBuilder.class, "csv.header.program"), Messages.getString(IMSSegmentsVsProgramsReportBuilder.class, "csv.header.statement"), Messages.getString(IMSSegmentsVsProgramsReportBuilder.class, "csv.header.accessedBy"), Messages.getString(IMSSegmentsVsProgramsReportBuilder.class, "csv.header.occurrences")});
        }
    }

    @Override
    public void cleanMemory() {
        if (this.selected != null) {
            this.selected.clear();
            this.selected = null;
        }
        super.cleanMemory();
    }
}

