/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms;

import com.ez.common.ui.listselection.Listable;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceIMSDBSegment;
import com.ez.internal.analysis.config.inputs.EZSourceIMSDatabase;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.preferences.PreferenceUtils;
import com.ez.mainframe.reports.gui.wizard.GenericSelectInputPage4Report;
import com.ez.report.application.ezreport.reports.wu.WUAbstractAnalysis;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSDBInput;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSDatabaseCollector;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegment;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentCollector;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentReportWizard;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentsVsProgramsJob;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentsWizardDialog;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceIMSDBSegmentIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMSSegmentsVsProgramsAnalysis
extends WUAbstractAnalysis {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(IMSSegmentsVsProgramsAnalysis.class);
    static final String SEGMENT_COLLECTOR_KEY = "segmentcollector";
    static final String FILTERED_BY_SEGMENTS = "FILTERED_SEGMENTS";
    private IMSSegmentCollector sgCollector;

    public IMSSegmentsVsProgramsAnalysis() {
        this(null);
    }

    public IMSSegmentsVsProgramsAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    public void setInputs(List inputs) {
        if (inputs != null) {
            if (inputs.size() > 0 && inputs.get(0) instanceof EZSourceProjectInputType) {
                super.setInputs(inputs);
            } else {
                ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
                this.params = new HashMap();
                ArrayList<IMSDBInput> sel = new ArrayList<IMSDBInput>();
                HashSet<String> inputNames = new HashSet<String>();
                boolean bySegments = false;
                for (Object inpObj : inputs) {
                    if (!(inpObj instanceof EZSourceIMSDBSegment) && !(inpObj instanceof EZSourceIMSDatabase)) continue;
                    EZEntityID entity = ((EZObjectType)inpObj).getEntID();
                    list.add(entity);
                    EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
                    if (prjSg == null) continue;
                    if (!prjSg.getProjectName().equals(this.projectName)) {
                        this.setPrjName(prjSg.getProjectName());
                        this.addContextValue("input_project_names", prjSg.getProjectName());
                    }
                    this.addContextValue("input_project_names", prjSg.getProjectName());
                    if (inpObj instanceof EZSourceIMSDatabase) {
                        EZSourceIMSDatabase inpObjDb = (EZSourceIMSDatabase)inpObj;
                        Integer id = (Integer)inpObjDb.getProperty("IMSDB_DATABASE_ID");
                        String dbName = inpObjDb.getName();
                        sel.add(new IMSDBInput(dbName, (Integer)inpObjDb.getProperty("IMSDB_DATABASE_TYPE"), id));
                        inputNames.add(dbName);
                        continue;
                    }
                    bySegments = true;
                    EZSourceIMSDBSegmentIDSg imsSg = (EZSourceIMSDBSegmentIDSg)entity.getSegment(EZSourceIMSDBSegmentIDSg.class);
                    String name = imsSg.getIMSDbSegmentName();
                    Integer sid = imsSg.getSegmentID();
                    if (sid != null) {
                        IMSSegment imsSegm = new IMSSegment(name, 0);
                        imsSegm.setResourceID(sid);
                        if (imsSg.getDBDName() != null) {
                            imsSegm.database = new IMSDBInput(imsSg.getDBDName(), 0, null);
                        }
                        sel.add(imsSegm);
                        inputNames.add(imsSegm.getListableName());
                        continue;
                    }
                    L.warn("segment without sid; analysis not implemented!");
                }
                if (!sel.isEmpty()) {
                    this.params = new HashMap();
                    this.params.put("project_name", this.projectName);
                    this.params.put("report_model", this.report);
                    if (bySegments) {
                        this.params.put("selected_segments", sel);
                    } else {
                        this.params.put("selected_databases", sel);
                    }
                    this.params.put("show summary only", Boolean.FALSE);
                    Boolean showAppendix = PreferenceUtils.getPreferenceStore().getBoolean("showAppendix");
                    this.params.put("show appendix", showAppendix);
                    Boolean showInputs = PreferenceUtils.getPreferenceStore().getBoolean("showInputDetails");
                    this.params.put("showInputDetails", showInputs);
                    this.params.put("all resources selected", Boolean.FALSE);
                    this.addAllContextValues(this.params);
                    this.addContextValue("input_list", list);
                    this.addContextValue("inputs name string", inputNames);
                }
            }
        }
    }

    @Override
    protected PrepareReportWizard getWizard() {
        IMSSegmentReportWizard wizard = new IMSSegmentReportWizard();
        IMSWizardPage selectDBPage = new IMSWizardPage("databases_page");
        selectDBPage.setLeftGroupLabel(Messages.getString(IMSSegmentsVsProgramsAnalysis.class, "av.objectType.database"));
        selectDBPage.setRightGroupLabel(Messages.getString(IMSSegmentsVsProgramsAnalysis.class, "sel.objectType.database"));
        selectDBPage.setSelectedPropName("selected_databases");
        selectDBPage.setResourcesCollector((ResourcesCollector)new IMSDatabaseCollector());
        wizard.addPage((IWizardPage)selectDBPage);
        GenericSelectInputPage4Report selectSegmentPage = new GenericSelectInputPage4Report("segments_page", true);
        selectSegmentPage.setLeftGroupLabel(Messages.getString(IMSSegmentsVsProgramsAnalysis.class, "av.objectType.segment"));
        selectSegmentPage.setRightGroupLabel(Messages.getString(IMSSegmentsVsProgramsAnalysis.class, "sel.objectType.segment"));
        selectSegmentPage.setSelectedPropName("selected_segments");
        this.sgCollector = new IMSSegmentCollector();
        selectSegmentPage.setResourcesCollector((ResourcesCollector)this.sgCollector);
        wizard.addPage((IWizardPage)selectSegmentPage);
        String wizardName = Messages.getString(IMSSegmentsVsProgramsAnalysis.class, "wizard.title");
        wizard.setWindowTitle(wizardName);
        return wizard;
    }

    @Override
    protected ReportWizardDialog getWizardDialog(PrepareReportWizard wiz, Shell shell) {
        IMSSegmentsWizardDialog dialog = new IMSSegmentsWizardDialog(shell, (IWizard)wiz);
        return dialog;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(id, IMSSegmentsVsProgramsJob.class);
        }
        this.params.put(SEGMENT_COLLECTOR_KEY, this.sgCollector);
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_MAINFRAME_REPORT_IMSSEGMENT_VS_PROGRAMS_ANALYSIS;
    }

    @Override
    protected boolean resourcesEquals(Map<String, Object> params1, Map<String, Object> params2) {
        boolean ret = false;
        List lst1 = (List)params1.get("selected_segments");
        List lst2 = (List)params2.get("selected_segments");
        if (lst1 != null) {
            ret = lst1.equals(lst2);
        } else {
            boolean bl = ret = lst2 == null;
            if (ret) {
                lst1 = (List)params1.get("selected_databases");
                lst2 = (List)params2.get("selected_databases");
                ret = lst1 != null ? lst1.equals(lst2) : lst2 == null;
            }
        }
        return ret;
    }

    @Override
    protected void completeSelectedPrograms(PrepareReportWizard wizard) {
        List sel = wizard.getList("selected_segments");
        if (sel == null) {
            sel = wizard.getList("selected_databases");
        }
        if (sel != null) {
            HashSet<String> inputNames = new HashSet<String>();
            for (IMSDBInput ji : sel) {
                inputNames.add(ji.getListableName());
            }
            this.addContextValue("inputs name string", inputNames);
        }
    }

    class IMSWizardPage
    extends GenericSelectInputPage4Report<Listable> {
        public IMSWizardPage(String pageName) {
            super(pageName, true);
            this.showReportsOptionGroup = false;
        }
    }
}

