/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.NonBlockingOperationHandle;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUDataSource;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentsReportAbstractBuilder;
import com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IMSSegmentsReportAbstractDS
extends WUDataSource {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(IMSSegmentsReportAbstractDS.class);
    protected String stackedBarTitle;
    protected String domainAxisLabel;
    protected String rangeAxisLabel;
    protected NonBlockingOperationHandle handler;
    protected EZSourceConnection connection;
    protected IProgressMonitor monitor;
    private int i = 0;
    private Set<Integer> selectedInputs = new HashSet<Integer>();
    protected List<String[]> resultPool = new ArrayList<String[]>();
    private List<Obj4Report> toPrint = new ArrayList<Obj4Report>();
    protected Obj4Report currentObj = null;
    protected Map<String, Map<String, Integer>> allOccurences = new HashMap<String, Map<String, Integer>>();
    protected Map<String, Object> stmtOccurences = new HashMap<String, Object>();
    private String currentLevel1ID = null;
    private String currentLevel1Name = null;
    private String currentLevel2ID = null;
    private String currentLevel2Name = null;
    Obj4Report prevObj;
    private Set<String> usedSegmIds = new HashSet<String>();
    protected IMSSegmentsReportAbstractBuilder builder;
    protected CSVWriter csvWriter;

    public IMSSegmentsReportAbstractDS(IProgressMonitor pmonitor, Collection inputs, IMSSegmentsReportAbstractBuilder reportBuilder, CSVWriter csvWriter) {
        this.selectedInputs = new HashSet<Integer>(inputs);
        this.builder = reportBuilder;
        this.csvWriter = csvWriter;
        this.monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)this.selectedInputs.size());
        this.stackedBarTitle = this.getStackedBarTitle();
        this.domainAxisLabel = this.getStackedBarAxisLabel();
        this.rangeAxisLabel = this.getStackedBarRangeLabel();
    }

    protected abstract String getStackedBarTitle();

    protected abstract String getStackedBarAxisLabel();

    protected abstract String getStackedBarRangeLabel();

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (!field.getName().equalsIgnoreCase("printColsHeader") && !field.getName().equalsIgnoreCase("printGroupHeader")) {
            value = this.currentObj.get(field.getName());
        }
        return value;
    }

    public boolean nextItem() throws JRException {
        if (this.i == 0) {
            this.monitor.subTask(Messages.getString(IMSSegmentsReportAbstractDS.class, "monitor.getFirstData.subtask"));
            this.getFirstElement();
            this.i = 1;
        }
        if (this.toPrint.isEmpty()) {
            this.fillReport();
        }
        Obj4Report obj4Report = this.currentObj = this.toPrint.isEmpty() ? null : this.toPrint.remove(0);
        if (this.currentObj == null) {
            this.builder.buildSummaryStackBar(this.stmtOccurences, this.usedSegmIds.size(), this.monitor);
            this.closeOperation();
        }
        return this.currentObj != null;
    }

    private boolean fillReport() {
        boolean moreData = true;
        if (this.resultPool.size() == 0) {
            moreData = this.getData();
        }
        this.prevObj = this.currentObj;
        if (moreData) {
            this.monitor.subTask(Messages.getString(IMSSegmentsReportAbstractDS.class, "monitor.fillReport.subtask"));
            while (!this.resultPool.isEmpty()) {
                String fieldForCharts;
                Integer countValue;
                String[] row = this.resultPool.remove(0);
                boolean newgroup = false;
                String lev1ID = this.getLevel1Discriminator(row);
                if (!lev1ID.equals(this.currentLevel1ID) && this.prevObj != null) {
                    newgroup = true;
                    DefaultCategoryDataset ds = this.getCountBarDataset(this.allOccurences, this.currentLevel1ID);
                    Image img = this.createStackedBar(ds, this.stackedBarTitle, this.domainAxisLabel, this.rangeAxisLabel, 1020, 600);
                    this.prevObj.setBarImg(img);
                    this.monitor.worked(1);
                }
                Obj4Report obj = this.buildObj4Report(row);
                if (newgroup && obj.level1.equals(this.currentLevel1Name)) {
                    obj.level1 = String.valueOf(obj.level1) + " (id=" + lev1ID + ")";
                }
                if (!newgroup && this.prevObj != null && !obj.level1.equals(this.currentLevel1Name)) {
                    obj.level1 = this.currentLevel1Name;
                }
                this.currentLevel1Name = obj.level1;
                if (obj.level2.equalsIgnoreCase(this.currentLevel2Name) && !this.getLevel2Discriminator(row).equals(this.currentLevel2ID)) {
                    obj.level2 = String.valueOf(obj.level2) + " (" + this.getLevel2Discriminator(row) + ")";
                }
                if (this.getLevel2Discriminator(row).equals(this.currentLevel2ID)) {
                    obj.level2 = this.currentLevel2Name;
                }
                this.currentLevel2Name = obj.level2;
                this.toPrint.add(obj);
                Integer stmtCount = obj.getCount();
                HashMap<String, Integer> sgmOccurences = (HashMap<String, Integer>)this.allOccurences.get(lev1ID);
                if (sgmOccurences == null) {
                    sgmOccurences = new HashMap<String, Integer>();
                    this.allOccurences.put(lev1ID, sgmOccurences);
                }
                countValue = (countValue = (Integer)sgmOccurences.get(fieldForCharts = this.getField4Charts(obj))) == null ? stmtCount : new Integer(countValue + stmtCount);
                sgmOccurences.put(fieldForCharts, countValue);
                Integer stmtC = (Integer)this.stmtOccurences.get(fieldForCharts);
                stmtC = stmtC == null ? stmtCount : new Integer(stmtC + stmtCount);
                this.stmtOccurences.put(fieldForCharts, stmtC);
                this.usedSegmIds.add(lev1ID);
                this.prevObj = obj;
                this.currentLevel1ID = lev1ID;
                this.currentLevel2ID = this.getLevel2Discriminator(row);
            }
        }
        if (this.prevObj != null && this.prevObj.getBarImg() == null) {
            DefaultCategoryDataset ds = this.getCountBarDataset(this.allOccurences, this.currentLevel1ID);
            Image img = this.createStackedBar(ds, this.stackedBarTitle, this.domainAxisLabel, this.rangeAxisLabel, 1020, 600);
            this.prevObj.setBarImg(img);
        }
        return moreData;
    }

    protected abstract Obj4Report buildObj4Report(String[] var1);

    protected abstract String getLevel1Discriminator(String[] var1);

    protected abstract String getLevel2Discriminator(String[] var1);

    protected abstract String getField4Charts(Obj4Report var1);

    private void getFirstElement() {
        EZSourceConnectionException ex = null;
        try {
            try {
                String[] procParam = new String[]{};
                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[this.selectedInputs.size()]);
                Collections.fill(types, EZSourceDataType.Integer);
                String selectiveProc = this.getProcedureName();
                Assert.isNotNull((Object)selectiveProc);
                this.handler = this.connection.beginNonTransactionalStoredProc(selectiveProc, procParam, types, new ArrayList<Integer>(this.selectedInputs), 100);
            }
            catch (EZSourceConnectionException e) {
                L.error("exception at getting first element of datasource", (Throwable)e);
                EZReportErrorLog.err(Messages.getString(IMSSegmentsReportAbstractDS.class, "storedProcedureError.logMessage"), e);
                ex = e;
                L.trace("begin finally");
                if (this.connection != null && (ex != null || this.handler.finished())) {
                    this.closeOperation();
                }
                L.trace("end finally");
            }
        }
        finally {
            L.trace("begin finally");
            if (this.connection != null && (ex != null || this.handler.finished())) {
                this.closeOperation();
            }
            L.trace("end finally");
        }
    }

    protected abstract String getProcedureName();

    protected boolean getData() {
        List rows = null;
        if (rows == null && this.handler.dataAvailable()) {
            L.debug("get more data");
            this.monitor.subTask(Messages.getString(IMSSegmentsReportAbstractDS.class, "monitor.getMoreData.subtask"));
            rows = this.handler.getAvailableData();
        }
        if (rows != null) {
            this.resultPool.addAll(rows);
        }
        return rows != null;
    }

    public void closeDatasource() {
        this.monitor.subTask(Messages.getString(IMSSegmentsReportAbstractDS.class, "monitor.closeConn.subtask"));
        this.closeOperation();
        this.monitor.subTask("");
        this.monitor.done();
    }

    protected void closeOperation() {
        L.trace("begin of closeOp");
        if (this.handler != null) {
            this.handler.close();
            L.trace("after close handler");
        }
        if (this.csvWriter != null) {
            this.csvWriter.close();
        }
        this.prevObj = null;
    }

    public void setConnection(EZSourceConnection conn) {
        this.connection = conn;
    }

    protected String getListableSegmentName(String dbName, String segmentName) {
        return Messages.getString(IMSSegmentsReportAbstractDS.class, "segment.listablename", new String[]{dbName, segmentName});
    }
}

