/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentsReportAbstractDS;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.SummaryHolder;
import com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.twolevels.WUTwoLevelsBuilder;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.utils.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IMSSegmentsReportAbstractBuilder
extends WUTwoLevelsBuilder {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(IMSSegmentsReportAbstractBuilder.class);
    private static final String USAGE_PIE_PARAM_NAME = "usagePie";
    private static final String SUMM_HOLDER_PARAM_NAME = "summHolder";

    public IMSSegmentsReportAbstractBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    protected String getInputTypeName() {
        return null;
    }

    protected void putExternalizedParameters(Map params) {
        this.parameters.put(SUMM_HOLDER_PARAM_NAME, new SummaryHolder());
        String externalized = Messages.getString(((Object)((Object)this)).getClass(), "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "details.column1.name");
        params.put("column1.name", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "details.column2.name");
        params.put("column2.name", externalized);
        externalized = Messages.getString(IMSSegmentsReportAbstractBuilder.class, "details.column3.name");
        params.put("column3.name", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "details.summary.title");
        params.put("summary", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "details.summary.entry1");
        params.put("sum1", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "details.summary.entry2");
        params.put("sum2", externalized);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/wuLevel2_lazySummary.jasper";
    }

    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        this.parameters.put("appendixFirstLineValue", String.valueOf(this.getInputsNo((IProgressMonitor)monitor.newChild(5))));
        CSVWriter csvWriter = this.doCSVInitOperations();
        this.instantiateDS(monitor, this.getSelectedInputs((IProgressMonitor)monitor.newChild(5)), csvWriter);
        return this.ds;
    }

    protected abstract void instantiateDS(SubMonitor var1, Collection var2, CSVWriter var3);

    protected abstract List getSelectedInputs(IProgressMonitor var1);

    protected abstract int getInputsNo(IProgressMonitor var1);

    protected void buildSummaryStackBar(Map<String, Object> stmtOccurences, int usedSegments, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        this.usedResources = stmtOccurences;
        SummaryHolder h = (SummaryHolder)this.parameters.get(SUMM_HOLDER_PARAM_NAME);
        monitor.subTask(Messages.getString(IMSSegmentsReportAbstractBuilder.class, "monitor.creatingFirstChart.subtask"));
        this.buildSummaryFirstChart(this.getSelectedInputs((IProgressMonitor)monitor.newChild(10)).size(), usedSegments);
        h.setFirstImage(this.parameters.get(USAGE_PIE_PARAM_NAME));
        monitor.worked(50);
        if (usedSegments > 0) {
            monitor.subTask(Messages.getString(IMSSegmentsReportAbstractBuilder.class, "monitor.creatingSecondChart.subtask"));
            this.buildSummaryStackBar();
            h.setSecondImage(this.parameters.get("progrVSFilesPie"));
            this.parameters.put("reportDetails", null);
        }
        monitor.subTask("");
        monitor.worked(50);
    }

    protected void buildSummaryFirstChart(int allSegmentsNo, int usedSegments) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        String usedCategory = this.getUsedCategoryLegendLabel();
        String unusedCategory = this.getUnusedCategoryLegendLabel();
        String not_using_category_lbl = this.getUnusedCategoryLabel();
        String using_category_lbl = this.getUsedCategoryLabel();
        dataset.setValue((Comparable)((Object)not_using_category_lbl), (Number)new Double(allSegmentsNo - usedSegments));
        dataset.setValue((Comparable)((Object)using_category_lbl), (Number)new Double(usedSegments));
        HashMap<String, String> formatsMap = new HashMap<String, String>();
        formatsMap.put(not_using_category_lbl, unusedCategory);
        formatsMap.put(using_category_lbl, usedCategory);
        this.parameters.put(USAGE_PIE_PARAM_NAME, this.createPieChartImage(dataset, formatsMap, this.getPieTitle(), 880, 540, null));
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = this.buildReportModel();
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected abstract AbstractReport buildReportModel();

    protected JasperPrint prepareDocument(JasperReport jReport, Map params, JRDataSource ds, IProgressMonitor monitor, IStatus status) {
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        RunWithLock runn = new RunWithLock(jReport, params, ds, monitor, status);
        try {
            ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, monitor);
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        return runn.print;
    }

    JasperPrint prepDocument(JasperReport jReport, Map params, JRDataSource ds, EZSourceConnection conn, IProgressMonitor monitor, IStatus status) {
        ((IMSSegmentsReportAbstractDS)this.ds).setConnection(conn);
        return super.prepareDocument(jReport, params, ds, monitor, status);
    }

    protected void initStopCode(IProgressMonitor monitor) {
        this.stopCode = new StopCode(monitor);
    }

    @Override
    protected List<Obj4Report> getDBData(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        return null;
    }

    class RunWithLock
    implements IMFRunnable {
        JasperPrint print;
        AbstractReportBuilder builder;
        JasperReport jReport;
        Map params;
        JRDataSource ds;
        IProgressMonitor monitor;
        IStatus status;

        public RunWithLock(JasperReport jReport, Map params, JRDataSource ds, IProgressMonitor monitor, IStatus status) {
            this.jReport = jReport;
            this.params = params;
            this.ds = ds;
            this.monitor = monitor;
            this.status = status;
        }

        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
            this.print = IMSSegmentsReportAbstractBuilder.this.prepDocument(this.jReport, this.params, this.ds, conn, this.monitor, this.status);
        }
    }

    class StopCode
    implements Runnable {
        private IProgressMonitor monitor;

        public StopCode(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void run() {
            if (this.monitor.isCanceled()) {
                L.trace("canceled; before close handler");
                if (IMSSegmentsReportAbstractBuilder.this.ds != null) {
                    IMSSegmentsReportAbstractBuilder.this.ds.closeDatasource();
                }
                L.trace("canceled; after close handler");
                IMSSegmentsReportAbstractBuilder.this.cleanMemory();
                L.trace("canceled; after clean memory");
                IMSSegmentsReportAbstractBuilder.this.canceled = true;
                throw new CanceledException("report canceled");
            }
        }
    }
}

