/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentsReportAbstractBuilder;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegmentsReportAbstractDS;
import com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;

public class IMSSegmentReportDS
extends IMSSegmentsReportAbstractDS {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public IMSSegmentReportDS(IProgressMonitor pmonitor, Collection inputs, IMSSegmentsReportAbstractBuilder reportBuilder, CSVWriter csvWriter) {
        super(pmonitor, inputs, reportBuilder, csvWriter);
    }

    @Override
    protected Obj4Report buildObj4Report(String[] row) {
        Obj4Report obj = new Obj4Report();
        obj.level1 = this.getListableSegmentName(row[1], row[3]);
        obj.level1Type = null;
        obj.level2 = Messages.getString(IMSSegmentReportDS.class, "details.program.groupname", new String[]{row[9]});
        obj.level2Type = null;
        obj.level3 = row[8];
        String acceessType = row[4] == null ? Messages.getString(IMSSegmentReportDS.class, "accessType.directly") : this.getListableSegmentName(row[5], row[7]);
        obj.setStmtType(acceessType);
        Integer stmtCount = new Integer(row[10]);
        obj.setCount(stmtCount);
        if (this.csvWriter != null) {
            this.csvWriter.write(new String[]{String.valueOf(row[1]) + ":" + row[3], row[9], row[8], row[4] == null ? "" : String.valueOf(row[5]) + ":" + row[7], obj.getCount().toString()});
        }
        return obj;
    }

    @Override
    protected String getStackedBarTitle() {
        return Messages.getString(IMSSegmentReportDS.class, "stackedBar.title");
    }

    @Override
    protected String getStackedBarAxisLabel() {
        return Messages.getString(IMSSegmentReportDS.class, "stackedBar.domainAxis.lbl");
    }

    @Override
    protected String getStackedBarRangeLabel() {
        return Messages.getString(IMSSegmentReportDS.class, "stackedBar.rangeAxis.lbl");
    }

    @Override
    protected String getLevel1Discriminator(String[] row) {
        return row[2];
    }

    @Override
    protected String getProcedureName() {
        return "EZViewer_IMSDBSegVsProgUsage";
    }

    @Override
    protected String getField4Charts(Obj4Report obj4Report) {
        return obj4Report.level3;
    }

    @Override
    protected String getLevel2Discriminator(String[] row) {
        return row[12] != null ? row[12] : row[11];
    }
}

