/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.ServerType;
import com.ez.mainframe.data.utils.Utils;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSDBInput;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSSegment;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMSSegmentCollector
extends BridgeResourcesCollectorAdapter<IMSSegment> {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(IMSSegmentCollector.class);
    protected String resourcesQuery = null;
    private Map<Integer, IMSDBInput> databaseIds = null;

    public List<ImageObj4Wizard> getAvailableImages() {
        return null;
    }

    protected List<IMSSegment> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<IMSSegment> sgList = null;
        try {
            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[this.databaseIds.size()]);
            Collections.fill(types, EZSourceDataType.Integer);
            ServerType dbEngine = conn.getProjectInfo().getDbEngine();
            String tempTableName = Utils.getTempTableName((ServerType)dbEngine, (String)"numeric_param_temp");
            String SELECTIVE_SEGMENTS_QUERY = String.format("SELECT SegmentId, SegmentName, DBId FROM IMSDBSegments WHERE IMSDBSegments.DBId in (select * from %s) ORDER BY SegmentName", tempTableName);
            String[][] results = conn.executeSQL(SELECTIVE_SEGMENTS_QUERY, types, new ArrayList<Integer>(this.databaseIds.keySet()));
            if (results != null && results.length > 0) {
                sgList = new ArrayList<IMSSegment>();
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] result = stringArray[n2];
                    Integer sgId = Integer.valueOf(result[0]);
                    String sgName = result[1];
                    Integer dbId = Integer.valueOf(result[2]);
                    IMSDBInput db = this.databaseIds.get(dbId);
                    db.getName();
                    IMSSegment job = new IMSSegment(sgName, (Integer)0, db);
                    job.setResourceID(sgId);
                    sgList.add(job);
                    ++n2;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return sgList;
    }

    public void setDatabaseIds(List<IMSDBInput> selectedDB) {
        this.databaseIds = new HashMap<Integer, IMSDBInput>();
        for (IMSDBInput input : selectedDB) {
            this.databaseIds.put(input.getResourceID(), input);
        }
    }
}

