/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.common.ui.listselection.ItemType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.report.application.ezreport.reports.wu.imssegmentsvsprograms.IMSDBInput;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMSDatabaseCollector
extends BridgeResourcesCollectorAdapter<IMSDBInput> {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(IMSDatabaseCollector.class);
    private static final String QUERY = "select IMSDBInfo.DBId, IMSDBInfo.DBName, IMSDBInfo.AccessTypeId from IMSDBInfo ORDER BY IMSDBInfo.DBName, IMSDBInfo.AccessTypeId";
    private static List<ImageObj4Wizard> imagesObjsList;

    public List<ImageObj4Wizard> getAvailableImages() {
        return imagesObjsList;
    }

    protected List<IMSDBInput> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<IMSDBInput> sgList = null;
        ArrayList<ItemType> availableTypes = new ArrayList<ItemType>();
        imagesObjsList = new ArrayList<ImageObj4Wizard>();
        try {
            String[][] results = conn.executeSQL(QUERY);
            if (results != null && results.length > 0) {
                sgList = new ArrayList<IMSDBInput>();
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] result = stringArray[n2];
                    Integer dbId = Integer.valueOf(result[0]);
                    String dbName = result[1];
                    Integer dbType = result[2] != null ? Integer.valueOf(result[2]) : 0;
                    int mappedType = Utils.getMappedType4IMSDatabase((Integer)dbType);
                    IMSDBInput db = new IMSDBInput(dbName, mappedType, dbId);
                    sgList.add(db);
                    ItemType wizType = new ItemType(Integer.valueOf(mappedType));
                    if (!availableTypes.contains(wizType)) {
                        String textType = Utils.getExternalizedType4IMSDatabase((Integer)mappedType);
                        ImageDescriptor image_desc = Utils.getImageDescType4IMSDatabase((Integer)mappedType);
                        ImageObj4Wizard imageObj = new ImageObj4Wizard(wizType, textType, image_desc);
                        availableTypes.add(wizType);
                        imagesObjsList.add(imageObj);
                    }
                    ++n2;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return sgList;
    }
}

