/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.idmsUtils;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.common.ui.listselection.ItemType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.report.application.ezreport.reports.wu.idmsUtils.IDMSInput;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.collectors.InputsCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDMSCollector
extends InputsCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(IDMSCollector.class);
    private Map<Integer, ImageObj4Wizard> prgTypes;

    public List<BaseResourceInput4GUI> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<BaseResourceInput4GUI> jobList = new ArrayList<BaseResourceInput4GUI>();
        try {
            String[][] results = conn.executeSQL(this.resourcesQuery);
            if (results != null && results.length > 0) {
                this.prgTypes = new TreeMap<Integer, ImageObj4Wizard>();
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] result = stringArray[n2];
                    String name = result[0];
                    Integer prgType = Integer.valueOf(result[1]);
                    IDMSInput job = new IDMSInput(name, prgType);
                    jobList.add((BaseResourceInput4GUI)new BaseMainframeResource4GUI((BaseResourceInput)job));
                    if (!this.prgTypes.containsKey(prgType)) {
                        ItemType wizType = ItemType.getItemType((Integer)prgType);
                        String textType = com.ez.mainframe.data.utils.Utils.getExternalizedType((Integer)prgType, (boolean)true);
                        ImageDescriptor image_desc = Utils.getImageDescType((Integer)prgType, (boolean)true);
                        ImageObj4Wizard imageObj = new ImageObj4Wizard(wizType, textType, image_desc);
                        this.prgTypes.put(prgType, imageObj);
                    }
                    ++n2;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return jobList;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        if (this.prgTypes != null) {
            return new ArrayList<ImageObj4Wizard>(this.prgTypes.values());
        }
        return null;
    }
}

