/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.idmsRecordsVsPrograms;

import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.idmsRecordsVsPrograms.Object4Report;
import com.ez.report.application.ezreport.reports.wu.idmsRecordsVsPrograms.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.idmsRecordsVsPrograms.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    protected Map allPrgMap = null;
    protected Map stmtCountMap = null;
    protected Map accesCountMap = null;

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.accesCountMap = new HashMap();
        this.allPrgMap = new HashMap();
        this.resultList = new ArrayList();
        this.stmtCountMap = new HashMap();
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(((Object)((Object)this)).getClass(), "collectingData.taskName"));
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
        }
        return this.buildReportDS();
    }

    protected AbstractReportDataSource buildReportDS() {
        boolean hideImages = (Boolean)this.getReportModel().getProperty("hide images");
        ReportDataSource dataSource = new ReportDataSource(this.resultList, this.allPrgMap, hideImages);
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            Boolean value;
            this.instantiateModel();
            Collection selected = (Collection)this.inputs.get("selected resources");
            this.report.setInput((Object)selected);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", selectedApps);
            if (selectedApps != null) {
                Collection appNames = (Collection)this.inputs.get("selected applications names");
                for (ProgramInputNoGUI prg : selected) {
                    prg.setApplicationsName((Set)appNames);
                }
            }
            this.report.addProperty("hide images", (Object)((value = (Boolean)this.inputs.get("hide images")) != null ? value : true));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void instantiateModel() {
        this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(((Object)((Object)this)).getClass(), "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "stmtType.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "summary");
        params.put("summary", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "sum4");
        params.put("sum4", externalized);
    }

    private void clearForJasperReport() {
        this.accesCountMap.clear();
        this.stmtCountMap.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    protected String getProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return "EZReports_IdmsRecordUsagePerProgram_UCMDB";
        }
        return "EZReports_IdmsRecordUsagePerProgram";
    }

    protected String getSelectiveProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return "EZReports_IdmsRecordUsagePerProgram_UCMDB_Selective";
        }
        return "EZReports_IdmsRecordUsagePerProgram_Selective";
    }

    private String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        String yAxis;
        String xAxis;
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(((Object)((Object)this)).getClass(), "compute.taskName"));
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        if (prgList != null) {
            List tmp = BaseResourceInput4GUI.extractNonGUIObjects((Collection)prgList);
            this.buildInputs4Appendix(new HashSet(tmp));
            this.parameters.put("title.appFieldValues", this.applicationsName);
        }
        SingleQueryResult queryResult = this.queryForData(pmonitor);
        String[][] results = queryResult.data;
        this.buildData4Report(results, csvWriter);
        if (this.stmtCountMap.size() > 0) {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            for (String stmtType : this.stmtCountMap.keySet()) {
                dataset.addValue((Number)((Integer)this.stmtCountMap.get(stmtType)), (Comparable)((Object)stmtType), (Comparable)((Object)stmtType));
            }
            String title = Messages.getString(((Object)((Object)this)).getClass(), "pie1.title");
            xAxis = Messages.getString(((Object)((Object)this)).getClass(), "firstbar.category.axis");
            yAxis = Messages.getString(((Object)((Object)this)).getClass(), "firstbar.value.axis");
            this.parameters.put("usagePie", this.createFirstStackedBar(dataset, title, xAxis, yAxis, 1000, 760));
        }
        if (this.accesCountMap.size() > 0) {
            String titleStr = Messages.getString(((Object)((Object)this)).getClass(), "pie2.title");
            DefaultCategoryDataset ds = this.buildDataSet(this.accesCountMap);
            String subtitle = null;
            if (this.accesCountMap.keySet().size() >= 20) {
                Object[] msgParams = new String[]{String.valueOf(20)};
                titleStr = titleStr.concat(" ").concat(Messages.getString(((Object)((Object)this)).getClass(), "bar.title", msgParams));
                if (this.countsSame != 0) {
                    msgParams = new String[]{String.valueOf(this.countsSame)};
                    titleStr = titleStr.concat("*");
                    subtitle = Messages.getString(((Object)((Object)this)).getClass(), "bar.subtitle", msgParams);
                }
            }
            xAxis = Messages.getString(((Object)((Object)this)).getClass(), "bar.category.axis");
            yAxis = Messages.getString(((Object)((Object)this)).getClass(), "bar.value.axis");
            this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(ds, titleStr, xAxis, yAxis, 1000, 620, null, subtitle));
        }
        monitor.setWorkRemaining(0);
        return results;
    }

    @Override
    protected String getSubreportTemplate1() {
        return "reports/usedFilesInitialBars.jasper";
    }

    protected void buildData4Report(String[][] results, CSVWriter csvWriter) {
        if (results == null) {
            L.warn("no results for IdmsRecordUsagePerProgram report");
        } else {
            L.debug("IDMSRecord vs Programs results:");
            int i = 0;
            while (i < results.length) {
                int currentCount;
                int temp;
                Integer countValue;
                String prgPath;
                String fileName = results[i][0];
                String prgName = results[i][1];
                String stmtType = results[i][2];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][3]));
                String parentName = results[i][4];
                if (Utils.filterNullValue((String)parentName) != null && !parentName.isEmpty()) {
                    prgName = String.valueOf(parentName) + ": " + prgName;
                }
                if ((prgPath = results[i][5]) != null && !prgPath.isEmpty()) {
                    prgName = prgName.concat(" (").concat(prgPath).concat(")");
                }
                L.debug("record:" + fileName);
                L.debug("program:" + prgName);
                L.debug("stmt type:" + stmtType);
                L.debug("count:" + stmtCount);
                L.debug("\n");
                Object4Report obj = new Object4Report();
                obj.setRecordName(fileName);
                obj.setProgramName(prgName);
                obj.setStmtType(stmtType);
                obj.setCount(stmtCount);
                HashMap<String, Integer> fileMap = (HashMap<String, Integer>)this.allPrgMap.get(fileName);
                if (fileMap == null) {
                    fileMap = new HashMap<String, Integer>();
                    this.allPrgMap.put(fileName, fileMap);
                }
                countValue = (countValue = (Integer)fileMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                fileMap.put(stmtType, countValue);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{fileName, prgName, stmtType, stmtCount.toString()});
                }
                this.resultList.add(obj);
                if (!this.accesCountMap.containsKey(fileName)) {
                    this.accesCountMap.put(fileName, stmtCount);
                } else {
                    temp = (Integer)this.accesCountMap.get(fileName);
                    currentCount = stmtCount;
                    this.accesCountMap.put(fileName, new Integer(temp + currentCount));
                }
                if (!this.stmtCountMap.containsKey(stmtType)) {
                    this.stmtCountMap.put(stmtType, stmtCount);
                } else {
                    temp = (Integer)this.stmtCountMap.get(stmtType);
                    currentCount = stmtCount;
                    this.stmtCountMap.put(stmtType, new Integer(temp + currentCount));
                }
                ++i;
            }
        }
    }

    protected String prepareAppendixResrsList(Set prgList) {
        String ret = "";
        ret = ret.concat(prgList.toString());
        Object selectedApps = this.report.getProperty("filtered by app");
        boolean projectIsUCMDB = (Boolean)this.inputs.get("project_isUCMDB");
        if (selectedApps != null && ((Boolean)selectedApps).booleanValue() && projectIsUCMDB) {
            Set apps = null;
            Iterator iterator = prgList.iterator();
            while (iterator.hasNext() && apps == null) {
                ProgramInputNoGUI prg = (ProgramInputNoGUI)iterator.next();
                if (prg.getApplications() == null || prg.getApplications().isEmpty()) continue;
                apps = prg.getApplications();
            }
            if (apps != null && !apps.isEmpty()) {
                ret = ret.concat("\n");
                ret = ret.concat(Messages.getString(((Object)((Object)this)).getClass(), "appendix.applications.part")).concat(apps.toString());
                this.setApplicationName(apps);
            }
        }
        return ret;
    }

    @Override
    public void cleanMemory() {
        if (this.accesCountMap != null) {
            this.accesCountMap.clear();
            this.accesCountMap = null;
        }
        if (this.allPrgMap != null) {
            this.allPrgMap.clear();
            this.allPrgMap = null;
        }
        if (this.resultList != null) {
            this.resultList.clear();
            this.resultList = null;
        }
        if (this.stmtCountMap != null) {
            this.stmtCountMap.clear();
            this.stmtCountMap = null;
        }
        super.cleanMemory();
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.idmsRecord"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

