/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.filesvsscl;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.filesVsPrograms.FilesVSProgramsReportBuilder;
import com.ez.report.application.ezreport.reports.wu.filesvsscl.ReportModel;
import com.ez.report.application.model.AbstractReport;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ReportBuilder
extends FilesVSProgramsReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String EZREP_PHYSICALNAME_VS_SCL = "EZReports_FilesPhysicalNameVsSCL";
    private static final String EZREP_PHYSICALNAME_VS_SCL_SEL = "EZReports_FilesPhysicalNameVsSCL_Selective";
    private static final String EZREP_PHYSICALNAME_VS_SCL_UCMDB = "EZReports_FilesPhysicalNameVsSCL_UCMDB";
    private static final String EZREP_PHYSICALNAME_VS_SCL_SEL_UCMDB = "EZReports_FilesPhysicalNameVsSCL_Selective_UCMDB";

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    protected String getProcedure() {
        String procName = null;
        procName = this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty() ? EZREP_PHYSICALNAME_VS_SCL_UCMDB : EZREP_PHYSICALNAME_VS_SCL;
        return procName;
    }

    @Override
    protected String getSelectiveProcedure() {
        String procName = null;
        procName = this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty() ? EZREP_PHYSICALNAME_VS_SCL_SEL_UCMDB : EZREP_PHYSICALNAME_VS_SCL_SEL;
        return procName;
    }

    @Override
    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            Collection selected = (Collection)this.inputs.get("selected resources");
            this.report.setInput((Object)selected);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", selectedApps);
            if (selectedApps != null) {
                Collection appNames = (Collection)this.inputs.get("selected applications names");
                for (ProgramInputNoGUI prg : selected) {
                    prg.setApplicationsName((Set)appNames);
                }
            }
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        super.putExternalizedParameters(params);
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.file"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

