/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.filesvsscl;

import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceFile;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.wizard.GenericSelectInputPage4Report;
import com.ez.report.application.ezreport.reports.wu.filesVsPrograms.FilesVsProgramsAnalysis;
import com.ez.report.application.ezreport.reports.wu.filesvsscl.FilesCollector;
import com.ez.report.application.ezreport.reports.wu.filesvsscl.FilesVsSclJob;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FilesVsSclAnalysis
extends FilesVsProgramsAnalysis {
    private static final String EMPTY_NAME_VALUE = "[empty]";

    public FilesVsSclAnalysis() {
        this(null);
    }

    public FilesVsSclAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    public void setInputs(List inputs) {
        if (inputs != null) {
            ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
            ArrayList<BaseMainframeResourceInput> sel = new ArrayList<BaseMainframeResourceInput>();
            HashSet<String> inputNames = new HashSet<String>();
            for (Object inpObj : inputs) {
                if (inpObj instanceof EZSourceProjectInputType) {
                    String prjName = ((EZSourceProjectInputType)inpObj).getName();
                    if (prjName != null) {
                        this.setPrjName(prjName);
                        this.addContextValue("input_project_names", prjName);
                    }
                    this.addContextValue("input_list", inputs);
                    ProjectInfo pInfo = (ProjectInfo)((EZSourceProjectInputType)inpObj).getProperty("PROJECT_INFO");
                    com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                    this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
                    continue;
                }
                if (!(inpObj instanceof EZSourceFile)) continue;
                EZSourceFile file = (EZSourceFile)inpObj;
                EZEntityID entity = file.getEntID();
                list.add(entity);
                EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
                if (prjSg == null) continue;
                if (!prjSg.getProjectName().equals(this.projectName)) {
                    this.setPrjName(prjSg.getProjectName());
                    this.addContextValue("input_project_names", prjSg.getProjectName());
                    ProjectInfo pInfo = prjSg.getProjectInfo();
                    com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                    this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
                }
                String name = (String)(file.hasPhysicalFile() ? file.getProperty("isPhysicalFile attribute") : file.getName());
                sel.add((BaseMainframeResourceInput)new ProgramInputNoGUI(name));
                inputNames.add(name);
            }
            if (!sel.isEmpty()) {
                this.setParams(sel);
                this.addAllContextValues(this.params);
                this.addContextValue("input_list", list);
                this.addContextValue("inputs name string", inputNames);
            }
        }
    }

    @Override
    public PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(FilesVsSclAnalysis.class, "wizard.title");
        wizard.setWindowTitle(wizardName);
        GenericSelectInputPage4Report selectProgramsPage = new GenericSelectInputPage4Report("programs page");
        selectProgramsPage.setLeftGroupLabel(Messages.getString(FilesVsSclAnalysis.class, "av.wizard.objectType"));
        selectProgramsPage.setRightGroupLabel(Messages.getString(FilesVsSclAnalysis.class, "sel.wizard.objectType"));
        FilesCollector pc = this.getFilesCollector();
        selectProgramsPage.setResourcesCollector((ResourcesCollector)pc);
        wizard.addPage(selectProgramsPage);
        return wizard;
    }

    private FilesCollector getFilesCollector() {
        String filesQuery = "select distinct SCLSystemFiles.Name FROM Files left join programs on programs.programid=files.progid  left join SCLSystemFiles on Files.OccurID = SCLSystemFiles.OccurId and (SCLSystemFiles.fileId = Files.FileID) Where SCLSystemFiles.Name IS NOT NULL AND (files.TypeCode <> 32 OR files.TypeCode IS NULL) AND programs.programtypeid in (19) ORDER BY SCLSystemFiles.Name";
        FilesCollector pc = new FilesCollector();
        pc.setQuery(filesQuery);
        pc.setDefaultEmptyEntryName(EMPTY_NAME_VALUE);
        return pc;
    }

    @Override
    protected AbstractAnalysisJob getJob(EZEntityID arg0) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(this.id, FilesVsSclJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    @Override
    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_FILES_VS_SCL_ANALYSIS;
    }
}

